/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.convert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class Convert {
    private Setup setup;
    private int mid;

    public static void main(String[] args) {
        if (args.length > 0) {
            new Convert(args[0]);
        } else {
            System.out.println("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 mid");
        }
    }

    public Convert(String midStr) {
        Connection con = null;
        try {
            this.mid = Utils.parseInt((String)midStr);
            if (this.mid == 0) {
                System.out.println("mid \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439");
                return;
            }
            this.setup = new Setup("data", "data");
            Setup.setSetup((Setup)this.setup);
            this.setup.initConnectionPool();
            con = this.setup.getDBConnection();
            this.convert(con);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ServerUtils.closeConnection(con);
        }
    }

    private void convert(Connection con) throws SQLException {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        int count = 0;
        System.out.println("start convert agent for DrWeb...");
        HashMap<String, Integer> tariffs = new HashMap<String, Integer>();
        String query = "SELECT * FROM drweb_tariffs_" + this.mid;
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            int id = rs.getInt("id");
            String group = rs.getString("group_title");
            tariffs.put(group, id);
        }
        rs.close();
        query = "SELECT * FROM drweb_contract_agent_" + this.mid;
        rs = st.executeQuery(query);
        query = "UPDATE drweb_contract_agent_" + this.mid + " SET tariff_id=? , next_tariff_id=?, graceperiod = 0, new_agent=0  WHERE id = ?";
        PreparedStatement ps = con.prepareStatement(query);
        while (rs.next()) {
            ++count;
            int id = rs.getInt("id");
            String groupTitle = rs.getString("group_title");
            Integer tariffId = (Integer)tariffs.get(groupTitle);
            Integer nextTariffId = null;
            if (tariffId == null) {
                System.out.println("error find tariff for group => " + groupTitle + " for agent => " + id);
                errorList.add(id);
                continue;
            }
            if (rs.getInt("next_status") == 3) {
                String data = rs.getString("data");
                Map dataMap = Utils.stringToPairsHash((String)data);
                String nextGroup = (String)dataMap.get("nextTariff");
                if (nextGroup == null) {
                    System.out.println("error not define next_group for agent => " + id);
                    errorList.add(id);
                    continue;
                }
                nextTariffId = (Integer)tariffs.get(nextGroup);
                if (nextTariffId == null) {
                    System.out.println("error find tariff for next group => " + groupTitle + " for agent => " + id);
                    errorList.add(id);
                    continue;
                }
            } else {
                nextTariffId = -1;
            }
            int index = 1;
            ps.setInt(index++, tariffId);
            ps.setInt(index++, nextTariffId);
            ps.setInt(index++, id);
            ps.executeUpdate();
        }
        rs.close();
        ps.close();
        System.out.println("stop convert agent for DrWeb...Ok");
        System.out.println("all agents => " + count);
        System.out.println("convert => " + (count - errorList.size()));
        System.out.println("convert ERROR=> " + errorList.size());
        System.out.print("error id  => ");
        Iterator iterator = errorList.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            System.out.print(id + ",");
        }
        System.out.println("");
        System.out.println("exit");
    }
}

