/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.access;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Set;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifyEvent;
import ru.bitel.common.Utils;

@XmlRootElement
public class InetServDeviceStateAndOptionsModifiedEvent
extends Event {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int servId;
    @XmlAttribute
    private final short deviceState;
    @XmlAttribute
    private final Set<Integer> deviceOptions;

    protected InetServDeviceStateAndOptionsModifiedEvent() {
        this.deviceId = -1;
        this.servId = -1;
        this.deviceState = (short)-1;
        this.deviceOptions = null;
    }

    public InetServDeviceStateAndOptionsModifiedEvent(InetServDeviceStateAndOptionsModifyEvent modify) {
        super(modify.getModuleId(), modify.getContractId(), modify.getUserId());
        this.deviceId = modify.getDeviceId();
        this.servId = modify.getInetServId();
        this.deviceState = modify.getDeviceState();
        this.deviceOptions = modify.getDeviceOptions();
    }

    @Deprecated
    public InetServDeviceStateAndOptionsModifiedEvent(int moduleId, int deviceId, int inetContractServId, short state, Set<Integer> optionSet) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.deviceId = deviceId;
        this.servId = inetContractServId;
        this.deviceState = state;
        this.deviceOptions = optionSet;
    }

    public InetServDeviceStateAndOptionsModifiedEvent(int moduleId, int deviceId, int contractId, int inetServId, short state, Set<Integer> optionSet) {
        super(moduleId, contractId, -1);
        this.deviceId = deviceId;
        this.servId = inetServId;
        this.deviceState = state;
        this.deviceOptions = optionSet;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getServId() {
        return this.servId;
    }

    public short getDeviceState() {
        return this.deviceState;
    }

    public Set<Integer> getDeviceOptions() {
        return this.deviceOptions;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetServId: ");
        sb.append(this.servId);
        sb.append("; state: ");
        sb.append(this.deviceState);
        sb.append("; optionSet: ");
        sb.append(Utils.toString(this.deviceOptions));
    }
}

