/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.SuperCardModule;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.Trace;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CardManager
extends AbstarctDaoConstant {
    public CardManager(Connection con, int moduleId) {
        super(con, moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Card getCardFromSuperDB(long login, Trace trace) {
        Card result = null;
        SuperCardModule superModule = this.getCardSuperModule();
        if (superModule != null) {
            if (trace != null) {
                trace.addReportLine(new Object[]{"Try to found card in supermodule"});
            }
            Connection con = null;
            try {
                con = superModule.getSuperSetup().getDBConnectionFromPool();
                String query = "SELECT * FROM card_data_" + superModule.getSuperModuleId() + " WHERE card_code=? ORDER BY id DESC LIMIT 1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setLong(1, login);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    if (trace != null) {
                        trace.addReportLine(new Object[]{"Supercard was found"});
                    }
                    result = this.getCardFromRs(rs);
                    result.setType(2);
                    result.setContractId(superModule.getSuperContractId());
                    result.setServiceActivateId(superModule.getActivateServiceId());
                    result.setServicePayId(superModule.getPayServiceId());
                    result.setPatternId(superModule.getPatternId());
                    int remotePaymentTypeId = result.getPaymentType();
                    Integer localPaymentTypeId = superModule.getPaymentTypeMap().get(remotePaymentTypeId);
                    if (localPaymentTypeId == null) {
                        localPaymentTypeId = superModule.getPaymentTypeMap().get(0);
                    }
                    result.setPaymentType(localPaymentTypeId == null ? 0 : localPaymentTypeId);
                    result.setDealerId(superModule.getDealerId());
                }
                rs.close();
                ps.close();
            }
            catch (Exception e) {
                if (trace != null) {
                    trace.addReportLine(new Object[]{"Error supercard found ", e.getMessage()});
                }
                e.printStackTrace();
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuperCardModule getCardSuperModule() {
        String keySuperExist = "super_card_exist_" + this.moduleId;
        String keySuperModule = "super_card_config_" + this.moduleId;
        SuperCardModule superModule = null;
        Setup setup = Setup.getSetup();
        Object superCardExist = setup.getObject(keySuperExist);
        if (superCardExist == null) {
            Connection con = null;
            try {
                con = setup.getDBConnectionFromPool();
                ModuleSetup moduleSetup = new ModuleSetup(con, this.moduleId);
                String dbDriver = moduleSetup.get("super.db.driver", null);
                String dbUrl = moduleSetup.get("super.db.url", null);
                String dbUser = moduleSetup.get("super.db.user", null);
                String dbPswd = moduleSetup.get("super.db.pswd", "");
                String dbMaxActive = moduleSetup.get("super.db.maxActive", null);
                String dbMaxIdle = moduleSetup.get("super.db.maxIdle", null);
                int superMid = moduleSetup.getInt("super.mid", 0);
                int superCid = moduleSetup.getInt("super.cid", 0);
                int dealerId = moduleSetup.getInt("super.dealer.id", 0);
                int actService = moduleSetup.getInt("super.act.sid", 0);
                int payService = moduleSetup.getInt("super.pay.sid", 0);
                int patternId = moduleSetup.getInt("super.pattern.id", 0);
                String paymentType = moduleSetup.get("super.payment.type", "");
                if (superMid > 0 && superCid > 0 && actService > 0 && payService > 0 && Utils.notBlankString((String)paymentType) && patternId > 0 && dealerId > 0 && Utils.notBlankString((String)dbDriver) && Utils.notBlankString((String)dbUrl) && Utils.notBlankString((String)dbUser)) {
                    DefaultServerSetup superDbSetup = new DefaultServerSetup();
                    superDbSetup.set("db.driver", dbDriver);
                    superDbSetup.set("db.url", dbUrl);
                    superDbSetup.set("db.user", dbUser);
                    superDbSetup.set("db.pswd", dbPswd);
                    if (Utils.notBlankString((String)dbMaxActive)) {
                        superDbSetup.set("db.maxActive", dbMaxActive);
                    }
                    if (Utils.notBlankString((String)dbMaxIdle)) {
                        superDbSetup.set("db.maxIdle", dbMaxIdle);
                    }
                    superDbSetup.initConnectionPool();
                    superModule = new SuperCardModule();
                    superModule.setSuperSetup(superDbSetup);
                    superModule.setSuperModuleId(superMid);
                    superModule.setSuperContractId(superCid);
                    superModule.setDealerId(dealerId);
                    superModule.setPatternId(patternId);
                    superModule.setActivateServiceId(actService);
                    superModule.setPayServiceId(payService);
                    int intPaymentTypeId = Utils.parseInt((String)paymentType);
                    if (intPaymentTypeId > 0) {
                        superModule.addToPaymentTypeMap(0, intPaymentTypeId);
                    } else {
                        String[] pairs;
                        for (String pair : pairs = paymentType.split(";")) {
                            String[] remote_local = pair.split(":");
                            if (remote_local.length != 2) continue;
                            superModule.addToPaymentTypeMap(Utils.parseInt((String)remote_local[0]), Utils.parseInt((String)remote_local[1]));
                        }
                    }
                    setup.putObject(keySuperModule, (Object)superModule);
                    setup.putObject(keySuperExist, (Object)Boolean.TRUE);
                }
                setup.putObject(keySuperExist, (Object)Boolean.FALSE);
                this.getLogger().error("Error supercard init, params error, super.mid=" + superMid + "; super.cid=" + superCid + "; super.dealer.id=" + dealerId + "; super.act.sid=" + actService + "; super.pay.sid=" + payService + "; super.pattern.id=" + patternId + "; super.payment.type=" + paymentType);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        } else if (Boolean.TRUE.equals(superCardExist)) {
            superModule = (SuperCardModule)setup.getObject(keySuperModule);
        }
        return superModule;
    }

    public Card findCard(String userName) throws SQLException {
        return this.findCard(userName, null);
    }

    public Card findCard(String userName, Trace tracer) throws SQLException {
        Card card = null;
        long login = Utils.parseLong((String)userName, (long)-1L);
        if (this.moduleId > 0 && login >= 0L) {
            String query = "SELECT * FROM card_data_" + this.moduleId + " WHERE card_code=? ORDER BY id DESC LIMIT 1";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setLong(1, login);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        card = this.getCardFromRs(rs);
                        card.setType(1);
                    }
                }
            }
        }
        if (tracer != null) {
            tracer.addReportLine(new Object[]{"Not found card in local base"});
        }
        if (card == null) {
            card = this.getCardFromSuperDB(login, tracer);
        }
        return card;
    }

    private Card getCardFromRs(ResultSet rs) throws SQLException {
        Card card = new Card();
        card.setMid(this.moduleId);
        card.setSeriesId(rs.getInt("cs_id"));
        card.setId(rs.getLong("id"));
        card.setCardCode(rs.getLong("card_code"));
        card.setCardPinCode(rs.getString("card_pin_code"));
        card.setSumma(rs.getFloat("summa"));
        card.setDateBegin(rs.getDate("date1"));
        card.setDateEnd(rs.getDate("date2"));
        card.setStatus(rs.getInt("status"));
        card.setDealerId(rs.getInt("did"));
        card.setServicePayId(rs.getInt("sid_pay"));
        card.setServiceActivateId(rs.getInt("sid_act"));
        card.setContractId(rs.getInt("cid"));
        card.setDateActivate(rs.getDate("date"));
        card.setPatternId(rs.getInt("pid"));
        card.setPaymentType(rs.getInt("pt"));
        return card;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addCard(Connection connection, Card card) {
        String result = null;
        Connection con = connection != null ? connection : this.con;
        try {
            int pos = 1;
            String query = "INSERT INTO card_data_" + this.moduleId + " SET id=?, cs_id=?, card_code=?, card_pin_code=?, summa=?, date1=?, date2=?, pid=?, sid_pay=?, sid_act=?, pt=?, did=?, d_date=?, cid=?, date=?, status=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setLong(pos++, card.getId());
            ps.setInt(pos++, card.getSeriesId());
            ps.setLong(pos++, card.getCardCode());
            ps.setString(pos++, card.getCardPinCode());
            ps.setFloat(pos++, card.getSumma());
            ps.setDate(pos++, TimeUtils.convertDateToSqlDate((Date)card.getDateBegin()));
            ps.setDate(pos++, TimeUtils.convertDateToSqlDate((Date)card.getDateEnd()));
            ps.setInt(pos++, card.getPatternId());
            ps.setInt(pos++, card.getServicePayId());
            ps.setInt(pos++, card.getServiceActivateId());
            ps.setInt(pos++, card.getPaymentType());
            ps.setInt(pos++, card.getDealerId());
            ps.setDate(pos++, TimeUtils.convertCalendarToSqlDate((Calendar)card.getDealerDate()));
            ps.setInt(pos++, card.getContractId());
            ps.setTimestamp(pos++, TimeUtils.convertDateToTimestamp((Date)card.getDateActivate()));
            ps.setInt(pos++, card.getStatus());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            result = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0432 \u0431\u0430\u0437\u0443 " + ex.getLocalizedMessage();
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkCard(Card card) {
        String result = null;
        try {
            String query = "SELECT id FROM card_data_" + this.moduleId + " WHERE card_code=? AND status IN ( ?, ?, ? )";
            PreparedStatement psCheck = this.con.prepareStatement(query);
            psCheck.setLong(1, card.getCardCode());
            psCheck.setInt(2, 0);
            psCheck.setInt(3, 1);
            psCheck.setInt(4, 2);
            ResultSet rs = psCheck.executeQuery();
            if (rs.next()) {
                result = "\u041a\u0430\u0440\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043a\u043e\u0434\u043e\u043c \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430: '" + card.getCardCode() + "' ;\u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: " + rs.getString(1);
            }
        }
        catch (Exception ex) {
            result = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u0430\u0440\u0442\u044b " + ex.getLocalizedMessage();
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activated(Card card, int type) {
        int _mid;
        Setup _setup;
        int cid;
        boolean result = false;
        if (card.getType() == 1) {
            cid = card.getContractId();
            _setup = Setup.getSetup();
            _mid = this.moduleId;
        } else {
            SuperCardModule superModule = this.getCardSuperModule();
            cid = superModule.getSuperContractId();
            _setup = superModule.getSuperSetup();
            _mid = superModule.getSuperModuleId();
        }
        Connection con = null;
        try {
            con = _setup.getDBConnectionFromPool();
            String query = "UPDATE card_data_" + _mid + " SET status=?, cid=?, date=NOW() WHERE id=? AND status=1";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, type);
            ps.setInt(2, cid);
            ps.setLong(3, card.getId());
            result = ps.executeUpdate() > 0;
            ps.close();
            card.setStatus(type);
            card.setDateActivate(new Date());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        if (result && card.getType() == 2) {
            this.addCard(null, card);
        }
        return result;
    }

    @Deprecated
    public void addCardToContract(Calendar time, Card card, int contractId, ServerContext context) {
        if (card != null && card.getStatus() == 1) {
            try {
                Payment payment = Payment.builder().setDate(TimeUtils.convertCalendarToDate((Calendar)time)).setContractId(contractId).setTypeId(card.getPaymentType()).setSum(new BigDecimal(card.getSumma())).setComment("N " + card.getId()).build();
                new PaymentDao(this.con).update((Object)payment);
                String query = "insert into contract_balance ( yy, mm, cid, summa2 ) values ( ?, ?, ?, ? )";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setInt(1, time.get(1));
                    ps.setInt(2, time.get(2) + 1);
                    ps.setInt(3, contractId);
                    ps.setFloat(4, card.getSumma());
                    ps.executeUpdate();
                }
                card.setContractId(contractId);
                context.publishAfterCommit((Event)new PaymentEvent(0, payment));
                context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contractId, 3, payment.getSum()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addCardToContract(Connection con, Calendar time, Card card, int contractId) throws BGException {
        this.addCardToContract(null, con, time, card, contractId);
    }

    public void addCardToContract(ServerContext context, Connection con, Calendar time, Card card, int contractId) throws BGException {
        if (card != null && card.getStatus() == 1) {
            try {
                Payment payment = Payment.builder().setDate(TimeUtils.convertCalendarToDate((Calendar)time)).setContractId(contractId).setTypeId(card.getPaymentType()).setSum(new BigDecimal(card.getSumma())).setComment("N " + card.getId()).build();
                new PaymentDao(con).update((Object)payment);
                String query = "insert into contract_balance ( yy, mm, cid, summa2 ) values ( ?, ?, ?, ? )";
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setInt(1, time.get(1));
                    ps.setInt(2, time.get(2) + 1);
                    ps.setInt(3, contractId);
                    ps.setFloat(4, card.getSumma());
                    ps.executeUpdate();
                }
                card.setContractId(contractId);
                if (context != null) {
                    context.publishAfterCommit((Event)new PaymentEvent(0, payment));
                    context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contractId, 3, payment.getSum()));
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public List<Card> getCards(String idList) {
        ArrayList<Card> result = new ArrayList<Card>();
        try {
            String query = "SELECT * FROM card_data_" + this.moduleId + " WHERE id IN ( " + idList + ")";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                result.add(this.getCardFromRs(rs));
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addCardsToDealer(int dealerId, Calendar date, String cards) {
        try {
            if (Utils.notBlankString((String)cards)) {
                String query = "UPDATE card_data_" + this.moduleId + " SET did=?, d_date=?, status=1 WHERE id IN (" + cards + ")";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, dealerId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCardStatus(String cards, int newStatus) throws SQLException {
        if (Utils.notBlankString((String)cards)) {
            String query = "UPDATE card_data_" + this.moduleId + " SET status=? WHERE id IN (" + cards + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, newStatus);
                ps.executeUpdate();
            }
        }
    }

    public void deleteContractCards(int contractId) throws SQLException {
        String query = "DELETE FROM card_data_" + this.moduleId + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }
}

