/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.cerbercrypt.client.ServiceConfigPackets;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.ChannelService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGLabeledControl;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PacketEditor
extends BGUPanel {
    private ServiceConfigPackets packetsPanel;
    private PacketChannel packetChannelCurrent = null;
    private BGUTable table;
    private BGTableModel<PacketChannel> model;
    private JTextField titleTF = new BGTextField();
    private JCheckBox canWebOpen = new JCheckBox("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u0440\u0435\u0437 WEB");
    private JCheckBox canWebClose = new JCheckBox("\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u0440\u0435\u0437 WEB");
    private BGUComboBox<IdTitle> serviceCB = new BGUComboBox();
    private JCheckBox virtualCinemaCB = new JCheckBox("\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b");
    private JCheckBox freeCB = new JCheckBox("\u041d\u0435 \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u043c\u044b\u0439");
    private JPanel editorPanel = new JPanel();
    private BGUComboBox<IdTitle> channelCB = new BGUComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JTextArea commentTA = new JTextArea();
    private BGDialogToolBar propertyToolBar = new BGDialogToolBar();
    private JTabbedPane pane = new JTabbedPane();
    private BGControlPanelListSelect depends = new BGControlPanelListSelect();
    private BGControlPanelListSelect unacceptable = new BGControlPanelListSelect();
    private BGTextField pcode = new BGTextField();
    private BGTextField servercode = new BGTextField();
    private final BGTextArea packetCommentTA = new BGTextArea();
    private final BGButton packetCommentEditButton = new BGButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    private int packetId;
    private boolean init = false;

    public PacketEditor() {
        this.model = new BGTableModel<PacketChannel>("PacketChannel"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, 150, 150, -1, "period", false);
                this.addColumn("\u041a\u0430\u043d\u0430\u043b", 150, 150, -1, "channelTitle", false);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false);
            }

            public Object getValue(PacketChannel val, int column) throws Exception {
                if (column == 1) {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setAutoCreateRowSorter(true);
        this.pcode.setColumns(5);
        this.servercode.setColumns(5);
        this.commentTA.setWrapStyleWord(true);
        this.commentTA.setLineWrap(true);
        BGButtonPanelOkCancel yesNoPanel = new BGButtonPanelOkCancel();
        yesNoPanel.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.performAction("stopPacketChannelEdit_Save");
            } else {
                this.editorPanel.setVisible(false);
            }
        });
        JButton okButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        okButton.addActionListener(e -> this.performAction("updatePacket"));
        JPanel panel1 = new JPanel(new GridBagLayout());
        panel1.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 3), 0, 0));
        panel1.add((Component)this.titleTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 3), 0, 0));
        panel1.add((Component)this.serviceCB, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.canWebOpen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.canWebClose, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.virtualCinemaCB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add((Component)this.freeCB, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel4 = new JPanel(new GridBagLayout());
        panel4.add((Component)new BGLabeledControl((Component)this.pcode, "\u041d\u043e\u043c\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 (\u043a\u043e\u0434):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel4.add((Component)new BGLabeledControl((Component)this.servercode, "\u0421\u0435\u0440\u0432\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel4.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u043a\u0435\u0442 "));
        topPanel.add((Component)panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)panel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)okButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        JPanel tabPacket = new JPanel(new GridBagLayout());
        tabPacket.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a\u0430\u043d\u0430\u043b\u043e\u0432 "));
        tablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel tabPacketChannel = new JPanel(new GridBagLayout());
        tabPacketChannel.add((Component)tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.add((Component)tabPacket, "\u041f\u0430\u043a\u0435\u0442");
        this.pane.add((Component)tabPacketChannel, "\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a\u0430\u043d\u0430\u043b\u043e\u0432");
        this.setLayout(new GridBagLayout());
        this.setSize(600, 300);
        this.add(this.pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel leftEditorPanel = new JPanel(new GridBagLayout());
        leftEditorPanel.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        leftEditorPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 3), 0, 0));
        leftEditorPanel.add((Component)new JLabel("\u041a\u0430\u043d\u0430\u043b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 3), 0, 0));
        leftEditorPanel.add((Component)this.channelCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 3), 0, 0));
        JPanel rightEditorPanel = new JPanel(new GridBagLayout());
        rightEditorPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        rightEditorPanel.add((Component)new JScrollPane(this.commentTA), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)leftEditorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)rightEditorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)yesNoPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        tabPacketChannel.add((Component)this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buildPropertyToolBar();
        this.add((Component)this.propertyToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 0, 0), 0, 0));
        ClientUtils.addOpenAction((Component)this.table, e -> {
            this.packetChannelCurrent = (PacketChannel)this.model.getSelectedRow();
            if (this.packetChannelCurrent != null) {
                this.performAction("startPacketChannelEdit");
            }
        });
        this.editorPanel.setVisible(false);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PacketEditor.this.performAction("refresh");
            }
        });
        this.editorPanel.setMinimumSize(new Dimension(100, 150));
        this.editorPanel.setPreferredSize(new Dimension(100, 150));
        JPanel panel3 = new JPanel(new GridBagLayout());
        this.depends.setBorder((Border)new BGTitleBorder(" \u0417\u0430\u0432\u0438\u0441\u0438\u0442 \u043e\u0442 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 "));
        this.unacceptable.setBorder((Border)new BGTitleBorder(" \u041d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u043f\u0430\u043a\u0435\u0442\u0430\u043c\u0438 "));
        panel3.add((Component)this.depends, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel3.add((Component)this.unacceptable, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        tabPacket.add((Component)panel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setPacketCommentEditable(false);
        JPanel topPanelComment = new JPanel(new GridBagLayout());
        topPanelComment.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        topPanelComment.add((Component)this.packetCommentTA, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        topPanelComment.add((Component)this.packetCommentEditButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.packetCommentEditButton.addActionListener(e -> {
            if (!this.packetCommentTA.isEditable()) {
                this.setPacketCommentEditable(true);
            } else {
                this.performAction("updatePacket");
                this.setPacketCommentEditable(false);
            }
        });
        tabPacket.add((Component)topPanelComment, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void jbInit() throws Exception {
    }

    private void setPacketCommentEditable(boolean editable) {
        this.packetCommentTA.setEditable(editable);
        this.packetCommentTA.setBackground(editable ? Color.WHITE : Color.LIGHT_GRAY);
        this.packetCommentEditButton.setText(editable ? "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c" : "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    }

    private void buildPropertyToolBar() {
        this.propertyToolBar.setDefaultButtons(e -> {
            String command = e.getActionCommand();
            if (command.equals("newItem")) {
                this.packetChannelCurrent = null;
                this.performAction("startPacketChannelEdit");
            } else if (command.equals("editItem")) {
                this.packetChannelCurrent = (PacketChannel)this.model.getSelectedRow();
                if (this.packetChannelCurrent != null) {
                    this.performAction("startPacketChannelEdit");
                }
            } else if (command.equals("deleteItem")) {
                this.packetChannelCurrent = (PacketChannel)this.model.getSelectedRow();
                if (this.packetChannelCurrent != null) {
                    this.performAction("deletePacketChannel");
                }
            } else if (command.equals("refresh")) {
                this.performAction("refresh");
            }
        });
        this.propertyToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "separator", "refresh"});
        this.propertyToolBar.setFloatable(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                List channelList = ((ChannelService)((ClientContext)this.getContext()).getPort(ChannelService.class)).channelList();
                this.channelCB.setData(channelList.stream().map(a -> a.toIdTitle()).toList());
                Request req = new Request().setModule("contract").setModuleId(((ClientContext)this.getContext()).getModuleId()).setAction("ModuleServices");
                Document doc = TransferManager.getDocument((Request)req);
                ArrayList<IdTitle> serviceItems = new ArrayList<IdTitle>();
                serviceItems.add(IdTitle.NO_SELECT);
                if (ClientUtils.checkStatus((Document)doc)) {
                    XMLUtils.selectElements((Node)doc, (String)"//services/item").forEach(a -> serviceItems.add(new IdTitle(Utils.parseInt((String)a.getAttribute("id")), a.getAttribute("title"))));
                }
                this.serviceCB.setData(serviceItems);
                this.serviceCB.setSelectedIndex(0);
                this.init = true;
            }
            List packetList = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetList(null);
            this.depends.getList().setData(packetList.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            this.unacceptable.getList().setData(packetList.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            Packet packet = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).getPacket(this.packetId);
            this.titleTF.setText(packet.getTitle());
            ClientUtils.setComboBoxSelection(this.serviceCB, (int)packet.getServiceId());
            this.canWebOpen.setSelected(packet.isCanWebOpen());
            this.canWebClose.setSelected(packet.isCanWebClose());
            this.virtualCinemaCB.setSelected(packet.isVirtualCinema());
            this.freeCB.setSelected(packet.getFree());
            this.depends.setListValues(Utils.toString((Iterable)packet.getDepends()));
            this.unacceptable.setListValues(Utils.toString((Iterable)packet.getUnacceptable()));
            this.pcode.setText(packet.getPacketCode());
            this.servercode.setText(packet.getPacketServerCode());
            this.packetCommentTA.setText(packet.getComment());
            List packetChannel = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetChannelTable(this.packetId);
            this.model.setData(packetChannel);
        });
        new AbstractBGUPanel.DefaultAction("updatePacket", "updatePacket"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isEmptyString((String)PacketEditor.this.titleTF.getText().trim())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430!");
                    return;
                }
                IdTitle serviceItem = (IdTitle)PacketEditor.this.serviceCB.getSelectedItem();
                if (serviceItem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0430");
                    return;
                }
                List ldepends = Utils.toIntegerList((String)PacketEditor.this.depends.getListValues());
                ldepends.remove((Object)PacketEditor.this.packetId);
                List lunacceptable = Utils.toIntegerList((String)PacketEditor.this.unacceptable.getListValues());
                lunacceptable.remove((Object)PacketEditor.this.packetId);
                Packet packet = new Packet(PacketEditor.this.packetId, PacketEditor.this.titleTF.getText()).setServiceId(serviceItem.getId()).setCanWebOpen(PacketEditor.this.canWebOpen.isSelected()).setCanWebClose(PacketEditor.this.canWebClose.isSelected()).setVirtualCinema(PacketEditor.this.virtualCinemaCB.isSelected()).setFree(PacketEditor.this.freeCB.isSelected()).setDepends(ldepends).setUnacceptable(lunacceptable).setPacketCode(PacketEditor.this.pcode.getText()).setPacketServerCode(PacketEditor.this.servercode.getText()).setComment(PacketEditor.this.packetCommentTA.getText());
                ((PacketService)((ClientContext)PacketEditor.this.getContext()).getPort(PacketService.class)).updatePacket(packet);
                PacketEditor.this.packetsPanel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("startPacketChannelEdit", "startPacketChannelEdit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (PacketEditor.this.packetChannelCurrent == null) {
                    PacketEditor.this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
                    PacketEditor.this.periodPanel.setDateString2("");
                    PacketEditor.this.commentTA.setText("");
                    PacketEditor.this.editorPanel.setVisible(true);
                } else {
                    PacketChannel packetChannel = ((PacketService)((ClientContext)PacketEditor.this.getContext()).getPort(PacketService.class)).getPacketChannel(PacketEditor.this.packetChannelCurrent.getId());
                    PacketEditor.this.periodPanel.setDateFrom(packetChannel.getDateFrom());
                    PacketEditor.this.periodPanel.setDateTo(packetChannel.getDateTo());
                    PacketEditor.this.channelCB.setSelectedItem((Object)packetChannel.getChannelId());
                    PacketEditor.this.commentTA.setText(packetChannel.getComment());
                    PacketEditor.this.editorPanel.setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("stopPacketChannelEdit_Save", "stopPacketChannelEdit_Save"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isEmptyString((String)PacketEditor.this.periodPanel.getDateString1())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                    return;
                }
                IdTitle channelitem = (IdTitle)PacketEditor.this.channelCB.getSelectedItem();
                if (channelitem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u043d\u0430\u043b");
                    return;
                }
                PacketChannel pc = new PacketChannel();
                pc.setId(PacketEditor.this.packetChannelCurrent != null ? PacketEditor.this.packetChannelCurrent.getId() : 0);
                pc.setPacketId(PacketEditor.this.packetId);
                pc.setDateFrom(PacketEditor.this.periodPanel.getDateFrom());
                pc.setDateTo(PacketEditor.this.periodPanel.getDateTo());
                pc.setChannelId(channelitem.getId());
                pc.setComment(PacketEditor.this.commentTA.getText());
                ((PacketService)((ClientContext)PacketEditor.this.getContext()).getPort(PacketService.class)).updatePacketChannel(pc);
                PacketEditor.this.editorPanel.setVisible(false);
                PacketEditor.this.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("deletePacketChannel", "deletePacketChannel"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (PacketEditor.this.packetChannelCurrent != null && ClientUtils.confirmDelete((Object)"\u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443")) {
                    ((PacketService)((ClientContext)PacketEditor.this.getContext()).getPort(PacketService.class)).deletePacketChannel(PacketEditor.this.packetChannelCurrent.getId());
                    PacketEditor.this.performAction("refresh");
                }
            }
        };
    }

    public void setPacketsPanel(ServiceConfigPackets packetsPanel) {
        this.packetsPanel = packetsPanel;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }
}

