/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.service;

import jakarta.activation.DataSource;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.common.service.EDOBillService;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillManager;
import ru.bitel.common.Utils;
import ru.bitel.common.ZipUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.edo.common.service.EDOBillService")
public class EDOBillServiceImpl
extends AbstractService
implements EDOBillService {
    public FileDto saveFile(String formatId, int billModuleId, List<Integer> billListIds, List<Integer> invoiceListIds) throws Exception {
        if (billModuleId <= 0) {
            throw new BGIllegalArgumentException("billModuleId");
        }
        int edoDocumentTypeId = 0;
        int signatoryId = 0;
        try {
            String[] ds = formatId.split("_");
            edoDocumentTypeId = Integer.valueOf(ds[0]);
            signatoryId = Integer.valueOf(ds[1]);
        }
        catch (Exception e) {
            throw new BGIllegalArgumentException("formatId");
        }
        EdoBillManager em = new EdoBillManager(this.getConnection(), billModuleId, this.userId);
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (Integer billId : Utils.maskNull(billListIds)) {
            dataSources.add(em.getDataSource(edoDocumentTypeId, signatoryId, null, DocumentType.BILL, billId));
        }
        for (Integer invoiceId : Utils.maskNull(invoiceListIds)) {
            dataSources.add(em.getDataSource(edoDocumentTypeId, signatoryId, null, DocumentType.INVOICE, invoiceId));
        }
        if (dataSources.isEmpty()) {
            throw new BGMessageException("\u043d\u0435\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        }
        return FileDto.fromDataSource((DataSource)(dataSources.size() == 1 ? (DataSource)dataSources.get(0) : ZipUtils.zippedDataSources(dataSources)));
    }

    public List<ExtDocument> send(String formatId, int billModuleId, List<Integer> billListIds, List<Integer> invoiceListIds) throws Exception {
        if (billModuleId <= 0) {
            throw new BGIllegalArgumentException("billModuleId");
        }
        int edoDocumentTypeId = 0;
        int signatoryId = 0;
        try {
            String[] ds = formatId.split("_");
            edoDocumentTypeId = Integer.valueOf(ds[0]);
            signatoryId = Integer.valueOf(ds[1]);
        }
        catch (Exception e) {
            throw new BGIllegalArgumentException("formatId");
        }
        LinkedList<ExtDocument> extDocuments = new LinkedList<ExtDocument>();
        EdoBillManager em = new EdoBillManager(this.getConnection(), billModuleId, this.userId);
        for (Integer billId : Utils.maskNull(billListIds)) {
            extDocuments.add(em.sendEdo(edoDocumentTypeId, signatoryId, null, DocumentType.BILL, billId));
        }
        for (Integer invoiceId : Utils.maskNull(invoiceListIds)) {
            extDocuments.add(em.sendEdo(edoDocumentTypeId, signatoryId, null, DocumentType.INVOICE, invoiceId));
        }
        return extDocuments;
    }

    public FileDto saveEdoFile(int billModuleId, String formatId, ContragentInfos contragentInfos, DocumentType billDocType, Integer billDocId) throws Exception {
        if (billModuleId <= 0) {
            throw new BGIllegalArgumentException("billModuleId");
        }
        int edoDocumentTypeId = 0;
        int signatoryId = 0;
        try {
            String[] ds = formatId.split("_");
            edoDocumentTypeId = Integer.valueOf(ds[0]);
            signatoryId = Integer.valueOf(ds[1]);
        }
        catch (Exception e) {
            throw new BGIllegalArgumentException("formatId");
        }
        EdoBillManager em = new EdoBillManager(this.getConnection(), billModuleId, this.userId);
        DataSource dataSource = em.getDataSource(edoDocumentTypeId, signatoryId, contragentInfos, billDocType, billDocId);
        return FileDto.fromDataSource((DataSource)dataSource);
    }

    public ExtDocument sendEdo(int billModuleId, String formatId, ContragentInfos contragentInfos, DocumentType billDocType, Integer billDocId) throws Exception {
        if (billModuleId <= 0) {
            throw new BGIllegalArgumentException("billModuleId");
        }
        int edoDocumentTypeId = 0;
        int signatoryId = 0;
        try {
            String[] ds = formatId.split("_");
            edoDocumentTypeId = Integer.valueOf(ds[0]);
            signatoryId = Integer.valueOf(ds[1]);
        }
        catch (Exception e) {
            throw new BGIllegalArgumentException("formatId");
        }
        EdoBillManager em = new EdoBillManager(this.getConnection(), billModuleId, this.userId);
        ExtDocument extDocument = em.sendEdo(edoDocumentTypeId, signatoryId, contragentInfos, billDocType, billDocId);
        return extDocument;
    }
}

