/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.twpg.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.twpg.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "twpg_transaction", moduleId);
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, SearchParam searchParam) throws SQLException {
        ResultSet rs;
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder queryFromWhere = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.create_date"));
        if (Utils.notBlankString((String)searchParam.getStatus())) {
            queryFromWhere.append(" AND pt.result=?");
        }
        if (Utils.notBlankString((String)searchParam.getContractTitle())) {
            queryFromWhere.append(" AND c.title LIKE ?");
        }
        if (searchParam.getContractId() > 0) {
            queryFromWhere.append(" AND c.id=").append(searchParam.getContractId());
        }
        String query = "SELECT pt.*, c.title AS contract_title" + queryFromWhere.toString() + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)searchParam.getStatus())) {
                ps.setString(index++, searchParam.getStatus());
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        ps = this.con.prepareStatement("SELECT SUM(pt.summa), COUNT(*) " + queryFromWhere.toString());
        try {
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)searchParam.getStatus())) {
                ps.setString(index++, searchParam.getStatus());
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    BigDecimal summa;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((summa = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(summa);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setAuthorizationCode(rs.getString("authorization_code")).setCard(rs.getString("card")).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("summa"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, authorization_code=?, card=?, result=?, params=?, summa=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getAuthorizationCode());
            ps.setString(index++, transaction.getCard());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }
}

