<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>
<xsl:template match="/">
   <html>
   <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   <style type="text/css"><![CDATA[
   th.thService, th.thAon, th { text-align: left; }
   ]]>
   </style>
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
		<xsl:call-template name="table"/><br/>
        <xsl:call-template name="summa"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
	<h2><xsl:value-of select="/data/@reportTitle"/><br/>
	Договор:&#160;<xsl:value-of select="/data/@contractTitle"/>(<xsl:value-of select="/data/@comment"/>)
	</h2><br/>
	Период с: <xsl:value-of select="/data/@date1"/> по <xsl:value-of select="/data/@date2"/>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
	<tr bgcolor="#f0f0f0">
		<td>Дата/время платежа</td>
		<td>Номер транзакции</td>
		<td>Номер договора</td>
		<td>Услуга</td>
		<td>Сумма платежа,<br/>руб.</td>
	</tr>
	<xsl:for-each select="/data/dealers/dealer">
		<tr>
			<td colspan="5" class="thAon">Дилер: <xsl:value-of select="@title"/></td>
		</tr>
	
		<xsl:for-each select="payment">
			<tr>
				<td><xsl:value-of select="@datetime"/></td>
				<td><xsl:value-of select="@trans"/></td>
				<td><xsl:value-of select="@contract"/></td>
				<td><xsl:value-of select="@pt"/></td>
				<td><xsl:value-of select="@summa"/></td>
			</tr>
		</xsl:for-each>
	         
		<tr>
			<td colspan="3">Итого по дилеру:</td>
			<td><xsl:value-of select="@totalnumber"/>&#160;шт.</td>
			<td><xsl:value-of select="@totalsumm"/>&#160;руб.</td>
		</tr>
	</xsl:for-each>
</table>
</xsl:template>

<xsl:template name="summa">
    <br/>
    Итого по всем дилерам:&#160;
    <xsl:value-of select="/data/dealers/@totalnumber"/>&#160;платежей на сумму&#160;
    <xsl:value-of select="/data/dealers/@totalsumm"/>
</xsl:template>

</xsl:stylesheet>
