/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.directory;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.crm.common.service.CRMService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class RegisterExecutorsEditor
extends BGPanel {
    private static final String MODULE_ADMIN_REGISTER = "ru.bitel.bgbilling.plugins.crm";
    private int editID = 0;
    private BGTable table = new BGTable();
    private JPanel editor_P = new JPanel(new GridBagLayout());
    private BGTextField name_TF = new BGTextField();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private BGControlPanelListSelect groups_P = new BGControlPanelListSelect(5);
    private BGButtonPanelOkCancel bGControlPanel_051 = new BGButtonPanelOkCancel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGPluginClient plugin = null;

    public RegisterExecutorsEditor() {
        try {
            this.jbInit();
            this.plugin = BGPluginManagerClient.getManager().getPlugin(MODULE_ADMIN_REGISTER);
            this.table.setHeader(this.plugin.getResourceBundle(), this.plugin.getTable("register_executor"), "register_executor");
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        RegisterExecutorsEditor.this.editItem();
                    }
                }
            });
            this.editor_P.setVisible(false);
            this.bGControlPanel_051.addActionListener(e -> {
                String command = e.getActionCommand();
                if (command != null) {
                    if (command.equals("ok")) {
                        this.save();
                    } else {
                        this.editor_P.setVisible(false);
                    }
                }
            });
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)new JScrollPane((Component)this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.groups_P.setMinimumSize(new Dimension(155, 200));
        this.groups_P.setPreferredSize(new Dimension(281, 200));
        this.tabbedPane.add((Component)this.groups_P, " \u0413\u0440\u0443\u043f\u043f\u044b ");
        this.tabbedPane.add((Component)configPanel, " \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b ");
        this.editor_P.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor_P.add((Component)new JLabel("\u0418\u043c\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor_P.add((Component)this.name_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.editor_P.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editor_P.add((Component)this.bGControlPanel_051, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.editor_P, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() throws Exception {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        Request request = new Request();
        request.setModule(MODULE_ADMIN_REGISTER);
        request.setAction("RegisterExecutorTable");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData((Node)XMLUtils.selectElement((Node)doc, (String)"//table"));
        }
    }

    private void init() {
        this.tryCall(() -> this.groups_P.getList().setData(ClientUtils.toBGUListItemList((List)((CRMService)this.getContext().getWebService(CRMService.class)).registerGroupList(0))));
    }

    private void startEdit() {
        this.name_TF.setText("");
        if (this.editID != 0) {
            Request request = new Request().setModule(MODULE_ADMIN_REGISTER).setAction("GetRegisterExecutor").setAttribute("id", this.editID);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                try {
                    Element executor = XMLUtils.selectElement((Node)doc, (String)"//executor");
                    this.name_TF.setText(executor.getAttribute("title"));
                    this.groups_P.setListValues(executor.getAttribute("groups"));
                    this.config.setText(executor.getAttribute("params"));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } else {
            this.name_TF.setText("");
            this.groups_P.setListValues("");
            this.config.setText("");
        }
        this.tabbedPane.setSelectedIndex(0);
        this.editor_P.setVisible(true);
    }

    public void deleteItem() {
        int id = ClientUtils.getRowId((BGTable)this.table);
        if (id != 9 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                ((CRMService)this.getContext().getWebService(CRMService.class)).registerExecutorDelete(id);
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void editItem() {
        this.editID = ClientUtils.getRowId((BGTable)this.table);
        if (this.editID != 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.editID = 0;
        this.startEdit();
    }

    private void save() {
        Request request = new Request();
        request.setModule(MODULE_ADMIN_REGISTER);
        request.setAction("UpdateRegisterExecutor");
        request.setAttribute("id", this.editID);
        String title = this.name_TF.getText();
        String groups = this.groups_P.getListValues();
        if (title.length() > 0 && groups.length() > 0) {
            request.setAttribute("title", title);
            request.setAttribute("groups", groups);
            request.setAttribute("params", this.config.getText());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.editor_P.setVisible(false);
                this.trySetData();
            }
        }
    }
}

