/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.bean;

import bitel.billing.common.ModelItem;
import bitel.billing.common.cache.CacheManagerClient;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

public class Request
implements Cloneable {
    private boolean sendServerURL = false;
    private Map<String, Object> data = new HashMap<String, Object>();

    public Request() {
    }

    protected Request(Map<String, Object> data) {
        this.data = data;
    }

    public void setSendServerURL(boolean value) {
        this.sendServerURL = value;
    }

    public boolean isSendServerURL() {
        return this.sendServerURL;
    }

    public Request setModule(String value) {
        if (value != null) {
            this.data.put("module", value);
        }
        return this;
    }

    public Request setAction(String value) {
        if (value != null) {
            this.data.put("action", value);
        }
        return this;
    }

    public Request setModuleId(String value) {
        if (value != null) {
            this.data.put("mid", value);
        }
        return this;
    }

    public Request setModuleId(int value) {
        if (value >= 0) {
            this.setModuleId(String.valueOf(value));
        }
        return this;
    }

    public Request setContractId(String value) {
        if (value != null) {
            this.data.put("cid", value);
        }
        return this;
    }

    public Request setContractId(int value) {
        if (value > 0) {
            this.setContractId(String.valueOf(value));
        }
        return this;
    }

    public Request setPageIndex(int pageIndex) {
        if (pageIndex >= 0) {
            this.setAttribute("pageIndex", pageIndex);
        }
        return this;
    }

    public Request setPageSize(int pageSize) {
        if (pageSize >= 0) {
            this.setAttribute("pageSize", pageSize);
        }
        return this;
    }

    public Request setPage(BGControlPanelPages panelPages) {
        this.setPageIndex(panelPages.getPageIndex());
        this.setPageSize(panelPages.getPageSize());
        return this;
    }

    public Request setPeriod(Period period) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        if (period != null) {
            if (period.getDateFrom() != null) {
                this.setAttribute("date1", format.format(period.getDateFrom()));
            }
            if (period.getDateTo() != null) {
                this.setAttribute("date2", format.format(period.getDateTo()));
            }
        }
        return this;
    }

    public Request setPeriod(PeriodWithTime period) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        if (period != null) {
            if (period.getDateFrom() != null) {
                this.setAttribute("date1", format.format(period.getDateFrom()));
            }
            if (period.getDateTo() != null) {
                this.setAttribute("date2", format.format(period.getDateTo()));
            }
        }
        return this;
    }

    public Request setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.data.put(name, value);
        }
        return this;
    }

    public Request setAttribute(String name, String value) {
        if (name != null && value != null) {
            this.data.put(name, value);
        }
        return this;
    }

    public Request setAttribute(String name, long value) {
        if (name != null) {
            this.data.put(name, String.valueOf(value));
        }
        return this;
    }

    public Request setAttribute(String name, int value) {
        if (name != null) {
            this.data.put(name, String.valueOf(value));
        }
        return this;
    }

    public Request setAttribute(String name, boolean value) {
        if (name != null) {
            this.data.put(name, value ? "1" : "0");
        }
        return this;
    }

    public void clear() {
        this.data.clear();
        this.sendServerURL = false;
    }

    public Object getValue(String key) {
        return key != null ? this.data.get(key) : null;
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    public Object clone() {
        Request request = new Request();
        for (String key : this.data.keySet()) {
            request.setAttribute(key, this.data.get(key));
        }
        return request;
    }

    public void addAll(Map<String, Object> params) {
        this.data.putAll(params);
    }

    public void addDirectory(String key) {
        String directory = (String)this.data.get("cache_directory");
        if (directory == null) {
            directory = "";
        }
        this.data.put("cache_directory", directory + key + ":" + String.valueOf(CacheManagerClient.getCacheManager().getVersion(key)) + ";");
    }

    public void addModel(ModelItem item) {
        for (String key : item.getAllowKeys()) {
            this.setAttribute(key, item.getValue(key));
        }
    }
}

