/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import bitel.billing.module.services.call.RadiusLogViewer;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToggleButton;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class ServiceReportPanel
extends ServicePanel {
    private String dest;
    private int unit = 1;
    protected int show_mode = 0;
    protected final int SESSION_SHOW_MODE = 0;
    protected final int BALANCE_SHOW_MODE = 1;
    protected final int DIR_SHOW_MODE = 2;
    protected BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGToggleButton amountToggleButton = new BGToggleButton();
    private BGToggleButton sessionToggleButton = new BGToggleButton();
    private BGToggleButton dirToggleButton = new BGToggleButton();
    private BGComboBox<ComboBoxItem> dirFilter = new BGComboBox();
    private JPanel dirFilterPanel = new JPanel(new GridBagLayout());
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ButtonGroup voiceIpFilterGroup = new ButtonGroup();
    private CardLayout cardLayout1 = new CardLayout();
    private JLabel timeSumLabel = new JLabel();
    private JLabel roundTimeSumLabel = new JLabel();
    private BGTextField timeSum = new BGTextField();
    private BGTextField roundTimeSum = new BGTextField();
    private BGTextField moneySum = new BGTextField();
    private BGTextField sessionsCount = new BGTextField();
    private BGTextField mask = new BGTextField();
    protected BGTable sessionTable = new BGTable();
    private BGTable accountTable = new BGTable();
    private BGTable dirTable = new BGTable();
    private JPanel voipPanel = null;
    protected DefaultListModel<BGUListItem> loginModel = new DefaultListModel();
    protected JList<BGUListItem> login = new JList<BGUListItem>(this.loginModel);
    private JPanel voipFilterPanel = null;
    private JPanel cardPanel = null;
    private JPanel sumPanel = null;
    private JCheckBox nofreeCheckBox = new JCheckBox();
    private JCheckBox noZeroTimeCheckBox = new JCheckBox();
    private JRadioButton allRadioBut = new JRadioButton();
    private JRadioButton outgoingRadioBut = new JRadioButton();
    private JRadioButton incomingRadioBut = new JRadioButton();
    private RadiusLogViewer radiusLog = new RadiusLogViewer();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JPanel unitPanel = null;
    boolean AccountSetColumn = false;
    boolean SessionSetColumn = false;
    private String selected = new String();
    boolean updating = false;

    public ServiceReportPanel() {
        this.tryCall(() -> this.jbInit());
    }

    private BGControlPanelPages createPagePanel() {
        BGControlPanelPages pagePanel = new BGControlPanelPages();
        pagePanel.init();
        pagePanel.setKey(this.getClass().getName());
        pagePanel.addToHandler(a -> this.trySetData());
        return pagePanel;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createLeftPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.createRigthPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createUnitPanel() {
        JToggleButton scaleValue_1 = new JToggleButton();
        JToggleButton scaleValue_2 = new JToggleButton();
        JToggleButton scaleValue_3 = new JToggleButton();
        JToggleButton scaleValue_4 = new JToggleButton();
        Insets insets = new Insets(0, 14, 0, 14);
        scaleValue_1.setMargin(insets);
        scaleValue_2.setMargin(insets);
        scaleValue_3.setMargin(insets);
        scaleValue_4.setMargin(insets);
        scaleValue_1.setActionCommand("1");
        scaleValue_1.setText("\u0431\u0430\u0439\u0442");
        scaleValue_1.setSelected(true);
        scaleValue_1.addActionListener(e -> this.scaleValue_1_actionPerformed(e));
        scaleValue_2.setActionCommand("1024");
        scaleValue_2.setText("\u041a\u0431");
        scaleValue_2.addActionListener(e -> this.scaleValue_1_actionPerformed(e));
        scaleValue_3.setActionCommand("1048576");
        scaleValue_3.setText("\u041c\u0431");
        scaleValue_3.addActionListener(e -> this.scaleValue_1_actionPerformed(e));
        scaleValue_4.setActionCommand("1073741824");
        scaleValue_4.setText("\u0413\u0431");
        scaleValue_4.addActionListener(e -> this.scaleValue_1_actionPerformed(e));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(scaleValue_1);
        buttonGroup1.add(scaleValue_2);
        buttonGroup1.add(scaleValue_3);
        buttonGroup1.add(scaleValue_4);
        JPanel unitPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder(unitPanel, " \u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f ");
        unitPanel.add((Component)scaleValue_1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        unitPanel.add((Component)scaleValue_2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        unitPanel.add((Component)scaleValue_3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        unitPanel.add((Component)scaleValue_4, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return unitPanel;
    }

    private JPanel createVoiceIpFilterPanel() {
        this.voiceIpFilterGroup.add(this.allRadioBut);
        this.voiceIpFilterGroup.add(this.incomingRadioBut);
        this.voiceIpFilterGroup.add(this.outgoingRadioBut);
        this.nofreeCheckBox.setToolTipText("\u0422\u043e\u043b\u044c\u043a\u043e \u0437\u0432\u043e\u043d\u043a\u0438 \u0441 \u043d\u0435\u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0446\u0435\u043d\u043e\u0439");
        this.nofreeCheckBox.setText("\u0422\u043e\u043b\u044c\u043a\u043e \u043f\u043b\u0430\u0442\u043d\u044b\u0435");
        this.noZeroTimeCheckBox.setToolTipText("\u0422\u043e\u043b\u044c\u043a\u043e \u0437\u0432\u043e\u043d\u043a\u0438 \u0432 \u043d\u0435\u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c\u044e \u0440\u0430\u0437\u0433\u043e\u0432\u043e\u0440\u0430");
        this.noZeroTimeCheckBox.setText("\u043d\u0435 0");
        this.allRadioBut.setSelected(true);
        this.allRadioBut.setText("\u0412\u0441\u0435");
        this.outgoingRadioBut.setText("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
        this.incomingRadioBut.setText("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        model.addElement(new ComboBoxItem("", "\u0411\u0435\u0437 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438"));
        model.addElement(new ComboBoxItem("name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u044e"));
        model.addElement(new ComboBoxItem("count", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0443"));
        model.addElement(new ComboBoxItem("time", "\u0412\u0440\u0435\u043c\u0435\u043d\u0438"));
        model.addElement(new ComboBoxItem("sum", "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438"));
        this.dirFilter.setModel(model);
        this.dirFilterPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dirFilterPanel.add(this.dirFilter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dirFilterPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(new Dimension(200, 25));
        panel.setPreferredSize(new Dimension(200, 25));
        panel.add((Component)this.allRadioBut, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.incomingRadioBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.outgoingRadioBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.nofreeCheckBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.noZeroTimeCheckBox, new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.dirFilterPanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(Box.createHorizontalStrut(8), new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createVoiceIpPanel() {
        this.mask.setColumns(10);
        this.mask.setHorizontalAlignment(0);
        this.dirToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.dirToggleButton.setText("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
        this.buttonGroup.add(this.dirToggleButton);
        this.dirToggleButton.addActionListener(e -> this.dirFilterPanel.setVisible(true));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0430\u0441\u043a\u0430 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.mask, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.dirToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createSummPanel() {
        Font font = new Font("Dialog", 0, 14);
        JPanel sumPanel = new JPanel(new GridBagLayout());
        this.timeSumLabel.setText("\u0412\u0440\u0435\u043c\u044f [\u0441\u0435\u043a.]:");
        this.roundTimeSumLabel.setText("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u0440.[\u0441\u0435\u043a.][\u043c\u0438\u043d.]:");
        this.sessionsCount.setFont(font);
        this.moneySum.setFont(font);
        this.timeSum.setFont(font);
        this.roundTimeSum.setFont(font);
        this.sessionsCount.setColumns(8);
        this.sessionsCount.setEditable(false);
        this.moneySum.setEditable(false);
        this.timeSum.setEditable(false);
        this.roundTimeSum.setEditable(false);
        sumPanel.add((Component)new JLabel("\u0421\u0435\u0441\u0441\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        sumPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        sumPanel.add((Component)this.sessionsCount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        sumPanel.add((Component)this.moneySum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        sumPanel.add((Component)this.timeSumLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        sumPanel.add((Component)this.roundTimeSumLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        sumPanel.add((Component)this.timeSum, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        sumPanel.add((Component)this.roundTimeSum, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        return sumPanel;
    }

    private JPanel createDirPanel() {
        this.dirTable.setHeader(this.rb_name, this.moduleDoc, "login_dir");
        BGSwingUtilites.handleLDMouseClicked(this.dirTable, e -> this.showSessionsForDest());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.dirTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel createAmountPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.accountTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSesionPanel() {
        JMenuItem radiusLogItem = new JMenuItem("RADIUS \u043b\u043e\u0433");
        radiusLogItem.addActionListener(e -> this.showRadiusLog());
        this.sessionTable.getPopupMenu().add(radiusLogItem);
        this.addRcMenuItems(this.sessionTable.getPopupMenu());
        BGSwingUtilites.handleLDMouseClicked(this.sessionTable, e -> this.showRadiusLog());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.sessionTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel createRigthPanel() {
        JPanel topPanel = this.createTopPanel();
        this.sumPanel = this.createSummPanel();
        this.voipFilterPanel = this.createVoiceIpFilterPanel();
        this.cardPanel = this.createCardPanel();
        this.radiusLog.setVisible(false);
        this.radiusLog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceReportPanel.this.sumPanel.setVisible(true);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ServiceReportPanel.this.sumPanel.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041b\u043e\u0433\u0438 "));
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.voipFilterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.cardPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.sumPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.radiusLog, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        return panel;
    }

    private JPanel createTopPanel() {
        this.amountToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.amountToggleButton.setText("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430");
        this.amountToggleButton.addActionListener(e -> this.dirFilterPanel.setVisible(false));
        this.sessionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.sessionToggleButton.setSelected(true);
        this.sessionToggleButton.setText("\u0421\u0435\u0441\u0441\u0438\u0438");
        this.sessionToggleButton.addActionListener(e -> this.dirFilterPanel.setVisible(false));
        this.buttonGroup.add(this.amountToggleButton);
        this.buttonGroup.add(this.sessionToggleButton);
        this.pagePanel = this.createPagePanel();
        this.voipPanel = this.createVoiceIpPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        panel.add((Component)this.amountToggleButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.sessionToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        result.add(Box.createGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)this.pagePanel, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        result.add((Component)this.voipPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return result;
    }

    private JPanel createCardPanel() {
        JPanel panel = new JPanel(this.cardLayout1);
        panel.add((Component)this.getSesionPanel(), "sessions");
        panel.add((Component)this.createAmountPanel(), "amounts");
        panel.add((Component)this.createDirPanel(), "dirs");
        return panel;
    }

    private JPanel createLeftPanel() {
        this.periodPanel.addActionListener(e -> this.getLoginList());
        this.periodPanel.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.unitPanel = this.createUnitPanel();
        BGButtonPanel bGControlPanel = new BGButtonPanel(BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M);
        bGControlPanel.addActionListener(e -> this.bGControlPanel_12_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createLoginPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bGControlPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.unitPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createLoginPanel() {
        this.login.setSelectionForeground(Color.black);
        this.login.setSelectionMode(2);
        final JPopupMenu loginMenu = new JPopupMenu();
        this.addLoginsMenuItems(loginMenu);
        this.login.addListSelectionListener(e -> this.readLoginList());
        this.login.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    loginMenu.show(ServiceReportPanel.this.login, e.getX(), e.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041b\u043e\u0433\u0438\u043d "));
        panel.add((Component)new JScrollPane(this.login), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void addRcMenuItems(JPopupMenu menu) {
    }

    protected void addLoginsMenuItems(JPopupMenu menu) {
    }

    @Override
    public void init(int cid, int mid) {
        super.init(cid, mid);
        this.radiusLog.init(this.module, mid);
    }

    private void checkLoginList() {
        ArrayList<Integer> items = new ArrayList<Integer>();
        List<String> selectedItems = Utils.toList(this.selected);
        int size = this.login.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            BGUListItem item = this.login.getModel().getElementAt(i);
            if (!selectedItems.contains(item.getIdStr())) continue;
            items.add(i);
        }
        int[] indices = new int[items.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)items.get(i);
        }
        this.login.setSelectedIndices(indices);
    }

    private void readLoginList() {
        if (this.updating) {
            return;
        }
        this.selected = "";
        for (BGUListItem item : this.login.getSelectedValuesList()) {
            if (!this.selected.isEmpty()) {
                this.selected = this.selected + ",";
            }
            this.selected = this.selected + item.getIdStr();
        }
    }

    private void getLoginList() {
        Request request = new Request().setAction("GetLogins").setModule(this.module).setModuleId(this.getModuleId()).setContractId(this.getContractId()).setAttribute("datefrom", this.periodPanel.getDateString1()).setAttribute("dateto", this.periodPanel.getDateString2());
        Document doc = TransferManager.getDocument(request);
        this.updating = true;
        this.tryCall(() -> ClientUtils.buildList(this.login, this.loginModel, XMLUtils.selectElement(doc, "//logins")));
        this.checkLoginList();
        this.updating = false;
    }

    @Override
    public void setData() throws Exception {
        Request request = this.getRequest().setAttribute("contentType", "xml");
        Document doc = TransferManager.getDocument(request);
        this.setDocument(doc);
        this.getLoginList();
    }

    private Request getRequest() {
        if (this.amountToggleButton.isSelected()) {
            this.show_mode = 1;
            this.cardLayout1.show(this.cardPanel, "amounts");
        } else if (this.sessionToggleButton.isSelected()) {
            this.show_mode = 0;
            this.cardLayout1.show(this.cardPanel, "sessions");
        } else if (this.dirToggleButton.isSelected()) {
            this.show_mode = 2;
            this.cardLayout1.show(this.cardPanel, "dirs");
        }
        Request request = new Request();
        request.setModule(this.module);
        String action = null;
        switch (this.show_mode) {
            case 0: {
                action = "LoginSessions";
                break;
            }
            case 1: {
                action = "LoginsAmount";
                break;
            }
            case 2: {
                action = "LoginDirect";
            }
        }
        request.setAction(action);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        request.setPeriod(this.periodPanel.getPeriod());
        if (this.dest != null) {
            request.setAttribute("dest", this.dest);
        }
        if (this.incomingRadioBut.isSelected()) {
            request.setAttribute("direct", "2");
        } else if (this.outgoingRadioBut.isSelected()) {
            request.setAttribute("direct", "1");
        }
        if (this.nofreeCheckBox.isSelected()) {
            request.setAttribute("nofree", "1");
        }
        if (this.noZeroTimeCheckBox.isSelected()) {
            request.setAttribute("noZeroTime", "1");
        }
        request.setAttribute("mask", this.mask.getText().trim());
        if (!this.login.isSelectionEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (BGUListItem item : this.login.getSelectedValuesList()) {
                sb.append(item.getIdStr());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            request.setAttribute("id", sb.toString());
        }
        request.setAttribute("unit", this.unit);
        if (this.show_mode == 2) {
            request.setAttribute("order", this.dirFilter.getSelectedItem().getObject().toString());
        }
        return request;
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        Element tableElement = XMLUtils.selectElement(doc, "//table");
        if (tableElement == null) {
            return;
        }
        Element data = XMLUtils.selectElement(doc, "//table/data");
        String trafficsTitle = null;
        if (data != null) {
            this.timeSum.setText(data.getAttribute("time_amount"));
            this.roundTimeSum.setText(data.getAttribute("round_time_amount"));
            this.moneySum.setText(data.getAttribute("money_amount"));
            this.sessionsCount.setText(data.getAttribute("count_amount"));
            trafficsTitle = data.getAttribute("traffics_title");
            if (trafficsTitle != null && trafficsTitle.length() > 0) {
                this.roundTimeSumLabel.setText("\u0422\u0440\u0430\u0444\u0438\u043a\u0438 (" + trafficsTitle + "):");
                this.roundTimeSum.setText(data.getAttribute("traffics"));
            }
            this.pagePanel.setPageInfo(tableElement);
        }
        if (ClientUtils.checkStatus(doc) && this.show_mode == 0) {
            this.setSessionColumns(trafficsTitle);
            this.updateTable(this.sessionTable, tableElement, "traffics");
        } else if (ClientUtils.checkStatus(doc) && this.show_mode == 1) {
            this.setAccountColumns(trafficsTitle);
            this.updateTable(this.accountTable, tableElement, "f4");
        } else if (ClientUtils.checkStatus(doc) && this.show_mode == 2) {
            this.dirTable.updateData(XMLUtils.selectNode(doc, "//table"));
        }
    }

    private void setSessionColumns(String trafficsTitle) {
        if (!this.SessionSetColumn) {
            this.setColumns(this.sessionTable, "login_session", trafficsTitle);
            this.SessionSetColumn = true;
        }
    }

    private void setAccountColumns(String trafficsTitle) {
        if (!this.AccountSetColumn) {
            this.setColumns(this.accountTable, "login_account", trafficsTitle);
            this.AccountSetColumn = true;
        }
    }

    private void setColumns(BGTable table, String table_id, String trafficsTitle) {
        table.setHeader(this.rb_name, this.moduleDoc, table_id);
        if (!Utils.isEmptyString(trafficsTitle)) {
            String[] trafficsTitles = trafficsTitle.split("/");
            int[] w = new int[]{50, 50, -1};
            for (int j = 0; j < trafficsTitles.length; ++j) {
                table.addColumn("traf" + j, trafficsTitles[j], w, false);
            }
        } else {
            table.columnWidthsByTableWidth();
        }
    }

    private void updateTable(BGTable table, Element tableElement, String trafficAttribute) {
        table.removeRows();
        NodeList rows = tableElement.getElementsByTagName("row");
        for (int i = 0; i < rows.getLength(); ++i) {
            Element row = (Element)rows.item(i);
            String traffics = row.getAttribute(trafficAttribute);
            String[] traf = traffics.split("/");
            for (int j = 0; j < traf.length; ++j) {
                BigDecimal traffic = Utils.parseBigDecimal(traf[j].trim(), BigDecimal.ZERO);
                row.setAttribute("traf" + j, String.valueOf(traffic));
            }
            table.addRow(row);
        }
    }

    private String getHtml() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "html");
        request.setAttribute("show_all", "1");
        String result = "<html>\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u0440\u0438\u0448\u0435\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430</html>";
        try {
            result = TransferManager.getString(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void bGControlPanel_12_actionPerformed(ActionEvent e) {
        block16: {
            this.dest = null;
            String actionCommand = e.getActionCommand();
            if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
                new HtmlPrinter(this.getHtml(), 800, 300);
            } else if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
                String email = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 EMail", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3);
                if (email != null) {
                    Request request = this.getRequest();
                    request.setAttribute("email", email);
                    request.setAttribute("show_all", "1");
                    request.setAttribute("contentType", "html");
                    if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                        ClientUtils.showMessageDialog("\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d");
                    }
                }
            } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
                BGFileChooser fc = new BGFileChooser(this);
                FileFilter[] ff = fc.getChoosableFileFilters();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        fc.removeChoosableFileFilter(ff[i]);
                    }
                }
                BGFileFilter htmlFilter = new BGFileFilter("html|htm", "HTML File");
                BGFileFilter csvFilter = new BGFileFilter("csv", "CSV File");
                fc.addChoosableFileFilter(htmlFilter);
                fc.addChoosableFileFilter(csvFilter);
                if (fc.showSaveDialog(JOptionPane.getRootFrame()) == 0) {
                    try {
                        if (htmlFilter.equals(fc.getFileFilter())) {
                            ClientUtils.saveHtmlFile(this.getHtml(), fc.getSelectedFile());
                            break block16;
                        }
                        Object path = fc.getSelectedFile().getAbsolutePath();
                        if (!((String)path).endsWith(".csv") && !((String)path).endsWith(".CSV")) {
                            path = (String)path + ".csv";
                        }
                        FileOutputStream fos = new FileOutputStream((String)path);
                        Request request = this.getRequest();
                        request.setAttribute("contentType", "html");
                        request.setAttribute("output", "csv");
                        request.setAttribute("show_all", "1");
                        InputStream is = TransferManager.getInputStream(request);
                        Utils.flush(is, fos);
                        is.close();
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            } else if (BGButtonPanel.DO_M.getActionCommand().equals(actionCommand)) {
                this.pagePanel.init();
                this.trySetData();
            }
        }
    }

    protected void hideVoipPart() {
        this.voipPanel.setVisible(false);
        this.voipFilterPanel.setVisible(false);
    }

    private void showSessionsForDest() {
        int row = this.dirTable.getSelectedRow();
        if (row >= 0) {
            this.dest = this.dirTable.getRowId(row, "dest_code");
            this.sessionToggleButton.setSelected(true);
            this.trySetData();
        }
    }

    private void showRadiusLog() {
        int id = Utils.parseInt(ClientUtils.getRowId(this.sessionTable, null, "log_id"));
        this.radiusLog.setId(id);
        this.radiusLog.setDate(TimeUtils.convertLocalDateTimeToCalendar(this.periodPanel.getBeginDate().atStartOfDay()));
        this.radiusLog.showLog();
        this.radiusLog.setVisible(true);
    }

    private void setUnit(String value) {
        try {
            this.unit = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trySetData();
    }

    private void scaleValue_1_actionPerformed(ActionEvent e) {
        this.setUnit(e.getActionCommand());
        this.trySetData();
    }
}

