/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.auth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.server.util.Setup;

public class ModuleAuthImpl
extends BGLogger
implements ModuleAuth {
    @Override
    public ModuleUser findModuleUserByLogin(String login, int moduleId, int authMode, Connection con) {
        ModuleUser moduleUser;
        block24: {
            this.getLogger().trace("login={}; moduleId={}; authMode={}", new Object[]{login, moduleId, authMode});
            moduleUser = null;
            if (login != null && login.trim().length() > 0 && moduleId > -1) {
                try {
                    if (authMode == 1) {
                        String query = "SELECT id, pswd FROM contract WHERE title=? LIMIT 1";
                        try (PreparedStatement ps = con.prepareStatement(query);){
                            ps.setString(1, login);
                            try (ResultSet rs = ps.executeQuery();){
                                if (rs.next()) {
                                    moduleUser = ModuleUser.builder().setLogin(login).setPassword(rs.getString(2)).setContractId(rs.getInt(1)).setContractTitle(login).build();
                                }
                                break block24;
                            }
                        }
                    }
                    if (authMode != 2) break block24;
                    Integer parameterId = Setup.getSetup().getInt("web.auth.contract.text.parameter", 0);
                    this.getLogger().trace("web.auth.contract.text.parameter={}", (Object)parameterId);
                    if (parameterId <= 0) break block24;
                    try (ContractDao contractDao = new ContractDao(con, 0);){
                        List<Contract> contracts = contractDao.getContractByTextParameter(parameterId, login);
                        if (contracts != null && !contracts.isEmpty()) {
                            Contract contract = contracts.get(0);
                            moduleUser = ModuleUser.builder().setLogin(login).setPassword(contract.getPassword()).setContractId(contract.getId()).setContractTitle(contract.getTitle()).build();
                        }
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error("error kernel ModuleAuth", (Throwable)ex);
                }
            }
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("moduleUser={}", (Object)moduleUser.toString());
        }
        return moduleUser;
    }
}

