/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.util.Properties;

public class SSHSessionExec {
    private String host;
    private int port;
    private String login;
    private String pswd;
    private Session session;
    private int timeout = 0;

    public SSHSessionExec(String host, int port, String login, String pswd) {
        this.host = host;
        this.port = port;
        this.login = login;
        this.pswd = pswd;
    }

    public void connect() throws Exception {
        Properties pr = new Properties();
        pr.put("StrictHostKeyChecking", "no");
        this.session = new JSch().getSession(this.login, this.host, this.port);
        this.session.setPassword(this.pswd);
        this.session.setConfig(pr);
        this.session.setTimeout(this.timeout);
        this.session.connect(3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String command(String command) throws Exception {
        StringBuffer result = new StringBuffer();
        ChannelExec channel = null;
        try {
            this.connect();
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(command);
            channel.setInputStream(null);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            long start = System.currentTimeMillis();
            while (this.timeout == 0 || System.currentTimeMillis() - start < (long)this.timeout) {
                while (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    String str = new String(tmp, "ISO-8859-1");
                    result.append(str);
                    if (i >= 0) continue;
                    break;
                }
                if (channel.isClosed()) {
                    break;
                }
                Thread.sleep(100L);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            this.session.disconnect();
        }
        return result.toString();
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

