/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.SubscriptionService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.ClosePacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.OpenPacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.SubscriptionService")
public class SubscriptionServiceImpl
extends AbstractService
implements SubscriptionService {
    public static final int ADDCHECK_NO = 0;
    public static final int ADDCHECK_OPEN = 1;
    public static final int ADDCHECK_WEBADD = 2;
    public static final int ADDCHECK_ADD = 3;
    @Resource
    private CardPacketService cardPacketService;
    private Map<Integer, List<PacketChannel>> channelPacketMap = null;

    public void subscriptionDelete(int contractId, int usercardId, int cardPacketId) throws Exception {
        Packet packet2;
        CardPacketManager cpm = new CardPacketManager(this.getConnection(), this.moduleId);
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        GregorianCalendar now = new GregorianCalendar();
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet2 : pm.getPacketList()) {
            packetMap.put(packet2.getId(), packet2);
        }
        CardPacket cardPacket = cpm.getCardPacketById(cardPacketId);
        packet2 = (Packet)packetMap.get(cardPacket.getPacketId());
        if (cardPacket != null && cardPacket.getContractId() == contractId && TimeUtils.dateBefore((Date)now.getTime(), (Date)cardPacket.getDateFrom())) {
            if (!this.checkCanRemovePacketWeb(cpm, packetMap, contractId, usercardId, packet2, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), false)) {
                return;
            }
            cpm.deleteCardPacket(cardPacketId);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, contractId, usercardId, 2, 3, cardPacket.getPacketId(), null);
            this.context.publishAfterCommit((Event)event);
        }
    }

    private Map<Integer, List<PacketChannel>> getChannelPacketMap(Map<Integer, Packet> packetMap) throws Exception {
        Map<Integer, List<PacketChannel>> result = this.channelPacketMap;
        if (result == null) {
            result = new HashMap<Integer, List<PacketChannel>>();
            PacketChannelManager pcm = new PacketChannelManager(this.getConnection(), this.moduleId);
            for (Packet p : packetMap.values()) {
                List<PacketChannel> pcList = pcm.getPacketChannelList(p.getId());
                result.put(p.getId(), pcList);
            }
            this.channelPacketMap = result;
        }
        return result;
    }

    public Object[] hasChannelFromPacket(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, int packetId, Date now, Set<Integer> withoutPackets) throws Exception {
        Map<Integer, List<PacketChannel>> channelPacketMap = this.getChannelPacketMap(packetMap);
        List<CardPacket> list = cpm.getCardPacketList(cid, usercardId, now, false);
        List<PacketChannel> addSet = channelPacketMap.get(packetId);
        for (CardPacket cp : list) {
            List<PacketChannel> set = channelPacketMap.get(cp.getPacketId());
            if (set == null || withoutPackets != null && withoutPackets.contains(cp.getPacketId())) continue;
            for (PacketChannel i : addSet) {
                for (PacketChannel s : set) {
                    if (i.getChannelId() != s.getChannelId() || !TimeUtils.dateInRange((Date)now, (Date)s.getDateFrom(), (Date)s.getDateTo()) || !TimeUtils.dateInRange((Date)now, (Date)i.getDateFrom(), (Date)i.getDateTo())) continue;
                    Channel c = new ChannelManager(this.getConnection(), this.moduleId).getChannelById(i.getChannelId());
                    return new Object[]{packetMap.get(cp.getPacketId()), c};
                }
            }
        }
        return null;
    }

    protected void checkCanAddPacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, Packet packet, Calendar date, AtomicReference<Date> date2Ref) throws Exception {
        if (packet.getDepends().size() > 0 || packet.getUnacceptable().size() > 0) {
            List<CardPacket> currentPacketList = cpm.getCardPacketList(cid, usercardId, date.getTime(), false);
            currentPacketList.addAll(cpm.getFutureCardPacketList(cid, usercardId, date.getTime()));
            currentPacketList = Collections.unmodifiableList(currentPacketList);
            HashSet<Integer> currentPackets = new HashSet<Integer>();
            Date date2 = null;
            for (CardPacket cp : currentPacketList) {
                currentPackets.add(cp.getPacketId());
                if (cp.getDateTo() == null || date2 != null && !date2.after(cp.getDateTo())) continue;
                date2 = cp.getDateTo();
            }
            date2Ref.set(date2);
            StringBuilder tag = new StringBuilder().append("cerbercrypt.add.conflict: ");
            if (packet.getDepends().size() > 0 && Collections.disjoint(currentPackets, packet.getDepends())) {
                StringBuilder packets = new StringBuilder();
                StringBuilder packetsIds = new StringBuilder();
                for (Integer id : packet.getDepends()) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        packets.append(p.getTitle()).append(", ");
                        packetsIds.append(p.getId()).append(", ");
                        continue;
                    }
                    this.getLogger().error("Depend packet id=" + id + " not found for packet id=" + packet.getId());
                }
                if (packets.length() > 0) {
                    packets.setLength(packets.length() - 2);
                }
                if (packetsIds.length() > 0) {
                    packetsIds.setLength(packets.length() - 2);
                }
                tag.append("depends=").append(packetsIds.toString());
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u043a\u0435\u0442\u043e\u0432: " + packets.toString(), tag.toString());
            }
            ArrayList unacceptable = new ArrayList(packet.getUnacceptable());
            unacceptable.retainAll(currentPackets);
            if (unacceptable.size() > 0) {
                StringBuilder packets = new StringBuilder();
                StringBuilder packetsIds = new StringBuilder();
                for (Integer id : unacceptable) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        packets.append(p.getTitle()).append(", ");
                        packetsIds.append(p.getId()).append(", ");
                        continue;
                    }
                    this.getLogger().error("Unacceptable packet not found=" + id + " for packet " + packet.getId());
                }
                if (packets.length() > 0) {
                    packets.setLength(packets.length() - 2);
                }
                if (packetsIds.length() > 0) {
                    packetsIds.setLength(packets.length() - 2);
                }
                tag.append("incompatible=").append(packetsIds.toString());
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + packets.toString(), tag.toString());
            }
        }
    }

    protected boolean checkCanRemovePacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, Packet packet, Calendar date, boolean groupReplace) throws Exception {
        Packet p;
        StringBuilder packetsIds;
        StringBuilder packets;
        List<CardPacket> currentPacketList = cpm.getCardPacketList(cid, usercardId, date.getTime(), false);
        currentPacketList.addAll(cpm.getFutureCardPacketList(cid, usercardId, date.getTime()));
        currentPacketList = Collections.unmodifiableList(currentPacketList);
        TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        Set<Integer> packetGroup = trm.getPacketGroup((ParameterMap)this.getModuleSetup(), cid, date);
        boolean result = true;
        StringBuilder errors = new StringBuilder();
        StringBuilder tag = new StringBuilder().append("cerbercrypt.remove.conflict: ");
        if (!groupReplace && packetGroup != null && packetGroup.contains(packet.getId())) {
            packetGroup.remove(packet.getId());
            packets = new StringBuilder();
            packetsIds = new StringBuilder();
            for (Integer id : packetGroup) {
                p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    packetsIds.append(p.getId()).append(", ");
                    continue;
                }
                this.getLogger().error("Group packet not found=" + packet.getId());
            }
            if (packets.length() > 0) {
                packets.setLength(packets.length() - 2);
            }
            if (packetsIds.length() > 0) {
                packetsIds.setLength(packets.length() - 2);
            }
            tag.append("base=").append(packetsIds.toString());
            errors.append("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437: " + packets.toString()).append(".");
            result = false;
        }
        packets = new StringBuilder();
        packetsIds = new StringBuilder();
        for (CardPacket cp : currentPacketList) {
            p = packetMap.get(cp.getPacketId());
            if (p != null) {
                if (!p.getDepends().contains(packet.getId())) continue;
                packets.append(p.getTitle()).append(", ");
                packetsIds.append(p.getId()).append(", ");
                continue;
            }
            this.getLogger().error("Packet not found=" + cp.getPacketId() + " for cardPacket " + cp.getId());
        }
        if (packets.length() > 0) {
            packets.setLength(packets.length() - 2);
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append("\u041f\u0430\u043a\u0435\u0442 " + packet.getTitle() + " \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + packets.toString() + ". \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b.");
            result = false;
            tag.append("dependent=").append(packetsIds.toString());
        }
        if (errors.length() > 0) {
            throw new BGMessageException(errors.toString(), tag.toString());
        }
        return result;
    }

    public String subscriptionOpen(int contractId, int usercardId, int packetId, Date fromDate, String comment) throws Exception {
        Object[] pkt;
        String message = null;
        UserCardManager ucm = new UserCardManager(this.getConnection(), this.moduleId, -1);
        CardPacketManager cpm = new CardPacketManager(this.getConnection(), this.moduleId);
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(fromDate);
        UserCard userCard = (UserCard)ucm.get(usercardId);
        if (userCard == null || userCard.getContractId() != contractId) {
            throw new BGIllegalArgumentException("invalid.userCardId");
        }
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet : pm.getPacketList()) {
            packetMap.put(packet.getId(), packet);
        }
        Packet packet = (Packet)packetMap.get(packetId);
        if (packet == null || !packet.isCanWebOpen() && !packet.isCanWebClose()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u043a\u0435\u0442\u043e\u043c \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
        }
        if (!packet.isCanWebOpen()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
        }
        if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439!");
        }
        if (cpm.getCardPacket(usercardId, packetId, date.getTime()) != null) {
            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
        }
        Calendar dateFuture = (Calendar)((Calendar)date).clone();
        dateFuture.add(2, 2);
        if (cpm.getCardPacket(usercardId, packetId, dateFuture.getTime()) != null) {
            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
        }
        if (TimeUtils.dateBefore((Calendar)dateFuture, (Calendar)date)) {
            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442 \u044d\u0442\u043e\u0439 \u0434\u0430\u0442\u043e\u0439!");
        }
        AtomicReference<Date> date2 = new AtomicReference<Date>();
        this.checkCanAddPacketWeb(cpm, packetMap, contractId, usercardId, packet, date, date2);
        TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        Set<Integer> packetGroup = trm.getPacketGroup((ParameterMap)this.getModuleSetup(), contractId, date);
        if (this.getModuleSetup().getInt("cerbercrypt.cardpacket.addcheck", 1) >= 2 && (pkt = this.hasChannelFromPacket(cpm, packetMap, contractId, usercardId, packetId, date.getTime(), packetGroup)) != null) {
            Packet pak = (Packet)pkt[0];
            Channel c = (Channel)pkt[1];
            throw new BGMessageException("\u041a\u0430\u043d\u0430\u043b " + (c != null ? c.getTitle() : "null") + " \u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u0435 " + packet.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 " + pak.getTitle());
        }
        OpenPacketSubscriptionEvent eventOpenPacket = new OpenPacketSubscriptionEvent(this.userId, this.moduleId, contractId, userCard, packet, date.getTime());
        eventOpenPacket = (OpenPacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventOpenPacket);
        if (Utils.notBlankString((String)eventOpenPacket.getError())) {
            throw new BGMessageException(eventOpenPacket.getError());
        }
        if (Utils.notBlankString((String)eventOpenPacket.getMessage())) {
            message = eventOpenPacket.getMessage();
        }
        if (!eventOpenPacket.isProcessed()) {
            CardPacket cardPacket = new CardPacket();
            cardPacket.setContractId(contractId);
            cardPacket.setUsercardId(usercardId);
            cardPacket.setPacketId(packetId);
            cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date));
            if (comment != null) {
                cardPacket.setComment(comment);
            }
            if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
                throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
            }
            cpm.openCardPackets(this.getConnectionSet(), (ParameterMap)this.getModuleSetup(), packetMap, contractId, usercardId, Collections.singletonList(cardPacket), now, true);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, contractId, userCard.getId(), 2, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date));
            this.context.publishAfterCommit((Event)event);
            new UserCardManager(this.getConnection(), this.moduleId, -1).updateSubscribe(date.getTime(), cardPacket.getUsercardId(), true);
        }
        return message;
    }

    public String subscriptionClose(int contractId, int usercardId, int packetId, Date toDate, String comment) throws Exception {
        CardPacket cardPacket;
        String message = null;
        UserCardManager ucm = new UserCardManager(this.getConnection(), this.moduleId, -1);
        CardPacketManager cpm = new CardPacketManager(this.getConnection(), this.moduleId);
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(toDate);
        UserCard userCard = (UserCard)ucm.get(usercardId);
        if (userCard == null || userCard.getContractId() != contractId) {
            throw new BGIllegalArgumentException("invalid.userCardId");
        }
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet : pm.getPacketList()) {
            packetMap.put(packet.getId(), packet);
        }
        Packet packet = (Packet)packetMap.get(packetId);
        if (packet == null || !packet.isCanWebOpen() && !packet.isCanWebClose()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u043a\u0435\u0442\u043e\u043c \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
        }
        if (!packet.isCanWebClose()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
        }
        if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442 \u043d\u0435 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439");
        }
        if (!this.checkCanRemovePacketWeb(cpm, packetMap, contractId, usercardId, packet, date, false)) {
            return null;
        }
        ClosePacketSubscriptionEvent eventClosePacket = new ClosePacketSubscriptionEvent(this.userId, this.moduleId, contractId, userCard, packet, date.getTime());
        eventClosePacket = (ClosePacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventClosePacket);
        if (Utils.notBlankString((String)eventClosePacket.getError())) {
            throw new BGMessageException(eventClosePacket.getError());
        }
        if (Utils.notBlankString((String)eventClosePacket.getMessage())) {
            message = eventClosePacket.getMessage();
        }
        if (!eventClosePacket.isProcessed() && (cardPacket = cpm.getCardPacket(usercardId, packetId, date.getTime())) != null) {
            cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date));
            if (comment != null) {
                cardPacket.setComment(comment);
            }
            cpm.updateCardPacket(cardPacket);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, contractId, userCard.getId(), 2, 2, packetId, TimeUtils.convertCalendarToDate((Calendar)date));
            this.context.publishAfterCommit((Event)event);
        }
        return message;
    }

    public BigDecimal subscriptionCost(int contractId, int usercardId, Date date) throws Exception {
        List cardPacketList = this.cardPacketService.cardPacketTable(-1, usercardId, date, false, contractId);
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet : pm.getPacketList()) {
            packetMap.put(packet.getId(), packet);
        }
        float cost = trm.getSubscriptionCost(contractId, date, packetMap, cardPacketList, false);
        return BigDecimal.valueOf(cost);
    }
}

