/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import javax.swing.Icon;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPluginControls;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillViewer;
import ru.bitel.bgbilling.plugins.edo.client.SearchContragentDialog;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.common.service.EDOBillService;
import ru.bitel.bgbilling.plugins.edo.common.service.EDOService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Pair;

public class BillDocViewPanel
extends BGUPanel
implements BGControlPanelPluginControls.IPluginControls,
ActionListener {
    private BGUComboBox<KeyValue> edoFormatsCB = new BGUComboBox();
    private ServiceConfigBillViewer owner;
    private BGButton saveButton = new BGButton("\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c", "save", (ActionListener)this);
    private BGButton sendButton = new BGButton("\u0432 \u042d\u0414\u041e", "send", (ActionListener)this);
    private ContragentInfos contragentInfos;
    private BillDoc currentDoc = null;

    public BillDocViewPanel() {
        super((LayoutManager)new FlowLayout(1, 0, 0), new ClientContext("ru.bitel.bgbilling.plugins.edo", 0, 0, ""));
        this.setBorder((Border)new BGTitleBorder("\u042d\u0414\u041e"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("save".equals(actionCommand)) {
            this.saveEdo();
        } else if ("send".equals(actionCommand)) {
            this.sendEdo();
        } else if ("search".equals(actionCommand)) {
            this.searchContragent();
        }
    }

    public boolean beforeAdd(Component owner, Object ... data) {
        this.owner = (ServiceConfigBillViewer)owner;
        try {
            List formats = ((EDOService)((ClientContext)this.getContext()).getPort(EDOService.class)).formatsList();
            if (formats != null && !formats.isEmpty()) {
                this.edoFormatsCB.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.sendButton.setEnabled(false);
                this.add((Component)new BGButton(null, (Icon)ClientUtils.getIcon((String)"loopa_fade"), "search", (ActionListener)this));
                this.add((Component)this.edoFormatsCB);
                this.add((Component)this.saveButton);
                this.add((Component)this.sendButton);
                this.edoFormatsCB.setData(formats);
                this.edoFormatsCB.insertItemAt((Object)new KeyValue(null, "--"), 0);
                this.edoFormatsCB.setSelectedIndex(0);
                return true;
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return false;
    }

    public void doSetData(Component owner, Object ... data) {
        String code;
        if (data.length < 1) {
            return;
        }
        switch (code = (String)data[0]) {
            case "showDocument": {
                this._showDocument((BillDoc)data[1]);
                return;
            }
        }
    }

    public boolean beforeAction(Component owner, Object ... data) {
        return true;
    }

    public void doAction(Component owner, Object ... data) {
    }

    protected void jbInit() throws Exception {
    }

    private void searchContragent() {
        int contractId;
        BillDoc currentViewedDoc = this.owner.getCurrentViewedDoc();
        int n = contractId = currentViewedDoc != null ? currentViewedDoc.cid : -1;
        if (contractId <= 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u043e \u0447\u0442\u043e \u0437\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
            return;
        }
        ContragentInfos _contragentInfos = SearchContragentDialog.doSearch((ClientContext)this.getContext(), contractId);
        this.setContragentInfos(_contragentInfos);
    }

    private void setContragentInfos(ContragentInfos _contragentInfos) {
        this.contragentInfos = _contragentInfos;
        if (this.contragentInfos != null) {
            this.edoFormatsCB.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.sendButton.setEnabled(true);
        } else {
            this.edoFormatsCB.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.sendButton.setEnabled(false);
        }
    }

    private void saveEdo() {
        block11: {
            if (this.edoFormatsCB.getSelectedIndex() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442");
                return;
            }
            if (this.contragentInfos == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0438\u0441\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430?");
                return;
            }
            int billModuleId = this.owner.getModuleId();
            BillDoc currentViewedDoc = this.owner.getCurrentViewedDoc();
            try {
                FileDto fileDto = ((EDOBillService)((ClientContext)this.getContext()).getPort(EDOBillService.class)).saveEdoFile(billModuleId, ((KeyValue)this.edoFormatsCB.getSelectedItem()).getKey(), this.contragentInfos, currentViewedDoc.type, Integer.valueOf(currentViewedDoc.docId));
                BGFileChooser fc = new BGFileChooser((Component)this.owner);
                File dir = fc.getCurrentDirectory();
                File selfile = new File(String.valueOf(dir.getAbsoluteFile()) + File.separator + fileDto.getFileName());
                fc.setSelectedFile(selfile);
                if (fc.showSaveDialog() != 0) break block11;
                try (FileOutputStream out = new FileOutputStream(fc.getSelectedFile());){
                    out.write(Base64.getDecoder().decode(fileDto.getData()));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0442\u043e\u043a\u0430, \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void sendEdo() {
        if (this.edoFormatsCB.getSelectedIndex() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442");
            return;
        }
        if (this.contragentInfos == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0438\u0441\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430?");
            return;
        }
        int billModuleId = this.owner.getModuleId();
        BillDoc currentViewedDoc = this.owner.getCurrentViewedDoc();
        if (!ClientUtils.confirm((String)("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c " + currentViewedDoc.number + " \u0432 \u042d\u0414\u041e (" + this.contragentInfos.title + ")?"), (String)"\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0432 \u042d\u0414\u041e")) {
            return;
        }
        try {
            ExtDocument document = ((EDOBillService)((ClientContext)this.getContext()).getPort(EDOBillService.class)).sendEdo(billModuleId, ((KeyValue)this.edoFormatsCB.getSelectedItem()).getKey(), this.contragentInfos, currentViewedDoc.type, Integer.valueOf(currentViewedDoc.docId));
            if (document == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0447\u0442\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e...");
                return;
            }
            if (!ClientUtils.confirm((String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435?", (String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b")) {
                return;
            }
            if (Utils.isBlankString((String)document.getExtLink())) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0440\u0438\u0448\u0451\u043b \u0431\u0435\u0437 \u0441\u0441\u044b\u043b\u043a\u0438");
                return;
            }
            ClientUtils.openBrowser((URI)new URI(document.getExtLink()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void _showDocument(BillDoc doc) {
        if (doc == null || this.currentDoc == null) {
            this.setContragentInfos(null);
            this.currentDoc = doc;
            return;
        }
        if (doc.type != this.currentDoc.type || doc.docId != this.currentDoc.docId) {
            this.setContragentInfos(null);
            this.currentDoc = doc;
            return;
        }
    }

    private void _saveEdo() {
        block10: {
            if (this.edoFormatsCB.getSelectedIndex() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442");
                return;
            }
            Pair bii = this.owner.getBillInvoiceIds();
            int billModuleId = this.owner.getModuleId();
            List billList = (List)bii.getFirst();
            List invoiceList = (List)bii.getSecond();
            try {
                FileDto fileDto = ((EDOBillService)((ClientContext)this.getContext()).getPort(EDOBillService.class)).saveFile(((KeyValue)this.edoFormatsCB.getSelectedItem()).getKey(), billModuleId, billList, invoiceList);
                BGFileChooser fc = new BGFileChooser((Component)this.owner);
                File dir = fc.getCurrentDirectory();
                File selfile = new File(String.valueOf(dir.getAbsoluteFile()) + File.separator + fileDto.getFileName());
                fc.setSelectedFile(selfile);
                if (fc.showSaveDialog() != 0) break block10;
                try (FileOutputStream out = new FileOutputStream(fc.getSelectedFile());){
                    out.write(Base64.getDecoder().decode(fileDto.getData()));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0442\u043e\u043a\u0430, \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void _sendEdo() {
        if (this.edoFormatsCB.getSelectedIndex() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u043e\u0440\u043c\u0430\u0442");
            return;
        }
        Pair bii = this.owner.getBillInvoiceIds();
        int billModuleId = this.owner.getModuleId();
        List billList = (List)bii.getFirst();
        List invoiceList = (List)bii.getSecond();
        if (!ClientUtils.confirm((String)("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c " + (billList.size() + invoiceList.size()) + " \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u042d\u0414\u041e?"), (String)"\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0432 \u042d\u0414\u041e")) {
            return;
        }
        try {
            List documents = ((EDOBillService)((ClientContext)this.getContext()).getPort(EDOBillService.class)).send(((KeyValue)this.edoFormatsCB.getSelectedItem()).getKey(), billModuleId, billList, invoiceList);
            if (documents == null || documents.isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0447\u0442\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e...");
                return;
            }
            if (ClientUtils.confirm((String)("\u0411\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + documents.size() + "\n\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435?"), (String)"\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b")) {
                int noOpenLink = 0;
                for (ExtDocument document : documents) {
                    if (Utils.notBlankString((String)document.getExtLink())) {
                        ClientUtils.openBrowser((URI)new URI(document.getExtLink()));
                        continue;
                    }
                    ++noOpenLink;
                }
                if (noOpenLink > 0) {
                    ClientUtils.showErrorMessageDialog((String)("\u041d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 (" + noOpenLink + ") \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0435\u0437 \u0441\u0441\u044b\u043b\u043a\u0438"));
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

