/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.DhcpDisableMode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.dhcp.AbstractInetDhcpProcessor2;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpOfferedAddressMap2;
import ru.bitel.bgbilling.modules.inet.server.dhcp.connection.InetDhcpConnectionEntry;
import ru.bitel.bgbilling.modules.inet.server.dhcp.connection.InetDhcpConnectionMap;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.function.Lazy;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AverageCounterEx;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

public class InetDhcpProcessor2
extends AbstractInetDhcpProcessor2
implements ExtendedLifecycle,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    public static final DhcpPacket.DhcpPacketOption<String> IDENTIFIER = new DhcpPacket.DhcpPacketOption("identifier");
    private InetDhcpOfferedAddressMap2 offerMap;
    private InetDhcpConnectionMap connectionMap;
    private Set<Integer> keyDeviceTypeIds;
    private final AverageCounterEx accountingStartAverage = new AverageCounterEx(30L, TimeUnit.SECONDS);
    private volatile long lastAccountingStartTimeApprox = 0L;
    private volatile long accountingStartAverageApprox = 0L;
    private volatile int needAsyncAccountingStart = 0;
    private volatile long needAsyncAccountingStartTime = 0L;
    private volatile int asyncAccountingStartExecutorQueueCurrentMaxSize = 6;
    private volatile double asyncAccountingStartExecutorQueueCurrentMaxSizeFactor = 1.5;
    private volatile int asyncAccountingStartExecutorQueueMaxSize = 600;
    private volatile int blockOfferOnAccountingStartErrors = 5;
    private final ThreadPoolExecutor asyncAccountingStartExecutor = (ThreadPoolExecutor)WorkerTask.newFixedThreadPool((String)"accntngStartAsync", (String)"dhcp", (ThreadContextFactory)new ThreadContextFactory<ThreadContext>(){

        public ThreadContext newThreadContext() {
            return new ServerContext((Setup)InetDhcpProcessor2.this.setup, InetDhcpProcessor2.this.moduleId, 0);
        }
    }, (int)20, (int)2000, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    private final Random random = new Random();
    private static final Future<InetConnection> NULL_ASYNC_START = CompletableFuture.completedFuture(null);

    @ConstructorProperties(value={"setup", "access"})
    public InetDhcpProcessor2(Setup setup, Access access) throws BGException {
        super(setup, access);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.offerMap = new InetDhcpOfferedAddressMap2(this.useXid);
        this.connectionMap = new InetDhcpConnectionMap((InetApplication)this.access, this.deviceMap, true, true);
        this.setKeyDeviceTypeIds();
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetReloadLocalEvent>(){

            public void notify(InetReloadLocalEvent e, EventListenerContext ctx) throws BGException {
                InetDhcpProcessor2.this.setKeyDeviceTypeIds();
            }
        }, InetReloadLocalEvent.class, this.access.moduleId, null);
        this.connectionMap.load(this.keyDeviceTypeIds);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::checkSlowAccountingStart, 60L, 1L, TimeUnit.SECONDS);
    }

    private void setKeyDeviceTypeIds() {
        InetDeviceRuntime rootDevice = this.access.deviceMap.get(this.access.rootDeviceId);
        this.keyDeviceTypeIds = Utils.toIntegerSet((String)rootDevice.config.get("dhcp.key.deviceTypeIds", ""));
        if (this.keyDeviceTypeIds.size() == 0) {
            this.keyDeviceTypeIds = null;
        }
        this.connectionMap.setKeyDeviceTypeIds(this.keyDeviceTypeIds);
    }

    private void checkSlowAccountingStart() {
        try {
            long nowMillis = System.currentTimeMillis();
            double average = this.accountingStartAverage.getAverage(nowMillis, 20);
            this.accountingStartAverageApprox = (long)this.accountingStartAverage.getAverage(nowMillis);
            if (this.needAsyncAccountingStart > -2) {
                if (average > 600.0 && average < 3000.0) {
                    this.needAsyncAccountingStartTime = nowMillis;
                    this.needAsyncAccountingStart = 1;
                } else if (average > 3500.0) {
                    this.needAsyncAccountingStart = -1;
                } else if (nowMillis - this.needAsyncAccountingStartTime > 10000L) {
                    this.needAsyncAccountingStart = 0;
                }
            }
            this.asyncAccountingStartExecutorQueueCurrentMaxSize = average == 0.0 ? 6 : (int)Math.min((double)this.asyncAccountingStartExecutorQueueMaxSize, Math.max(6.0, 30000.0 / Math.max(1.0, average * this.asyncAccountingStartExecutorQueueCurrentMaxSizeFactor)));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    @Override
    protected DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, InetDhcpDevice agentDevice, DhcpPacket request, boolean renew) throws BGException {
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(device.deviceRuntime.inetDeviceType.getId())) {
            logger.debug("processOption82RequestBacked");
            return this.processOption82RequestBacked(req, clientAddress, device, agentDevice, request, renew);
        }
        logger.debug("processOption82RequestRaw");
        return this.processOption82RequestRaw(req, clientAddress, device, agentDevice, request, renew);
    }

    protected DhcpPacket processOption82RequestBacked(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, InetDhcpDevice agentDevice, DhcpPacket request, boolean renew) throws BGException {
        InetConnectionRuntime connectionRuntime;
        byte[] giaddr = request.giaddr;
        if (logger.isDebugEnabled()) {
            logger.debug("request.giaddr = " + IPUtils.convertIpToString((int)Utils.convertBytesToInt((byte[])giaddr)));
        }
        DhcpPacket response = request.createResponse();
        InetDhcpConnectionEntry entry = (InetDhcpConnectionEntry)this.connectionMap.getBacked(device.deviceRuntime, device, agentDevice.deviceRuntime, request);
        if (entry == null) {
            logger.error("Not found params for request: (pattern: " + device.dhcpKeyPattern + ", servSearchMode: " + device.radiusServSearchModes[0][0] + ", deviceId: " + device.getId() + ", agentDeviceId: " + agentDevice.getId() + ")");
            response.messageType = (byte)6;
            return response;
        }
        if (request.messageType == 3) {
            DhcpOption requestedIp = request.getOption((byte)50);
            if (requestedIp != null) {
                if (Utils.convertBytesToInt((byte[])requestedIp.value) != entry.address) {
                    logger.info("RequestedIP " + IpAddress.toString((byte[])requestedIp.value) + " not " + IPUtils.convertIpToString((int)entry.address));
                    response.messageType = (byte)6;
                    return response;
                }
            } else if (!DhcpPacket.isNil((byte[])request.ciaddr) && Utils.convertBytesToInt((byte[])request.ciaddr) != entry.address) {
                logger.info("ClientIP " + IpAddress.toString((byte[])request.ciaddr) + " not " + IPUtils.convertIpToString((int)entry.address));
                response.messageType = (byte)6;
                return response;
            }
        }
        Set inetOptionIds = (connectionRuntime = this.getConnection(entry, null)) != null && connectionRuntime.connection.getDeviceState() == InetServState.STATE_ENABLE.getCode() ? connectionRuntime.connection.getDeviceOptions() : null;
        return this.buildResponse(req, clientAddress, device, request, response, entry, inetOptionIds, renew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpPacket processOption82RequestRaw(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, InetDhcpDevice agentDevice, DhcpPacket request, boolean renew) throws BGException {
        ServSearchResult servSearchResult;
        byte messageType = request.messageType;
        if (messageType == 3) {
            DhcpOption serverIdentifier;
            logger.debug("DHCP_REQUEST");
            if (device.filterServerIdentifier != null && (serverIdentifier = request.getOption((byte)54)) != null && !Arrays.equals(serverIdentifier.value, device.filterServerIdentifier)) {
                logger.debug("Skip packet by filter.");
                return null;
            }
        } else {
            logger.debug("DHCP_DISCOVER");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("request.giaddr= " + IPUtils.convertIpToString((int)Utils.convertBytesToInt((byte[])request.giaddr)) + ", clientAddress=" + String.valueOf(clientAddress));
        }
        DhcpPacket response = request.createResponse();
        if (request.messageType == 3) {
            if (this.dhcpRequestUpdateSimple(req, device, agentDevice, request, response, renew)) {
                return response;
            }
            if (req.getOverloadLevel() > 9) {
                logger.debug("Heavy load, session not found in memory. Discard packet");
                return null;
            }
        }
        if ((servSearchResult = agentDevice.findServRuntime(request, req)) == null) {
            logger.info("InetServ not found.");
            int disableServId = agentDevice.getDisableServId(request);
            if (disableServId <= 0) {
                return null;
            }
            InetServRuntime servRuntime = this.access.getInetServRuntimeMap().get(disableServId);
            if (servRuntime == null) {
                return null;
            }
            logger.debug("Use disable.inetServ.");
            servSearchResult = new ServSearchResult(0, servRuntime, servRuntime);
        }
        logger.info("InetServ found: " + String.valueOf(servSearchResult.parentServRuntime));
        servSearchResult.parentServRuntime.tryLockEx(10L, TimeUnit.SECONDS);
        try {
            DhcpPacket dhcpPacket = this.processOption82RequestRaw0(req, clientAddress, device, agentDevice, servSearchResult, request, response, renew);
            servSearchResult.parentServRuntime.unlock();
            return dhcpPacket;
        }
        catch (Throwable throwable) {
            try {
                servSearchResult.parentServRuntime.unlock();
                throw throwable;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
    }

    private boolean dhcpRequestUpdateSimple(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, InetDhcpDevice agentDevice, DhcpPacket request, DhcpPacket response, boolean renew) throws UnknownHostException, BGException, InterruptedException {
        InetDhcpConnectionEntry entry = (InetDhcpConnectionEntry)this.connectionMap.get(device.deviceRuntime, device, agentDevice.deviceRuntime, agentDevice, request);
        if (entry == null) {
            return false;
        }
        InetServRuntime inetServRuntime = this.access.inetServRuntimeMap.get(entry.servId);
        if (inetServRuntime == null) {
            return false;
        }
        InetServRuntime parentServRuntime = inetServRuntime.getParentInetServRuntime(this.access);
        assert (parentServRuntime != null);
        InetConnectionRuntime connectionRuntime = this.access.connectionManager.get(agentDevice.getId(), entry.connectionId);
        if (connectionRuntime != null && connectionRuntime.connection.getServId() != entry.servId) {
            connectionRuntime = null;
        }
        if (connectionRuntime == null) {
            List<InetConnectionRuntime> connectionList = this.getDhcpConnectionList(parentServRuntime.inetServId);
            if (connectionList.size() == 0) {
                return false;
            }
            String macString = Utils.bytesToHexString((byte[])request.chaddr);
            int deviceId = device.deviceRuntime.inetDeviceId;
            connectionRuntime = this.findConnection(connectionList, entry.servId, entry.connectionId, macString, deviceId);
        }
        if (connectionRuntime == null) {
            return false;
        }
        InetConnection connection = connectionRuntime.connection;
        if (connection == null) {
            return false;
        }
        DhcpOption requestedIp = request.getOption((byte)50);
        if (requestedIp != null && !IpAddress.equals((byte[])requestedIp.value, (byte[])connection.getInetAddressBytes())) {
            return false;
        }
        InetServRuntime rootServRuntime = inetServRuntime.getRootInetServRuntime(this.access);
        rootServRuntime.tryLockEx(10L, TimeUnit.SECONDS);
        try {
            DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(inetServRuntime.getInetServTypeRuntime());
            if (dhcpDisableMode != DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                boolean needClose;
                short wantDeviceState = connectionRuntime.getWantDeviceState(this.access, rootServRuntime, inetServRuntime);
                boolean bl = needClose = wantDeviceState != connection.getDeviceState() || connectionRuntime.wantClose;
                if (needClose) {
                    logger.info("Stopping session with deviceState=" + connection.getDeviceState() + " and wantDeviceState=" + wantDeviceState);
                    req.setConnectionModified(true);
                    this.access.connectionManager.accountingStop(inetServRuntime.getInetServ(), connection, 5000L);
                    logger.info("Sending NAK to session with deviceState=" + connection.getDeviceState() + " and wantDeviceState=" + wantDeviceState);
                    response.messageType = (byte)6;
                    boolean bl2 = true;
                    return bl2;
                }
            }
            req.connectionId = entry.connectionId;
            req.interfaceId = rootServRuntime.getInetServ().getInterfaceId();
            this.dhcpRequestUpdate0(req, device, request, response, inetServRuntime.getInetServ(), connectionRuntime, connection, renew);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            rootServRuntime.unlock();
        }
        return true;
    }

    private DhcpPacket dhcpRequestUpdate(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, DhcpPacket request, DhcpPacket response, ServSearchResult servSearchResult, InetServRuntime servRuntime, InetConnectionRuntime connectionRuntime, InetConnection connection, boolean renew) throws Exception, UnknownHostException {
        boolean needClose;
        req.connectionId = connection.getId();
        DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
        if (dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
            needClose = false;
        } else if (servSearchResult.servRuntime == null) {
            logger.info("inetServ[id=" + servRuntime.inetServId + "] sub serv with MAC-addresses not found.");
            logger.info("Stopping session with deviceState=" + connection.getDeviceState() + " and accessCode=" + AccessCode.MAC_DENY.getCode());
            needClose = true;
        } else {
            short wantDeviceState = connectionRuntime.getWantDeviceState(this.access, servSearchResult.parentServRuntime, servSearchResult.servRuntime);
            boolean bl = needClose = wantDeviceState != connection.getDeviceState() || connectionRuntime.wantClose;
            if (needClose) {
                logger.info("Stopping session with deviceState=" + connection.getDeviceState() + " and wantDeviceState=" + wantDeviceState);
            }
        }
        if (needClose) {
            req.setConnectionModified(true);
            this.access.connectionManager.accountingStop(servRuntime.getInetServ(), connection, 5000L);
            if (request.messageType == 3) {
                response.messageType = (byte)6;
                return response;
            }
            logger.info("Reauthorize offer packet");
            return null;
        }
        if (request.messageType == 1) {
            this.setOptions(device, connection.getInetAddressBytes(), connection.getIpResourceId(), response, connection.getDeviceOptions(), renew);
            response.messageType = (byte)2;
            return response;
        }
        if (request.messageType == 3) {
            this.dhcpRequestUpdate0(req, device, request, response, servRuntime.getInetServ(), connectionRuntime, connection, renew);
            return response;
        }
        return null;
    }

    private void dhcpRequestUpdate0(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, DhcpPacket request, DhcpPacket response, InetServ serv, InetConnectionRuntime connectionRuntime, InetConnection connection, boolean renew) throws UnknownHostException, BGException {
        DhcpOption requestedIp = request.getOption((byte)50);
        if (requestedIp != null && !IpAddress.equals((byte[])requestedIp.value, (byte[])connection.getInetAddressBytes())) {
            req.setConnectionModified(true);
            logger.info("Requested IP not equals with connection IP: " + String.valueOf(InetAddress.getByAddress(requestedIp.value)));
            response.messageType = (byte)6;
            response.flags = DhcpPacket.FLAG_BROADCAST;
        } else {
            this.setOptions(device, connection.getInetAddressBytes(), connection.getIpResourceId(), response, connection.getDeviceOptions(), renew);
            response.messageType = (byte)5;
            logger.info("Updating of existing connection: " + String.valueOf(connection));
            this.access.connectionManager.accountingUpdatePool(serv, connection);
            if (req.isConnectionModified()) {
                connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(4320 + this.random.nextInt(1440));
            } else if (connectionRuntime.nextDhcpLog == 0L) {
                connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(45 + this.random.nextInt(30));
            } else if (connectionRuntime.nextDhcpLog <= req.millis) {
                connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(4320 + this.random.nextInt(1440));
                req.setConnectionModified(true);
            }
        }
    }

    private DhcpPacket processOption82RequestRaw0(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice relayDevice, InetDhcpDevice device, ServSearchResult servSearchResult, DhcpPacket request, DhcpPacket response, boolean renew) throws Exception {
        InetConnection connection;
        InetServRuntime parentServRuntime = servSearchResult.parentServRuntime;
        InetServRuntime servRuntime = servSearchResult.servRuntime != null ? servSearchResult.servRuntime : parentServRuntime;
        InetServ parentServ = parentServRuntime.getInetServ();
        InetServ serv = servRuntime.getInetServ();
        req.interfaceId = parentServ.getInterfaceId();
        String macString = Utils.bytesToHexString((byte[])request.chaddr);
        int deviceId = device.deviceRuntime.inetDeviceId;
        boolean disableServId = device.getDisableServIds().contains(parentServ.getId());
        ConnectionListSupplier connectionListSupplier = new ConnectionListSupplier();
        connectionListSupplier.delegate = Lazy.of(() -> this.getDhcpConnectionList(parentServ.getId()));
        InetConnectionRuntime connectionRuntime = disableServId ? this.findConnection(serv.getId(), deviceId, -1L, macString) : this.findConnection((List<InetConnectionRuntime>)connectionListSupplier.get(), serv.getId(), -1L, macString, deviceId);
        InetConnection inetConnection = connection = connectionRuntime != null ? connectionRuntime.connection : null;
        if (connection != null) {
            if (!DhcpPacket.isNil((byte[])request.ciaddr) && !IpAddress.equals((byte[])request.ciaddr, (byte[])connection.getInetAddressBytes())) {
                logger.info("ClientIP " + IpAddress.toString((byte[])request.ciaddr) + " not " + IpAddress.toString((byte[])connection.getInetAddressBytes()));
                response.messageType = (byte)6;
                return response;
            }
            DhcpPacket result = this.dhcpRequestUpdate(req, device, request, response, servSearchResult, servRuntime, connectionRuntime, connection, renew);
            if (result != null || request.messageType != 1) {
                return result;
            }
        }
        if (request.messageType == 1) {
            return this.processOption82RequestRawDiscover(req, relayDevice, device, servSearchResult, request, response, renew, parentServRuntime, servRuntime, parentServ, serv, macString, connectionListSupplier, disableServId);
        }
        if (request.messageType == 3) {
            req.setConnectionModified(true);
            InetDhcpOfferedAddressMap2.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
            DhcpOption requestedIp = request.getOption((byte)50);
            if (offered == null && requestedIp != null && !disableServId && device.isStartFromRequest()) {
                offered = this.offerStaticForRequest(req, device, servSearchResult, parentServRuntime, servRuntime, serv, connectionListSupplier, request, macString, requestedIp);
            }
            if (offered == null) {
                logger.info("Unknown packet (linked offer not found). Discard packet.");
                response.messageType = (byte)6;
                response.flags = DhcpPacket.FLAG_BROADCAST;
                return response;
            }
            if (offered.resource == null) {
                logger.info("processOption82RequestRaw0: Request skipped by ban rule");
                return null;
            }
            if (requestedIp != null && !IpAddress.equals((byte[])requestedIp.value, (byte[])offered.resource.getAddress())) {
                logger.info("Requested IP not equals with offered IP: " + String.valueOf(InetAddress.getByAddress(requestedIp.value)));
                response.messageType = (byte)6;
                response.flags = DhcpPacket.FLAG_BROADCAST;
            } else {
                this.startDhcpConnection(req, device, request, response, renew, parentServ, serv, macString, offered);
            }
        }
        return response;
    }

    private InetDhcpOfferedAddressMap2.Offered offerStaticForRequest(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, ServSearchResult servSearchResult, InetServRuntime parentServRuntime, InetServRuntime servRuntime, InetServ serv, Supplier<List<InetConnectionRuntime>> connectionListSupplier, DhcpPacket request, String macString, DhcpOption requestedIp) throws Exception {
        AuthResult authResult = this.authorization(device, servSearchResult, parentServRuntime, servRuntime, serv, macString, false, null, null);
        if (this.isTooManySessions(device, servRuntime, serv, connectionListSupplier, authResult)) {
            return null;
        }
        DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
        if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
            return this.getStaticIpFromServ(req, device, request, serv, connectionListSupplier, authResult, requestedIp.value);
        }
        return null;
    }

    private boolean isTooManySessions(InetDhcpDevice device, InetServRuntime servRuntime, InetServ serv, Supplier<List<InetConnectionRuntime>> connectionListSupplier, AuthResult authResult) {
        if (authResult.accessCode != AccessCode.TOO_MANY_SESSIONS_ERROR.getCode()) {
            return false;
        }
        DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
        if (dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
            logger.info("Too many sessions.");
            return true;
        }
        int sessionCountLimit = InetUtils.getSessionCountLimit(servRuntime.inetServTypeRef.get().inetServType, serv);
        if (connectionListSupplier.get().size() >= sessionCountLimit + device.additionalUnauthorizedSessionCount) {
            logger.info("Too many sessions.");
            return true;
        }
        return false;
    }

    private void startDhcpConnection(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, DhcpPacket request, DhcpPacket response, boolean renew, InetServ parentServ, InetServ serv, String macString, InetDhcpOfferedAddressMap2.Offered offered) throws BGException {
        Object login;
        IpResourceReserve resource = offered.resource;
        int errorCode = offered.errorCode;
        Set inetOptionIds = errorCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
        this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
        response.messageType = (byte)5;
        InetConnection connection = new InetConnection();
        connection.setDeviceId(device.deviceRuntime.inetDevice.getId());
        connection.setDevicePort(parentServ.getInterfaceId());
        Object circuitId = request.getOption(AbstractInetDhcpProcessor2.CIRCUIT_ID);
        if (circuitId != null) {
            connection.setCircuitId((Object)circuitId.toString());
        } else {
            connection.setCircuitId((Object)req.circuitId);
        }
        connection.setContractId(parentServ.getContractId());
        connection.setServId(serv.getId());
        connection.setAcctSessionId(Integer.toHexString(request.xid));
        if (device.isSaveLogin() && (login = request.getOption(AbstractInetDhcpProcessor2.LOGIN)) != null) {
            connection.setUsername(login.toString());
        }
        connection.setCallingStationId(macString);
        Object calledStationId = request.getOption(AbstractInetDhcpProcessor2.CALLED_STATION_ID);
        if (calledStationId != null) {
            connection.setCalledStationId(calledStationId.toString());
        }
        connection.setIpResourceId(resource.getIpResourceId());
        connection.setInetAddressBytes(resource.getAddress());
        InetConnection.setType((InetConnection)connection, (int)1024, (boolean)true);
        if (errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            InetConnection.setType((InetConnection)connection, (int)32, (boolean)true);
        }
        connection.setAccessCode(errorCode);
        connection.setDeviceState(errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode());
        connection.setConnectionStart(new Date());
        this.accountingStart(req, response, serv, offered, connection);
    }

    private void accountingStart(DhcpListenerWorker<InetDhcpDevice> req, DhcpPacket response, InetServ serv, InetDhcpOfferedAddressMap2.Offered offered, InetConnection connection) throws BGException {
        logger.info("Starting connection: " + String.valueOf(connection));
        if (offered.asyncStartFuture != null && offered.asyncStartFuture != NULL_ASYNC_START) {
            if (!offered.asyncStartFuture.isDone()) {
                logger.info("Async connection start already in process");
                this.responseForAsyncAccountingStart(response);
                return;
            }
            try {
                connection = offered.asyncStartFuture.get();
                if (offered.asyncStart) {
                    this.responseForAsyncAccountingStart(response);
                }
                req.connectionId = connection.getId();
                return;
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof BGException)) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                offered.asyncStartFuture = NULL_ASYNC_START;
            }
        }
        if (offered.asyncStart && offered.asyncStartFuture == null) {
            logger.info("Async connection start");
            this.responseForAsyncAccountingStart(response);
            InetConnection connectionAsyncStart = connection;
            Thread currentThread = Thread.currentThread();
            offered.asyncStartFuture = this.asyncAccountingStartExecutor.submit(() -> {
                try {
                    return this.accountingStart0(serv, connectionAsyncStart, currentThread != Thread.currentThread() ? 20000L : 4000L);
                }
                catch (BGException ex) {
                    logger.info(ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            });
            if (offered.asyncStartFuture.isDone()) {
                try {
                    connection = offered.asyncStartFuture.get();
                }
                catch (InterruptedException e) {
                    throw new BGException((Throwable)e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof BGException) {
                        throw (BGException)e.getCause();
                    }
                    throw new BGException((Throwable)e);
                }
                req.connectionId = connection.getId();
            }
            return;
        }
        connection = this.accountingStart0(serv, connection, 4000L);
        if (offered.asyncStart) {
            this.responseForAsyncAccountingStart(response);
        }
        req.connectionId = connection.getId();
    }

    private void responseForAsyncAccountingStart(DhcpPacket response) {
        response.setOption(new DhcpOption(51, Utils.convertIntToBytes((int)60)));
        response.setOption(new DhcpOption(58, Utils.convertIntToBytes((int)30)));
        response.setOption(new DhcpOption(59, Utils.convertIntToBytes((int)40)));
    }

    private InetConnection accountingStart0(InetServ serv, InetConnection connection, long timeout) throws BGException {
        long beforeMillis = System.currentTimeMillis();
        try {
            connection = this.access.connectionManager.accountingStart(serv, connection, timeout);
            if (beforeMillis % 4L == 0L) {
                long nowMillis = System.currentTimeMillis();
                long d = nowMillis - beforeMillis;
                this.lastAccountingStartTimeApprox = nowMillis;
                this.accountingStartAverage.addAverage(nowMillis, (double)d);
            }
        }
        catch (BGException ex) {
            long nowMillis = System.currentTimeMillis();
            this.accountingStartAverage.addAverage(nowMillis, (double)timeout);
            throw ex;
        }
        return connection;
    }

    private boolean checkNeedAsyncStart(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, InetServ parentServ, InetDhcpOfferedAddressMap2.Offered offered, DhcpPacket response) {
        switch (device.getAsyncAccountingStart()) {
            case 1: {
                break;
            }
            case 2: {
                if (parentServ.getDeviceState() != InetServState.STATE_ENABLE.getCode()) break;
                return false;
            }
            case 3: {
                if (this.access.getDisableServIds().contains(parentServ.getId())) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if (offered == null) {
            return false;
        }
        if (offered.asyncStart) {
            if (offered.asyncStartFuture == null || !offered.asyncStartFuture.isDone()) {
                logger.info("Async connection start already in process");
                this.responseForAsyncAccountingStart(response);
                return true;
            }
            offered.asyncStart = false;
            return false;
        }
        if (offered.discoverCounter != 1 || offered.ipOfferCounter > 1) {
            return false;
        }
        if (this.needAsyncAccountingStart == 0) {
            if (req.getOverloadLevel() <= 0) {
                return false;
            }
            if (req.getOverloadLevel() > 1) {
                this.needAsyncAccountingStartTime = System.currentTimeMillis();
                this.needAsyncAccountingStart = 1;
            }
        } else if (this.needAsyncAccountingStart != 1) {
            return false;
        }
        if (System.currentTimeMillis() + 20000L > offered.expired) {
            return false;
        }
        if (this.asyncAccountingStartExecutor.getQueue().size() >= this.asyncAccountingStartExecutorQueueCurrentMaxSize) {
            return false;
        }
        logger.info("Slow process detected. Try async connection start");
        this.responseForAsyncAccountingStart(response);
        offered.asyncStart = true;
        offered.expired += Math.max(0L, 40000L - device.dhcpOfferTimeout);
        return true;
    }

    private DhcpPacket processOption82RequestRawDiscover(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice relayDevice, InetDhcpDevice device, ServSearchResult servSearchResult, DhcpPacket request, DhcpPacket response, boolean renew, InetServRuntime parentServRuntime, InetServRuntime servRuntime, InetServ parentServ, InetServ serv, String macString, ConnectionListSupplier connectionListSupplier, boolean disableServId) throws Exception {
        boolean infoReq;
        IpResourceReserve resource = null;
        InetDhcpOfferedAddressMap2.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
        if (offered != null) {
            long now = System.currentTimeMillis();
            if (this.accountingStartAverageApprox >= 3000L && this.lastAccountingStartTimeApprox + 60000L < now && this.blockOfferOnAccountingStartErrors > 0 && ThreadLocalRandom.current().nextInt(this.blockOfferOnAccountingStartErrors) != 0) {
                logger.info("Discover skipped because errors of session creation");
                return null;
            }
            if (now <= offered.expired) {
                resource = offered.resource;
                if (resource == null) {
                    logger.info("processOption82RequestRawDiscover: Request skipped by ban rule");
                    return null;
                }
                logger.info("Duplicate discover. Send same offer");
                ++offered.discoverCounter;
            }
        }
        if (!(infoReq = this.isInfoReq(request)) && device.getDhcpConnectionCloseOnNew(parentServRuntime.getInetServTypeRuntime()) && !disableServId) {
            Object connectionList = connectionListSupplier.get();
            int size = connectionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection existConnection = ((InetConnectionRuntime)connectionList.get((int)i)).connection;
                logger.info("Send stop to connectionId:" + existConnection.getId());
                this.access.connectionManager.accountingStop(serv, existConnection, 5000L);
            }
            connectionListSupplier.delegate = Lazy.of(() -> this.getDhcpConnectionList(parentServ.getId()));
        }
        String identifier = (String)request.getOption(IDENTIFIER);
        AuthResult authResult = this.authorization(device, servSearchResult, parentServRuntime, servRuntime, serv, macString, disableServId, connectionListSupplier, identifier);
        if (infoReq) {
            if (!device.dhcpInfoReq) {
                logger.info("Skip DHCP-packet without IP-address request");
                return null;
            }
            Set inetOptionIds = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
            this.setOptions(device, request.ciaddr, 0, response, inetOptionIds, renew);
            response.messageType = (byte)2;
            return response;
        }
        req.setConnectionModified(true);
        DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
        if (authResult.accessCode == AccessCode.TOO_MANY_SESSIONS_ERROR.getCode()) {
            int sessionCountLimit = InetUtils.getSessionCountLimit(servRuntime.inetServTypeRef.get().inetServType, serv);
            if (dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH || connectionListSupplier.get().size() >= sessionCountLimit + device.additionalUnauthorizedSessionCount) {
                logger.info("Too many sessions.");
                return null;
            }
        }
        if (this.isTooManySessions(device, servRuntime, serv, connectionListSupplier, authResult)) {
            return null;
        }
        if (resource == null) {
            if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                InetDhcpOfferedAddressMap2.Offered offeredStatic;
                if (!disableServId && (offeredStatic = this.getStaticIpFromServ(req, device, request, serv, connectionListSupplier, authResult, null)) != null && (resource = offeredStatic.resource) != null) {
                    offered = offeredStatic;
                }
            } else {
                this.writeAuthError(device, serv, authResult.accessCode);
            }
        }
        if (resource == null) {
            int ipOfferCounter = offered != null && offered.errorCode == authResult.accessCode && offered.resource != null ? offered.ipOfferCounter : 0;
            if ((long)ipOfferCounter >= device.dhcpBanDiscoverCount && device.dhcpBanDiscoverCount > 0L) {
                if (logger.isInfoEnabled()) {
                    logger.info("To many discover requests, ipOfferCounter=" + ipOfferCounter + ". Set ban for deviceId: " + device.deviceRuntime.inetDeviceId + ", mac: " + MACParser.macAddressToString((byte[])request.chaddr));
                }
                this.offerMap.offer(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr, null, authResult.accessCode, ipOfferCounter, device.dhcpBanTimeout, device.dhcpBanTimeout);
                this.writeAuthError(device, serv, AccessCode.USER_BANNED.getCode());
                return null;
            }
            logger.info("IP not found in service. Searching in device...");
            if (dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                resource = device.reserveIP(AccessCode.AUTHORIZATION_SUCCEEDED.getCode(), relayDevice, authResult.optionSet);
            } else {
                Set<Integer> inetOptionIds = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? authResult.optionSet : null;
                resource = device.reserveIP(authResult.accessCode, relayDevice, inetOptionIds);
            }
            if (resource != null) {
                offered = this.offerMap.offer(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr, resource, authResult.accessCode, ipOfferCounter + 1, device.dhcpOfferTimeout, device.dhcpBanCheckTimeout);
            }
        }
        if (resource == null) {
            logger.info("Free IP-address not found");
            this.writeAuthError(device, serv, AccessCode.FREE_IP_ADDRESS_NOT_FOUND.getCode());
            return null;
        }
        Set inetOptionIds = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
        this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
        response.messageType = (byte)2;
        this.checkNeedAsyncStart(req, device, parentServ, offered, response);
        if (device.dhcpOfferRandomDelay > 0) {
            try {
                Thread.sleep(this.random.nextInt(device.dhcpOfferRandomDelay) * 5);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private AuthResult authorization(InetDhcpDevice device, ServSearchResult servSearchResult, InetServRuntime parentServRuntime, InetServRuntime servRuntime, InetServ serv, String macString, boolean disableServId, ConnectionListSupplier connectionListSupplier, String identifier) throws Exception {
        AuthResult authResult;
        if (servSearchResult.servRuntime == null) {
            logger.info("inetServ[id=" + serv.getId() + "] sub serv with MAC-addresses not found.");
            authResult = new AuthResult(AccessCode.MAC_DENY.getCode());
        } else {
            int setIdentifier = device.getSetIdentifier(parentServRuntime.inetServTypeRef.get());
            authResult = this.access.authorization(parentServRuntime, servRuntime, false, device.deviceRuntime.inetDeviceId, 0, null, identifier, setIdentifier, null, 0, 0, false, null, null, true, BigDecimal.ZERO, true);
            if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && !disableServId) {
                ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
                Boolean sessionCount = this.access.checkSessionCount(connectionSet, parentServRuntime, servRuntime, 1024, device.getCheckDuplicateSession(parentServRuntime.getInetServTypeRuntime()), false, null, null, macString, true);
                if (Boolean.FALSE.equals(sessionCount)) {
                    logger.info("Too many sessions.");
                    authResult = new AuthResult(AccessCode.TOO_MANY_SESSIONS_ERROR.getCode());
                } else if (Boolean.TRUE.equals(sessionCount)) {
                    connectionListSupplier.delegate = Lazy.of(() -> this.getDhcpConnectionList(parentServRuntime.inetServId));
                }
            }
        }
        return authResult;
    }

    private InetDhcpOfferedAddressMap2.Offered getStaticIpFromServ(DhcpListenerWorker<InetDhcpDevice> req, InetDhcpDevice device, DhcpPacket request, InetServ serv, Supplier<List<InetConnectionRuntime>> connectionListSupplier, AuthResult authResult, byte[] onlyAddress) {
        List<InetServRuntime> childrenServRuntimeList = this.access.inetServRuntimeMap.listChildren(serv.getId(), req.millis);
        Lazy usedAddressSet = Lazy.of(() -> this.usedAddressSet((List)connectionListSupplier.get()));
        InetDhcpOfferedAddressMap2.Offered resource = this.offerMap.offerFromServs(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr, serv, childrenServRuntimeList, (Supplier<HashSet<IpAddress>>)usedAddressSet, authResult.accessCode, device.dhcpOfferTimeout, device.dhcpBanCheckTimeout, onlyAddress);
        return resource;
    }

    private HashSet<IpAddress> usedAddressSet(List<InetConnectionRuntime> connectionList) {
        HashSet<IpAddress> usedAddress = new HashSet<IpAddress>();
        for (InetConnectionRuntime existConnectionRuntime : connectionList) {
            if (existConnectionRuntime.connection.getParentConnectionId() > 0L || (existConnectionRuntime.connection.getType() & 0x400) == 0 && Utils.notEmptyString((String)existConnectionRuntime.connection.getUsername())) continue;
            usedAddress.add(new IpAddress(existConnectionRuntime.connection.getInetAddressBytes()));
        }
        return usedAddress;
    }

    @Override
    protected DhcpPacket processRenewRequest(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws BGException, UnknownHostException {
        try {
            return this.processRenewRequest0(req, clientAddress, request);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private DhcpPacket processRenewRequest0(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws BGException, UnknownHostException, InterruptedException {
        String callingStationId = Utils.bytesToString((byte[])request.chaddr, (boolean)false, null);
        DhcpPacket response = request.createResponse();
        int ipAddress = Utils.convertBytesToInt((byte[])request.ciaddr);
        InetDhcpConnectionEntry[] entries = this.connectionMap.get(ipAddress);
        if (entries == null) {
            logger.error("Not found params for address: " + IpAddress.toString((byte[])request.ciaddr));
            response.messageType = (byte)6;
            return response;
        }
        for (InetDhcpConnectionEntry entry : entries) {
            InetConnectionRuntime connectionRuntime = this.access.connectionManager.getByServ(entry.servId, entry.connectionId);
            if (connectionRuntime != null) {
                if (!callingStationId.equalsIgnoreCase(connectionRuntime.connection.getCallingStationId())) {
                    connectionRuntime = null;
                }
            } else {
                connectionRuntime = this.getConnection(entry, callingStationId);
            }
            if (connectionRuntime == null) continue;
            InetConnection connection = connectionRuntime.connection;
            InetServRuntime servRuntime = this.access.getInetServRuntimeMap().get(connection.getServId());
            InetServRuntime parentServRuntime = servRuntime.getParentInetServRuntime(this.access);
            parentServRuntime.tryLockEx(10L, TimeUnit.SECONDS);
            try {
                boolean needClose;
                InetDhcpDevice device = this.deviceMap.get(connection.getDeviceId());
                if (device == null) {
                    logger.error("Device not found for renew request");
                    response.messageType = (byte)6;
                    DhcpPacket dhcpPacket = response;
                    return dhcpPacket;
                }
                req.relayDeviceId = req.agentDeviceId = device.getId();
                req.setDevice((Idable)device);
                InetServ parentServ = parentServRuntime.getInetServ();
                req.interfaceId = parentServ.getInterfaceId();
                short wantDeviceState = connectionRuntime.getWantDeviceState(this.access, parentServRuntime, servRuntime);
                boolean bl = needClose = wantDeviceState != connection.getDeviceState() || connectionRuntime.wantClose;
                if (needClose) {
                    logger.info("Stopping session with deviceState=" + connection.getDeviceState() + " and wantDeviceState=" + wantDeviceState);
                    req.setConnectionModified(true);
                    this.access.connectionManager.accountingStop(servRuntime.getInetServ(), connection, 5000L);
                    logger.info("Sending NAK to session with deviceState=" + connection.getDeviceState() + " and wantDeviceState=" + wantDeviceState);
                    response.messageType = (byte)6;
                    DhcpPacket dhcpPacket = response;
                    return dhcpPacket;
                }
                Set inetOptionIds = connection.getDeviceState() == InetServState.STATE_ENABLE.getCode() ? connection.getDeviceOptions() : null;
                logger.info("Updating of existing connection: " + String.valueOf(connection));
                this.access.connectionManager.accountingUpdatePool(servRuntime.getInetServ(), connection);
                if (req.isConnectionModified()) {
                    connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(465 + this.random.nextInt(30));
                } else if (connectionRuntime.nextDhcpLog == 0L) {
                    connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(45 + this.random.nextInt(30));
                } else if (connectionRuntime.nextDhcpLog <= req.millis) {
                    connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(465 + this.random.nextInt(30));
                    req.setConnectionModified(true);
                }
                DhcpPacket dhcpPacket = this.buildResponse(req, clientAddress, device, request, response, entry, inetOptionIds, true);
                return dhcpPacket;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            finally {
                parentServRuntime.unlock();
            }
        }
        logger.error("Not found params for address: " + IpAddress.toString((byte[])request.ciaddr));
        response.messageType = (byte)6;
        return response;
    }

    public String getCommandsHelp() {
        StringBuilder result = new StringBuilder();
        result.append("dhcpBanList - show dhcp ban list\n");
        result.append("dhcpBanRemove - drop all ban records\n");
        result.append("dhcpBanRemove <macAddress> - drop ban with MAC-address\n");
        result.append("dhcpBanRemove <macAddress> <deviceId> - drop ban with deviceId and MAC-address\n");
        return result.toString();
    }

    public String executeCommand(String cmd, String param) {
        if ("dhcpBanList".equals(cmd)) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("deviceId\tmac\n");
            for (Map.Entry<InetDhcpOfferedAddressMap2.OfferKey, InetDhcpOfferedAddressMap2.Offered> e : this.offerMap.entrySet()) {
                InetDhcpOfferedAddressMap2.Offered offered = e.getValue();
                if (offered.resource != null) continue;
                InetDhcpOfferedAddressMap2.OfferKey offerKey = e.getKey();
                sb.append(offerKey.deviceId).append('\t').append(MACParser.macAddressToString((byte[])offerKey.mac)).append('\n');
            }
            return sb.toString();
        }
        if ("dhcpBanRemove".equals(cmd)) {
            String[] params = param.split("\\s+");
            int deviceId = 0;
            byte[] mac = null;
            if (params.length > 0) {
                mac = MACParser.parseMacAddress((String)params[0]);
            }
            if (params.length > 1) {
                deviceId = Utils.parseInt((String)params[1], (int)0);
            }
            int count = 0;
            Iterator<Map.Entry<InetDhcpOfferedAddressMap2.OfferKey, InetDhcpOfferedAddressMap2.Offered>> iter = this.offerMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<InetDhcpOfferedAddressMap2.OfferKey, InetDhcpOfferedAddressMap2.Offered> e = iter.next();
                InetDhcpOfferedAddressMap2.Offered offered = e.getValue();
                if (offered.resource != null) continue;
                InetDhcpOfferedAddressMap2.OfferKey offerKey = e.getKey();
                if (deviceId > 0 && deviceId != offerKey.deviceId || mac != null && !IpAddress.equals((byte[])mac, (byte[])offerKey.mac)) continue;
                iter.remove();
                ++count;
            }
            return "Dropped " + count + " records from dhcpBan list";
        }
        if ("status".equals(cmd)) {
            return this.getStatus();
        }
        return null;
    }

    private String getStatus() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("InetDhcpProcessor:\n");
            sb.append("  discovers per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getDiscoverLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getDiscoverLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getDiscoverLastHourAverage())).append("; ");
            sb.append("requests per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getRequestLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getRequestLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getRequestLastHourAverage())).append("; ");
            sb.append("others per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getOtherLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getOtherLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getOtherLastHourAverage())).append('\n');
            sb.append("  offer per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getOfferLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getOfferLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getOfferLastHourAverage())).append("; ");
            sb.append("ack per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getAckLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getAckLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getAckLastHourAverage())).append("; ");
            sb.append("nak per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getNakLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getNakLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getNakLastHourAverage())).append('\n');
            sb.append("  connection start avg time (ms): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getAccountingStartAverageTime())).append('\n');
            return sb.toString();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @MBeanAttribute
    public long getAccountingStartAverageTime() {
        return (long)this.accountingStartAverage.getAverage(System.currentTimeMillis());
    }

    @MBeanAttribute
    public int getNeedAsyncAccountingStart() {
        return this.needAsyncAccountingStart;
    }

    @MBeanAttribute
    public double getAsyncAccountingStartExecutorQueueCurrentMaxSizeFactor() {
        return this.asyncAccountingStartExecutorQueueCurrentMaxSizeFactor;
    }

    public void setAsyncAccountingStartExecutorQueueCurrentMaxSizeFactor(double asyncAccountingStartExecutorQueueCurrentMaxSizeFactor) {
        this.asyncAccountingStartExecutorQueueCurrentMaxSizeFactor = asyncAccountingStartExecutorQueueCurrentMaxSizeFactor;
    }

    @MBeanAttribute
    public int getAsyncAccountingStartExecutorQueueMaxSize() {
        return this.asyncAccountingStartExecutorQueueMaxSize;
    }

    @MBeanAttribute
    public void setAsyncAccountingStartExecutorQueueMaxSize(int asyncAccountingStartExecutorQueueMaxSize) {
        this.asyncAccountingStartExecutorQueueMaxSize = Math.min(1900, asyncAccountingStartExecutorQueueMaxSize);
    }

    @MBeanAttribute
    public int getAsyncAccountingStartExecutorQueueCurrentMaxSize() {
        return this.asyncAccountingStartExecutorQueueCurrentMaxSize;
    }

    @MBeanAttribute
    public void setAsyncAccountingStartExecutorQueueCurrentMaxSize(int asyncAccountingStartExecutorQueueCurrentMaxSize) {
        this.asyncAccountingStartExecutorQueueCurrentMaxSize = asyncAccountingStartExecutorQueueCurrentMaxSize;
    }

    @MBeanAttribute
    public int getAsyncAccountingStartExecutorQueueSize() {
        return this.asyncAccountingStartExecutor.getQueue().size();
    }

    @MBeanAttribute
    public int getBlockOfferOnAccountingStartErrors() {
        return this.blockOfferOnAccountingStartErrors;
    }

    public void setBlockOfferOnAccountingStartErrors(int blockOfferOnAccountingStartErrors) {
        this.blockOfferOnAccountingStartErrors = blockOfferOnAccountingStartErrors;
    }

    private static class ConnectionListSupplier
    implements Supplier<List<InetConnectionRuntime>> {
        Supplier<List<InetConnectionRuntime>> delegate;

        private ConnectionListSupplier() {
        }

        @Override
        public List<InetConnectionRuntime> get() {
            return this.delegate.get();
        }
    }
}

