/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff;

import bitel.billing.module.tariff.XMLTariffLoadDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.List;
import javax.swing.JDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.TariffNodeMenuItem;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.XMLUtils;

public class XMLTariffLoader
extends TariffNodeMenuItem {
    public static final int LOAD_ACTION = 1;
    public static final int UPLOAD_ACTION = 2;
    public static final int ADDLOAD_ACTION = 3;

    @Override
    public JDialog getDialog() {
        return new XMLTariffLoadDialog(BGClientBase.getFrame(), this);
    }

    public String doAction(int actionCode, File file) {
        StringBuffer report = new StringBuffer();
        switch (actionCode) {
            case 2: {
                this.upload(report, file);
                break;
            }
            case 1: {
                this.load(report, file);
                break;
            }
            default: {
                this.addload(report, file);
            }
        }
        return report.toString();
    }

    private void upload(StringBuffer report, File file) {
        try {
            Document doc = XMLUtils.newDocument();
            Element root = doc.createElement("nodes");
            doc.appendChild(root);
            this._node.serializeChildsToXML(root);
            FileOutputStream fos = new FileOutputStream(file);
            XMLUtils.serialize((Node)doc, fos, "UTF-8");
            fos.close();
        }
        catch (Exception ex) {
            report.append("\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addload(StringBuffer report, File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            String xml = new String(data, "UTF-8");
            data = null;
            Document doc = XMLUtils.parseDocument(new InputSource(new StringReader(xml)));
            Element root = doc.getDocumentElement();
            this._node.loadChildsFromXML(root);
        }
        catch (Exception ex) {
            report.append("\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void load(StringBuffer report, File file) {
        try {
            List<TariffTreeNode> nodes = this._node.getChilds();
            while (nodes.size() > 0) {
                nodes.get(0).deleteAction();
            }
            this.addload(report, file);
        }
        catch (Exception ex) {
            report.append("\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
            ClientUtils.showErrorMessageDialog(ex);
        }
    }
}

