package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import org.json.JSONObject;

import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.common.Utils;

public class CheckPassword
    extends BGLogger
    implements DialogProcessing
{
    /**
     * id диалога, который будет показан в случае совпадения пароля договора с переданным пользователем
     */
    private final int NEXT_DIALOG = 10;

    @Override
    public void preDialog( ServerContext serverContext, JSONObject botData )
    {

    }

    @Override
    public void processDialog( ServerContext serverContext,
                               JSONObject botData,
                               String inputTextOfUser )
    {
        int contractId = botData.optInt( CONTRACT_ID, -1 );
        if ( Utils.notBlankString( inputTextOfUser ) && contractId > 0 )
        {
            Contract contract = null;
            try
            {
                contract = ContractDao.getContract( serverContext.getConnection(), contractId );
            }
            catch ( Exception ex )
            {
            }
            if ( contract != null && contract.getPassword().equals( inputTextOfUser ) )
            {
                // отправляем на диалог с данными пользователя
                botData.put( NEXT_DIALOG_ID, NEXT_DIALOG );
                botData.put( CONTRACT_ID, contract.getId() );
            }
            else
            {
                if ( contract == null )
                {
                    getLogger().error( "Contract is null!" );
                }
                else
                {
                    //говорим, что пароль не верный
                    botData.put( ERROR_MESSAGE, "Вы указали не верный пароль" );
                    if ( getLogger().isDebugEnabled() )
                    {
                        getLogger().debug( "Password for contract=" + contractId + " is not valid" );
                    }
                }
            }
        }
        else
        {
            //говорим, что не верный пароль
            botData.put( ERROR_MESSAGE, "Вы указали не верный пароль" );
            if ( getLogger().isDebugEnabled() )
            {
                getLogger().debug( "Password for contract=" + contractId + " is not valid" );
            }
        }
    }

    @Override
    public String title()
    {
        return "Проверка пароля";
    }
}
