/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ContractPatternNamedNumberDao
extends AbstractIdDao<ContractPatternNamedNumber> {
    public ContractPatternNamedNumberDao(Connection con) {
        super(con, "contract_pattern_named_numbers");
    }

    public List<ContractPatternNamedNumber> list() throws SQLException {
        return this.list(null, null, new Object[0]);
    }

    public ContractPatternNamedNumber getFromTitle(String title) throws SQLException {
        Objects.requireNonNull(title);
        return (ContractPatternNamedNumber)((Object)this.get("title=?", new Object[]{title}));
    }

    public int getNextNamedNumberIndex(String title) throws SQLException {
        int result;
        block19: {
            Objects.requireNonNull(title);
            result = -1;
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET ln=(@lastNumber:=ln)+1 WHERE title=?");
                 PreparedStatement ps2 = this.con.prepareStatement("SELECT @lastNumber");){
                ps.setString(1, title);
                if (ps.executeUpdate() <= 0) break block19;
                try (ResultSet rs = ps2.executeQuery();){
                    if (rs.next()) {
                        result = rs.getInt(1) + 1;
                    }
                }
            }
        }
        return result;
    }

    protected void updateImpl(ContractPatternNamedNumber namedNumber) throws SQLException {
        boolean update = namedNumber.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, comment=?" + (update ? " WHERE id=" + namedNumber.getId() : ", ln=" + namedNumber.getIndex() + ", count_number=" + namedNumber.getCountNumber());
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, namedNumber.getTitle());
            ps.setString(2, namedNumber.getComment());
            try {
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new SQLException("\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0438\u043c\u0435\u043d\u0438 \"" + namedNumber.getTitle() + "\"! \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0435 \u0438\u043c\u044f.");
            }
            if (namedNumber.getId() <= 0) {
                namedNumber.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    protected ContractPatternNamedNumber getFromRS(ResultSet rs) throws SQLException {
        return ContractPatternNamedNumber.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setIndex(rs.getInt("ln")).setCountNumber(rs.getInt("count_number")).setComment(rs.getString("comment")).build();
    }
}

