/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private String USER_DATA_TABLE = null;
    private String TRANSACTION_PAYMENT_MAP = null;
    public static final int PAYMENT_TYPE_PAYMENT = 0;
    public static final int PAYMENT_TYPE_CHARGE = 1;

    public TransactionManager(Connection con, int moduleId) {
        super(con, "payonline_transaction", moduleId);
        this.USER_DATA_TABLE = this.getTableName("payonline_user_data", moduleId, null);
        this.TRANSACTION_PAYMENT_MAP = this.getTableName("payonline_transaction_payment_map", moduleId, null);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("sum", "summa");
    }

    public void update(Transaction b) throws SQLException {
        super.update((Object)b);
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        block21: {
            Objects.requireNonNull(transaction);
            if (transaction.getId() > 0) {
                return;
            }
            String query = "SELECT * FROM " + this.tableName + " WHERE trans_id =? AND contract_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, transaction.getTransactionId());
                ps.setInt(2, transaction.getContractId());
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        query = "INSERT INTO " + this.tableName + " SET trans_id=?, summa=?, contract_id=?, pay_date=?";
                        try (PreparedStatement psInsert = this.con.prepareStatement(query, 1);){
                            psInsert.setString(1, transaction.getTransactionId());
                            psInsert.setBigDecimal(2, transaction.getSum());
                            psInsert.setInt(3, transaction.getContractId());
                            psInsert.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                            if (psInsert.executeUpdate() > 0) {
                                transaction.setId(ServerUtils.lastInsertId((PreparedStatement)psInsert));
                            }
                            break block21;
                        }
                    }
                    throw new SQLException("\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c payonline " + transaction.getTransactionId() + " \u0443\u0436\u0435 \u0431\u044b\u043b \u0440\u0430\u043d\u0435\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                }
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    protected Transaction getFromRS(ResultSet rs, boolean setContractTitle) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(rs.getInt("contract_id"))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pay_date")))).setSum(rs.getBigDecimal("summa"))).setId(rs.getInt("id"))).setTransactionId(rs.getString("trans_id"))).setContractTitle(setContractTitle ? rs.getString("c.title") : null)).build();
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String transactionStatus) throws SQLException {
        ResultSet rs;
        int index;
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        StringBuilder query = new StringBuilder("SELECT pt.*, c.title FROM ").append(this.tableName).append(" AS pt");
        if ("rebill".equals(transactionStatus)) {
            query.append(" INNER JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
        } else if ("usual".equals(transactionStatus)) {
            query.append(" LEFT JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
        }
        query.append(" LEFT JOIN contract c ON c.id=pt.contract_id");
        query.append(" WHERE true ");
        if (contractId > 0) {
            query.append(" AND pt.contract_id=").append(contractId);
        }
        if (Utils.notBlankString((String)contractTitle)) {
            query.append(" AND c.title LIKE ?");
        }
        query.append(this.queryPeriod(period, "pt.pay_date"));
        if ("usual".equals(transactionStatus)) {
            query.append(" AND prt.id IS NULL ");
        }
        query.append(this.getSQLOrder(sort, this.fields));
        query.append(this.sqlLimit(page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            index = this.psSetPeriod(ps, index, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs, true));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = new StringBuilder("SELECT SUM(summa), COUNT(summa) FROM ").append(this.tableName).append(" AS pt ");
        if ("usual".equals(transactionStatus)) {
            query.append("LEFT JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
        }
        query.append(" LEFT JOIN contract c ON c.id=pt.contract_id");
        query.append(" WHERE true");
        if (contractId > 0) {
            query.append(" AND pt.contract_id=" + contractId);
        }
        if (Utils.notBlankString((String)contractTitle)) {
            query.append(" AND c.title LIKE ?");
        }
        query.append(this.queryPeriod(period, "pt.pay_date"));
        if ("usual".equals(transactionStatus)) {
            query.append(" AND prt.id IS NULL ");
        }
        ps = this.con.prepareStatement(query.toString());
        try {
            index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            index = this.psSetPeriod(ps, index, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    BigDecimal summa = rs.getBigDecimal(1);
                    if (summa != null) {
                        searchResult.setSum(summa);
                    }
                    page.setRecordCount(rs.getInt(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<Transaction> getList() throws SQLException {
        return this.list("", "pay_date", new Object[0]);
    }

    public List<Transaction> getList(int contractId) throws SQLException {
        return this.list("contract_id=?", "pay_date", new Object[]{contractId});
    }

    public List<Transaction> getList(int contractId, Period period) throws SQLException {
        if (period == null) {
            return this.listImpl(new Page(1, 3), "contract_id=?", "pay_date DESC", new Object[]{contractId});
        }
        return this.list("contract_id=? AND (? IS NULL OR pay_date>=?) AND (? IS NULL OR pay_date<=?)", "pay_date DESC", new Object[]{contractId, period.getDateFrom(), period.getDateFrom(), period.getDateTo(), period.getDateTo()});
    }

    public Transaction getByTransId(long transId) throws SQLException {
        return (Transaction)this.get("trans_id=?", new Object[]{transId});
    }

    public void addUserData(int contactId, String cardNumber, String rebillAnchor) throws SQLException {
        int index;
        String userDataTableCreateQuery = "CREATE TABLE " + this.USER_DATA_TABLE + " ( `contractId` INT NOT NULL, `cardNumber` VARCHAR(4) NOT NULL, `rebillAnchor` VARCHAR(64) NULL, PRIMARY KEY (`contractId`, `cardNumber`, `rebillAnchor`))";
        ServerUtils.checkTable((Connection)this.con, (String)this.USER_DATA_TABLE, (String)userDataTableCreateQuery);
        String query = "SELECT COUNT(*) FROM " + this.USER_DATA_TABLE + " WHERE contractId=? AND cardNumber=? AND rebillAnchor=?";
        int recordCount = -1;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setInt(index++, contactId);
            ps.setString(index++, cardNumber);
            ps.setString(index++, rebillAnchor);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                recordCount = rs.getInt(1);
            }
        }
        if (recordCount <= 0) {
            query = "INSERT INTO " + this.USER_DATA_TABLE + " (contractId, cardNumber, rebillAnchor) VALUES (?,?,?)";
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setInt(index++, contactId);
                ps.setString(index++, cardNumber);
                ps.setString(index++, rebillAnchor);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public void addPaymentToTransaction(long transactionId, int paymentId, int paymentType) throws SQLException {
        String query = "INSERT INTO " + this.TRANSACTION_PAYMENT_MAP + " SET transaction_id=?, payment_id=?, type=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, transactionId);
            ps.setInt(2, paymentId);
            ps.setInt(3, paymentType);
            ps.executeUpdate();
        }
    }

    public void deletePaymentToTransaction(long transactionId) throws SQLException {
        String query = "DELETE FROM " + this.TRANSACTION_PAYMENT_MAP + " WHERE transaction_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, transactionId);
            ps.executeUpdate();
        }
    }

    public int getPaymentIdToTransaction(long transactionId, int paymentType) throws SQLException {
        int result = -1;
        String query = "SELECT payment_id FROM " + this.TRANSACTION_PAYMENT_MAP + " WHERE transaction_id=? AND type=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, transactionId);
            ps.setInt(2, paymentType);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            int n = result;
            return n;
        }
    }
}

