/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGJsonReport
extends BGReport {
    private Document repxmldoc = null;
    private List<Field> fields = null;
    protected JSONObject jsonObject = null;

    @Override
    public void init(Connection con, Preferences moduleSetup, int userId, String id, File cfg, DynamicClass cfg_clazz) throws BGException {
        super.init(con, moduleSetup, userId, id, cfg, cfg_clazz);
        try {
            if (cfg != null) {
                this.repxmldoc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(cfg)), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
            }
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u043f\u0438\u0441\u0430\u0442\u0435\u043b\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return "json";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        try {
            this.writeJSON(this.getFields(), this.getReportResult(), out);
        }
        catch (BGMessageException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)e);
        }
    }

    public ReportResult getReportResult() throws Exception {
        Object dyn_class = null;
        if (this.repxmldoc != null && (dyn_class = XMLUtils.selectText((Node)this.repxmldoc, (String)"/report/@dyn_class", null)) == null && this.cfg_clazz != null) {
            dyn_class = this.cfg_clazz.getResourcePackageName() + "." + this.id;
        }
        return dyn_class == null ? new ReportResult(this) : this.getResultDyncode((String)dyn_class, this.getFields());
    }

    protected void fillJsonReportToStream(OutputStream out) throws Exception {
        try {
            if (this.cfg != null) {
                this.repxmldoc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(this.cfg)), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
            }
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u043f\u0438\u0441\u0430\u0442\u0435\u043b\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)e);
        }
        if (this.jsonObject == null) {
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            this.jsonObject = new JSONObject();
            this.writeHeader(this.getFields());
            writer.write(this.jsonObject.toString());
            writer.flush();
            writer.close();
            Object var2_3 = null;
        }
    }

    protected int writeHeader(List<Field> fields) {
        if (this.jsonObject != null) {
            JSONArray headers = new JSONArray();
            for (int i = 0; i < fields.size(); ++i) {
                JSONObject header = new JSONObject();
                header.put("title", (Object)fields.get((int)i).title);
                header.put("type", (Object)fields.get((int)i).type);
                header.put("align", (Object)String.valueOf(fields.get((int)i).align));
                header.put("wmin", (Object)String.valueOf(fields.get((int)i).width[0]));
                header.put("wpref", (Object)String.valueOf(fields.get((int)i).width[1]));
                header.put("wmax", (Object)String.valueOf(fields.get((int)i).width[2]));
                headers.put((Object)header);
            }
            this.jsonObject.put("headers", (Object)headers);
        }
        return fields.size();
    }

    protected void writeJSON(List<Field> fields, ReportResult result, OutputStream out) throws IOException {
        this.jsonObject = new JSONObject();
        this.writeHeader(fields);
        JSONArray rows = new JSONArray();
        int count = result.getData().size();
        for (int j = 0; j < count; ++j) {
            JSONArray row = new JSONArray();
            int len = fields.size();
            for (int i = 0; i < len; ++i) {
                row.put((Object)result.getData().get(j)[i]);
            }
            rows.put((Object)row);
        }
        this.jsonObject.put("rows", (Object)rows);
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        writer.write(this.jsonObject.toString());
        writer.flush();
        writer.close();
    }

    public List<Field> getFields() throws Exception {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
            if (this.repxmldoc != null) {
                for (Element item : XMLUtils.selectElements((Node)this.repxmldoc, (String)"//fields/item")) {
                    Field field = new Field();
                    field.title = XMLUtils.getAttribute((Element)item, (String)"title", (String)"");
                    field.type = XMLUtils.getAttribute((Element)item, (String)"type", (String)"string");
                    field.align = Utils.parseInt((String)XMLUtils.getAttribute((Element)item, (String)"align", (String)"-1"));
                    field.width = new int[]{Utils.parseInt((String)XMLUtils.getAttribute((Element)item, (String)"wmin", (String)"-1"), (int)-1), Utils.parseInt((String)XMLUtils.getAttribute((Element)item, (String)"wpref", (String)"-1"), (int)-1), Utils.parseInt((String)XMLUtils.getAttribute((Element)item, (String)"wmax", (String)"-1"), (int)-1)};
                    this.fields.add(field);
                }
            }
        }
        return this.fields;
    }

    private ReportResult getResultDyncode(String dyn_class, List<Field> fields) throws BGException {
        ReportResult result = new ReportResult(this);
        long time = System.currentTimeMillis();
        try {
            this.getLogger().info("Running dyncode for csv report ");
            if (fields.isEmpty()) {
                filler = (JsonFillerDataFields)DynamicClassManager.getInstance().newInstance(JsonFillerDataFields.class, dyn_class);
                filler.fillReport(this.con, this.createBGReportFilter(), result, fields);
            } else {
                filler = (JsonFillerData)DynamicClassManager.getInstance().newInstance(JsonFillerData.class, dyn_class);
                filler.fillReport(this.con, this.createBGReportFilter(), result);
            }
        }
        catch (BGMessageException ex) {
            this.getLogger().debug("BGMessageException: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.getLogger().error("Eval error: " + ex.getMessage(), (Throwable)ex);
            throw new BGException((Throwable)ex);
        }
        long processTime = System.currentTimeMillis() - time;
        this.getLogger().info("Process time => " + processTime);
        return result;
    }

    public class ReportResult {
        private List<String[]> data = new ArrayList<String[]>();
        private int count = 0;

        public ReportResult(BGJsonReport this$0) {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<String[]> getData() {
            return this.data;
        }

        public void setData(List<String[]> data) {
            this.data = data;
        }
    }

    public static class Field {
        public String title;
        public String type;
        public int align = -1;
        public int[] width = new int[]{-1, -1, -1};

        public Field() {
        }

        public Field(String title, String type, int align, int[] width) {
            this.title = title;
            this.type = type;
            this.align = align;
            this.width = width;
        }
    }

    public static interface JsonFillerDataFields {
        public void fillReport(Connection var1, BGReportFilter var2, ReportResult var3, List<Field> var4) throws Exception;
    }

    public static interface JsonFillerData {
        public void fillReport(Connection var1, BGReportFilter var2, ReportResult var3) throws Exception;
    }
}

