/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.bean.DPayment;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentList;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.bgbilling.modules.card.server.bean.RevisePayments;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class DPaymentManager {
    private Connection con;
    private int mid;
    private Preferences moduleSetup;
    private static final Pattern patPayment = Pattern.compile("^(.+)\\t([\\.\\d+\\\\/: -]+)\\t(.+)\\t(\\d+\\.*\\d*)$", 8);

    public DPaymentManager(Preferences moduleSetup, Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.moduleSetup = moduleSetup;
    }

    public List<DPayment> getPaymentList(int dealerId, Date dateFrom, Date dateTo, int type, Page page) {
        ArrayList<DPayment> result = new ArrayList<DPayment>();
        try {
            String table;
            if (dateFrom == null) {
                dateFrom = new Date();
            }
            if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)dateFrom, (int)this.mid)))) {
                StringBuffer query = new StringBuffer("SELECT pay.*, payment.id, payment.comment, payment.pt, contract.title as contract_title, contract.comment as contract_comment FROM ");
                query.append(table);
                query.append(" as pay LEFT JOIN contract_payment as payment ON payment.id=pay.pid, contract");
                query.append(" WHERE pay.did=?");
                if (dateFrom != null) {
                    query.append(" AND TO_DAYS(pay.dt)>=TO_DAYS(?)");
                }
                if (dateTo != null) {
                    query.append(" AND TO_DAYS(pay.dt)<=TO_DAYS(?)");
                }
                if (type == 0) {
                    query.append(" AND pay.status!=1");
                } else if (type == 1) {
                    query.append(" AND pay.status=1");
                }
                query.append(" AND pay.cid=contract.id");
                query.append(" ORDER BY pay.id");
                if (page.getPageSize() > 0) {
                    query.append(page.sqlLimit());
                }
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                int iter = 1;
                ps.setInt(iter++, dealerId);
                if (dateFrom != null) {
                    ps.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                }
                if (dateTo != null) {
                    ps.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)dateTo));
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getDPaymentFromRS(rs));
                }
                rs.close();
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public DPaymentList getDPaymentList(int dealerId, Date dateFrom, Date dateTo, int type, Page page) {
        DPaymentList result = new DPaymentList();
        ArrayList<DPayment> paymentList = new ArrayList<DPayment>();
        result.setPaymentList(paymentList);
        result.setPage(page);
        try {
            String table;
            if (dateFrom == null) {
                dateFrom = new Date();
            }
            if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)dateFrom, (int)this.mid)))) {
                StringBuffer where = new StringBuffer(" WHERE pay.did=");
                where.append(dealerId);
                if (dateFrom != null) {
                    where.append(" AND TO_DAYS(pay.dt)>=TO_DAYS('" + TimeUtils.formatSQLDate((Date)dateFrom) + "')");
                }
                if (dateTo != null) {
                    where.append(" AND TO_DAYS(pay.dt)<=TO_DAYS('" + TimeUtils.formatSQLDate((Date)dateTo) + "')");
                }
                if (type == 0) {
                    where.append(" AND pay.status!=1");
                } else if (type == 1) {
                    where.append(" AND pay.status=1");
                }
                Statement st = this.con.createStatement();
                StringBuffer query = new StringBuffer("SELECT COUNT(pay.id), SUM(pay.summ) FROM ");
                query.append(table);
                query.append(" as pay");
                query.append(where);
                ResultSet rs = st.executeQuery(query.toString());
                if (rs.next()) {
                    int records = rs.getInt(1);
                    result.setNumber(records);
                    result.setTotal(rs.getFloat(2));
                    page.setRecordCount(records);
                }
                rs.close();
                query.append(" AND status=1");
                rs = st.executeQuery(query.toString());
                if (rs.next()) {
                    result.setNumberPayed(rs.getInt(1));
                    result.setTotalPayed(rs.getFloat(2));
                }
                rs.close();
                query = new StringBuffer("SELECT pay.*, payment.id, payment.comment, payment.pt, contract.title as contract_title, contract.comment as contract_comment FROM ").append(table);
                query.append(" as pay LEFT JOIN contract_payment as payment ON payment.id=pay.pid, contract");
                query.append(where);
                query.append(" AND pay.cid=contract.id ORDER BY pay.id");
                if (page.getPageSize() > 0) {
                    query.append(page.sqlLimit());
                }
                rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    paymentList.add(this.getDPaymentFromRS(rs));
                }
                rs.close();
                st.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getMaxPage(int dealerId, Date dateFrom, Date dateTo, int type, int pageSize) {
        String table;
        if (pageSize == 0) {
            return 0;
        }
        int result = 0;
        if (dateFrom == null) {
            dateFrom = new Date();
        }
        if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)dateFrom, (int)this.mid)))) {
            StringBuffer query = new StringBuffer("SELECT COUNT(id) FROM " + table + " as pay");
            query.append("  WHERE pay.did=?");
            if (dateFrom != null) {
                query.append(" AND pay.dt>=?");
            }
            if (dateTo != null) {
                query.append(" AND pay.dt<=?");
            }
            if (type == 0) {
                query.append(" AND pay.status!=1");
            } else if (type == 1) {
                query.append(" AND pay.status=1");
            }
            try {
                ResultSet rs;
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                int iter = 1;
                ps.setInt(iter++, dealerId);
                if (dateFrom != null) {
                    ps.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                }
                if (dateTo != null) {
                    ps.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)dateTo));
                }
                if ((rs = ps.executeQuery()).next()) {
                    int maxPage;
                    int records = rs.getInt(1);
                    result = maxPage = records % pageSize > 0 ? records / pageSize + 1 : records / pageSize;
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result > 0 ? result : 1;
    }

    public DPayment getDPayment(Date date, int dealerId, int cid, int id) {
        DPayment result = null;
        try {
            String table;
            if (date == null) {
                date = new Date();
            }
            if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)date, (int)this.mid)))) {
                String query = "SELECT pay.*, payment.id, payment.comment, payment.pt, contract.title as contract_title, contract.comment as contract_comment FROM " + table + " as pay LEFT JOIN contract_payment as payment ON payment.id=pay.pid, contract WHERE pay.did=? AND pay.cid=? AND pay.id=? AND pay.cid=contract.id";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, dealerId);
                ps.setInt(2, cid);
                ps.setInt(3, id);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = this.getDPaymentFromRS(rs);
                }
                rs.close();
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public DPayment getDPayment(Date date, int dealerId, int id) {
        DPayment result = null;
        try {
            String table;
            if (date == null) {
                date = new Date();
            }
            if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)date, (int)this.mid)))) {
                ResultSet rs = null;
                PreparedStatement ps = null;
                String query = "SELECT pay.*, payment.id, payment.comment, payment.pt, contract.title as contract_title, contract.comment as contract_comment FROM " + table + " as pay LEFT JOIN contract_payment as payment ON payment.id=pay.pid, contract WHERE pay.did=? AND pay.id=? AND pay.cid=contract.id";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, dealerId);
                ps.setInt(2, id);
                rs = ps.executeQuery();
                while (rs.next()) {
                    result = this.getDPaymentFromRS(rs);
                }
                rs.close();
                ps.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public DPayment getDPayment(Date date, int dealerId, int cid, String transId) {
        DPayment result = null;
        try {
            String table;
            if (date == null) {
                date = new Date();
            }
            if (ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)date, (int)this.mid)))) {
                String query = "SELECT pay.*, payment.id, payment.comment, payment.pt, contract.title as contract_title, contract.comment as contract_comment FROM " + table + " as pay LEFT JOIN contract_payment as payment ON payment.id=pay.pid, contract WHERE pay.did=? AND pay.cid=? AND pay.trans=? AND pay.cid=contract.id";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, dealerId);
                ps.setInt(2, cid);
                ps.setString(3, transId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = this.getDPaymentFromRS(rs);
                }
                rs.close();
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private DPayment getDPaymentFromRS(ResultSet rs) throws SQLException {
        DPayment result = new DPayment();
        result.setContractComment(rs.getString("contract_comment"));
        result.setContractId(rs.getInt("cid"));
        result.setContractTitle(rs.getString("contract_title"));
        result.setDateTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        result.setPaymentType(rs.getInt("payment.pt"));
        result.setId(rs.getInt("id"));
        result.setTransId(rs.getString("trans"));
        result.setPaymentComment(rs.getString("comment"));
        result.setPaymentId(rs.getInt("payment.id"));
        result.setSumma(rs.getBigDecimal("summ"));
        result.setStatus(rs.getInt("status"));
        return result;
    }

    public DPayment addPayment(Dealer dealer, DPayment dpayment) throws BGException {
        boolean result = true;
        Calendar now = new GregorianCalendar();
        dpayment.setDateTime(now.getTime());
        dpayment.setDealerId(dealer.getId());
        int id = 0;
        try {
            String query = null;
            String table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)dpayment.getDateTime(), (int)this.mid);
            if (!ServerUtils.tableExists((Connection)this.con, (String)table)) {
                query = "CREATE TABLE `" + table + "` (`id` int(11) NOT NULL auto_increment,`did` int(11) default NULL,`trans` varchar(255) default NULL,`cid` int(11) default NULL,`pid` int(11) default NULL,`dt` datetime default NULL,`summ` float(15,2) default NULL,`status` int(11) default NULL,UNIQUE KEY `id` (`id`),KEY `trans` (`trans`),KEY `pid` (`pid`),KEY `did` (`did`))";
                ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)table, (String)query);
            }
            query = "SELECT id FROM " + table + " WHERE did=? AND trans=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, dealer.getId());
            ps.setString(2, dpayment.getTransId());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = false;
                id = rs.getInt(1);
                rs.close();
                ps.close();
            } else if (now.get(5) == 1 && now.get(11) == 0) {
                Calendar previousMonth = (Calendar)((Calendar)now).clone();
                previousMonth.add(2, -1);
                String previosTable = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)previousMonth.getTime(), (int)this.mid);
                if (ServerUtils.tableExists((Connection)this.con, (String)previosTable)) {
                    rs.close();
                    ps.close();
                    query = "SELECT id FROM " + previosTable + " WHERE did=? AND trans=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, dealer.getId());
                    ps.setString(2, dpayment.getTransId());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        result = false;
                        id = rs.getInt(1);
                        now = previousMonth;
                    }
                    rs.close();
                    ps.close();
                }
            }
            if (result) {
                if ((dealer.getParams() & 0x40000000) == 0) {
                    Payment payment = new Payment();
                    payment.setContractId(dpayment.getContractId());
                    if (dealer.getPayComissionType() == 1) {
                        payment.setSum(dpayment.getSumma().multiply(new BigDecimal(1.0f - dealer.getPayPercent() / 100.0f)));
                    } else {
                        payment.setSum(dpayment.getSumma());
                    }
                    payment.setDate(dpayment.getDateTime());
                    payment.setComment(dpayment.getPaymentComment());
                    payment.setUserId(0);
                    payment.setTypeId(dpayment.getPaymentType());
                    Contract contract = ContractDao.getContract((Connection)this.con, (int)dpayment.getContractId());
                    new PaymentDao(this.con).update((Object)payment);
                    this.con.commit();
                    try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                        balanceUtils.updateBalance(payment.getDate(), contract.getId());
                    }
                    this.con.commit();
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
                    dpayment.setPaymentId(payment.getId());
                } else {
                    dpayment.setPaymentId(-10);
                }
                query = "INSERT INTO " + table + " SET did=?, trans=?, cid=?, pid=?, dt=?, summ=?, status=?";
                try (PreparedStatement psInsert = this.con.prepareStatement(query, 1);){
                    psInsert.setInt(1, dealer.getId());
                    psInsert.setString(2, dpayment.getTransId());
                    psInsert.setInt(3, dpayment.getContractId());
                    psInsert.setInt(4, dpayment.getPaymentId());
                    psInsert.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)dpayment.getDateTime()));
                    psInsert.setBigDecimal(6, dpayment.getSumma());
                    psInsert.setInt(7, 1);
                    psInsert.executeUpdate();
                    dpayment.setStatus(1);
                    dpayment.setId(ServerUtils.lastInsertId((PreparedStatement)psInsert));
                }
            }
            return this.getDPayment(now.getTime(), dealer.getId(), id);
            this.updateComission(dealer.getContractId(), dpayment.getDateTime());
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return null;
    }

    public int cancelPayment(Dealer dealer, int cid, String transId) throws Exception {
        GregorianCalendar date = new GregorianCalendar();
        DPayment payment = this.getDPayment(date.getTime(), dealer.getId(), cid, transId);
        if (payment == null) {
            ((Calendar)date).add(2, -1);
            payment = this.getDPayment(date.getTime(), dealer.getId(), cid, transId);
        }
        return this.cancelPayment(dealer, payment);
    }

    public int cancelPayment(Dealer dealer, int cid, int id) throws Exception {
        GregorianCalendar date = new GregorianCalendar();
        DPayment payment = this.getDPayment(date.getTime(), dealer.getId(), cid, id);
        if (payment == null) {
            ((Calendar)date).add(2, -1);
            payment = this.getDPayment(date.getTime(), dealer.getId(), cid, id);
        }
        return this.cancelPayment(dealer, payment);
    }

    public int cancelPayment(Dealer dealer, DPayment payment) throws Exception {
        int result = 0;
        if (payment != null) {
            GregorianCalendar date = new GregorianCalendar();
            ((Calendar)date).add(12, -dealer.getCanselTime());
            if (payment.getDateTime().after(date.getTime())) {
                if (!this.cancelPayment(payment)) {
                    result = -1;
                } else {
                    this.updateComission(dealer.getContractId(), payment.getDateTime());
                }
            } else {
                result = -2;
            }
        } else {
            result = -3;
        }
        return result;
    }

    private boolean cancelPayment(DPayment dPayment) throws Exception {
        int result;
        block12: {
            String table;
            result = 0;
            if (dPayment.getStatus() == 1 && ServerUtils.tableExists((Connection)this.con, (String)(table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)dPayment.getDateTime(), (int)this.mid)))) {
                String query = "UPDATE " + table + " SET status=? WHERE id=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setInt(1, 0);
                    ps.setInt(2, dPayment.getId());
                    result = ps.executeUpdate();
                    if (result <= 0) break block12;
                    PaymentDao paymentDao = new PaymentDao(this.con);
                    Payment payment = (Payment)paymentDao.get(dPayment.getPaymentId());
                    paymentDao.delete(dPayment.getPaymentId());
                    this.con.commit();
                    try (BalanceUtils bu = new BalanceUtils(this.con);){
                        bu.updateBalance(dPayment.getDateTime(), dPayment.getContractId());
                    }
                    this.con.commit();
                    EventProcessor.getInstance().publish((Event)new PaymentDeletedEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(dPayment.getContractId(), 3, payment.getSum().negate()));
                }
            }
        }
        return result > 0;
    }

    public RevisePayments revisePayments(int id, Date dateFrom, Date dateTo, String fileString) {
        RevisePayments revisePayments = new RevisePayments();
        List<DPayment> dbPaymentList = this.getPaymentList(id, dateFrom, dateTo, 3, new Page(0, 0));
        List<DPayment> exPaymentList = this.getPaymentListFromFile(fileString);
        for (DPayment dbPayment : dbPaymentList) {
            boolean find = false;
            for (int i = 0; i < exPaymentList.size(); ++i) {
                DPayment exPayment = exPaymentList.get(i);
                int res = exPayment.equalz(dbPayment);
                if (res == 0) {
                    exPaymentList.remove(i);
                    find = true;
                    break;
                }
                if (res != 1) continue;
                revisePayments.getList2().add(exPayment);
                revisePayments.getList2().add(dbPayment);
                exPaymentList.remove(i);
                find = true;
                break;
            }
            if (find) continue;
            revisePayments.getList1().add(dbPayment);
        }
        revisePayments.setList0(exPaymentList);
        return revisePayments;
    }

    protected List<DPayment> getPaymentListFromFile(String fileString) {
        ArrayList<DPayment> result = new ArrayList<DPayment>();
        Matcher match = patPayment.matcher(fileString);
        while (match.find()) {
            DPayment payment = new DPayment();
            payment.setTransId(match.group(1));
            Date temp = TimeUtils.parseDate((String)match.group(2), (String)"dd.MM.yyyy HH:mm:ss");
            if (temp == null) {
                temp = TimeUtils.parseDate((String)match.group(2), (String)"yyyy-MM-dd HH:mm:ss");
            }
            payment.setDateTime(temp);
            payment.setContractTitle(match.group(3));
            payment.setSumma(Utils.parseBigDecimal((String)match.group(4), (BigDecimal)BigDecimal.ZERO));
            payment.setStatus(1);
            result.add(payment);
        }
        return result;
    }

    public void updateComission(int contractId, Date month) throws BGException {
        int servicePay = this.moduleSetup.getInt("dealer.pay.sid", 0);
        int serviceBonus = this.moduleSetup.getInt("dealer.bonus.sid", 0);
        DealerManager dm = new DealerManager(this.con, this.mid);
        List<Dealer> dealers = dm.getDealersByContractId(contractId, 2);
        BigDecimal totalAccount = BigDecimal.ZERO;
        BigDecimal totalBonus = BigDecimal.ZERO;
        for (Dealer d : dealers) {
            BigDecimal[] pair = this.getDealerComission(d, month);
            if (pair.length < 2) continue;
            totalAccount = totalAccount.add(pair[0]);
            totalBonus = totalBonus.add(pair[1]);
        }
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            LocalDate localDate = TimeUtils.convertDateToLocalDate((Date)month);
            balanceUtils.setContractAccount(contractId, localDate, servicePay, totalAccount);
            if (totalBonus.compareTo(BigDecimal.ZERO) < 0) {
                balanceUtils.setContractAccount(contractId, localDate, serviceBonus, totalBonus);
            }
            ServerUtils.commitConnection((Connection)this.con);
            balanceUtils.updateBalance(month, contractId);
        }
    }

    private BigDecimal[] getDealerComission(Dealer dealer, Date month) {
        int servicePay = this.moduleSetup.getInt("dealer.pay.sid", 0);
        int serviceBonus = this.moduleSetup.getInt("dealer.bonus.sid", 0);
        BigDecimal dealerAccount = BigDecimal.ZERO;
        BigDecimal dealerBonus = BigDecimal.ZERO;
        int comissionType = dealer.getPayComissionType();
        if (comissionType == 0 && dealer.getContractId() > 0) {
            dealerAccount = this.sumDealerPayments(month, dealer.getId());
        } else if (comissionType == 1 && servicePay > 0) {
            sum = this.sumDealerPayments(month, dealer.getId());
            dealerAccount = sum.multiply(BigDecimal.valueOf(1.0f - dealer.getPayPercent() / 100.0f));
        } else if (comissionType == 2 && servicePay > 0 && serviceBonus > 0) {
            dealerAccount = sum = this.sumDealerPayments(month, dealer.getId());
            dealerBonus = sum.negate().multiply(BigDecimal.valueOf(dealer.getPayPercent() / 100.0f));
        }
        BigDecimal[] result = new BigDecimal[]{dealerAccount, dealerBonus};
        return result;
    }

    private BigDecimal sumDealerPayments(Date month, int did) {
        BigDecimal result = BigDecimal.ZERO;
        String table = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)month, (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)table)) {
            String query = "SELECT SUM(summ) FROM " + table + " WHERE did=? AND status=1";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, did);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getBigDecimal(1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<DPaymentList> getDealerPaymentReport(String dealerids, Date date1, Date date2, Page page) {
        ArrayList<DPaymentList> result = new ArrayList<DPaymentList>();
        ArrayList<DPayment> allPayments = new ArrayList<DPayment>();
        if (this.getAllPayments(allPayments, dealerids, date1, date2, page)) {
            DPaymentList dealerPaymentList = null;
            int dealerId = 0;
            for (int i = 0; i < allPayments.size(); ++i) {
                DPayment curItem = (DPayment)allPayments.get(i);
                int newDealerId = curItem.getDealerId();
                if (newDealerId != dealerId) {
                    dealerId = newDealerId;
                    dealerPaymentList = new DPaymentList();
                    dealerPaymentList.setPaymentList(new ArrayList<DPayment>());
                    result.add(dealerPaymentList);
                    this.calculateCountAndSumma(dealerId, dealerPaymentList, date1, date2);
                }
                dealerPaymentList.getPaymentList().add(curItem);
            }
        }
        return result;
    }

    private void calculateCountAndSumma(int dealerid, DPaymentList list, Date date1, Date date2) {
        try {
            ResultSet rs;
            Calendar dateFrom = TimeUtils.convertDateToCalendar((Date)date1);
            Calendar dateTo = TimeUtils.convertDateToCalendar((Date)date2);
            String tableName = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)date1, (int)this.mid);
            String query = "SELECT COUNT(*) as amount, SUM(summ) as summa FROM " + tableName + " WHERE did=" + dealerid + " AND status=1";
            if (dateFrom != null && dateFrom.get(5) != dateFrom.getActualMinimum(5)) {
                query = query + " AND dt >= '" + TimeUtils.formatSQLDate((Calendar)dateFrom) + "' ";
            }
            if (dateTo != null && dateTo.get(5) != dateTo.getActualMaximum(5)) {
                query = query + " AND dt < '" + TimeUtils.formatSQLDate((Calendar)dateTo) + "' ";
            }
            if ((rs = this.con.prepareStatement(query).executeQuery()).next()) {
                list.setNumber(rs.getInt(1));
                list.setTotal(rs.getFloat(2));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean getAllPayments(List<DPayment> payments, String dealerids, Date date1, Date date2, Page page) {
        try {
            if (date1.after(date2)) {
                return false;
            }
            if (payments == null) {
                return false;
            }
            payments.clear();
            Calendar dateFrom = TimeUtils.convertDateToCalendar((Date)date1);
            Calendar dateTo = TimeUtils.convertDateToCalendar((Date)date2);
            String tableName = ServerUtils.getModuleMonthTableName((String)"card_dealer_pay", (Date)date1, (int)this.mid);
            if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                return false;
            }
            String dealerTable = "card_dealer_" + this.mid;
            String query = "SELECT contract.title, pay.dt, pay.did, pay.id, cpt.title, cpay.id, pay.summ, pay.trans FROM " + tableName + " as pay LEFT JOIN " + dealerTable + " as dealer ON dealer.id=pay.did LEFT JOIN contract_payment as cpay ON cpay.id=pay.pid LEFT JOIN contract_payment_types as cpt ON cpay.pt=cpt.id LEFT JOIN contract ON cpay.cid=contract.id WHERE pay.status=1";
            if (Utils.notBlankString((String)dealerids)) {
                query = query + " AND pay.did IN (" + dealerids + ") ";
            }
            if (dateFrom != null && dateFrom.get(5) != dateFrom.getActualMinimum(5)) {
                query = query + " AND pay.dt >= '" + TimeUtils.formatSQLDate((Calendar)dateFrom) + "' ";
            }
            if (dateTo != null && dateTo.get(5) != dateTo.getActualMaximum(5)) {
                query = query + " AND pay.dt < '" + TimeUtils.formatSQLDate((Calendar)dateTo) + "' ";
            }
            query = query + " ORDER BY dealer.title, pay.dt ";
            if (page.getPageSize() > 0) {
                query = query + page.sqlLimit();
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DPayment payment = this.getReportDPaymentFromRS(rs);
                payments.add(payment);
            }
            rs.close();
            ps.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private DPayment getReportDPaymentFromRS(ResultSet rs) throws SQLException {
        DPayment dp = new DPayment();
        dp.setContractTitle(rs.getString("contract.title"));
        dp.setDateTime(rs.getTimestamp("pay.dt"));
        dp.setDealerId(rs.getInt("pay.did"));
        dp.setId(rs.getInt("pay.id"));
        dp.setPaymentComment(rs.getString("cpt.title"));
        dp.setPaymentId(rs.getInt("cpay.id"));
        dp.setSumma(rs.getBigDecimal("pay.summ"));
        dp.setTransId(rs.getString("pay.trans"));
        return dp;
    }
}

