/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.email.server.bean.AccountAttribute;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class AccountAttributeManager {
    private ParameterMap params;
    private List<AccountAttribute> attributeList = new ArrayList<AccountAttribute>();
    private Map<Integer, AccountAttribute> attributeMap = new HashMap<Integer, AccountAttribute>();

    public AccountAttributeManager(ParameterMap params) {
        this.params = params;
        this.load();
    }

    private void load() {
        this.attributeList.clear();
        HashMap<Integer, AccountAttribute> tmpAttributeMap = new HashMap<Integer, AccountAttribute>();
        for (Map.Entry e : this.params.sub("ldap.attribute.").entrySet()) {
            int id;
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            String[] id_param = key.split("\\.");
            if (id_param.length != 2 || (id = Utils.parseInt((String)id_param[0], (int)0)) <= 0) continue;
            AccountAttribute attr = (AccountAttribute)((Object)tmpAttributeMap.get(id));
            if (attr == null) {
                attr = new AccountAttribute();
                attr.setId(id);
                tmpAttributeMap.put(id, attr);
            }
            if (id_param[1].equals("name")) {
                attr.setName(value);
                continue;
            }
            if (!id_param[1].equals("title")) continue;
            attr.setTitle(value);
        }
        for (AccountAttribute attr : tmpAttributeMap.values()) {
            if (!Utils.notBlankString((String)attr.getName()) || !Utils.notBlankString((String)attr.getTitle())) continue;
            this.attributeList.add(attr);
            this.attributeMap.put(attr.getId(), attr);
        }
    }

    public List<AccountAttribute> getAttributeList() {
        return this.attributeList;
    }

    public Map<Integer, AccountAttribute> getAttributeMap() {
        return this.attributeMap;
    }
}

