/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.TimeUtils;

public final class TariffRequest {
    private int _relevance = -1;
    private boolean _accepted = false;
    private int mtreeId;
    private final HashMap<String, Object> _requestParams = new HashMap();
    private final HashMap<String, Object> _responseParams = new HashMap();
    private final StringBuilder _history = new StringBuilder();
    private final StringBuilder _errors = new StringBuilder();

    public void setAccepted() {
        this._accepted = true;
    }

    public void setNoAccepted() {
        this._accepted = false;
    }

    public void clearResponse() {
        this._responseParams.clear();
    }

    public boolean wasAccepted() {
        return this._accepted;
    }

    public int getRelevance() {
        return this._relevance;
    }

    public void setRelevance(int relevance) {
        if (relevance > this._relevance) {
            this._relevance = relevance;
        }
    }

    public void setRequestParam(String name, Object value) {
        this._requestParams.put(name, value);
    }

    public Object getRequestParam(String name) {
        return this._requestParams.get(name);
    }

    public void dropRequestParam(String name) {
        this._requestParams.remove(name);
    }

    public void setResponseParam(String name, Object value) {
        this._responseParams.put(name, value);
    }

    public void dropResponseParam(String name) {
        this._responseParams.remove(name);
    }

    public Object getResponseParam(String name) {
        return this._responseParams.get(name);
    }

    public void addError(String message) {
        if (this._errors.length() != 0) {
            this._errors.append(" ;");
        }
        this._errors.append(message);
    }

    public String getErrors() {
        return this._errors.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("accepted => ");
        sb.append(String.valueOf(this._accepted));
        sb.append(" ");
        sb.append("relevance => ");
        sb.append(String.valueOf(this._relevance));
        sb.append(" ");
        sb.append("REQ: ");
        this.addHash(sb, this._requestParams);
        sb.append("RESP: ");
        this.addHash(sb, this._responseParams);
        sb.append("HIST: ");
        sb.append((CharSequence)this._history);
        return sb.toString();
    }

    public void addHistoryMsg(String msg) {
        this._history.append(msg);
    }

    public void clearHistory() {
        this._history.delete(0, this._history.length());
    }

    private void addHash(StringBuilder sb, Map<String, Object> hash) {
        for (String key : hash.keySet()) {
            sb.append(key);
            sb.append(" => ");
            Object value = hash.get(key);
            if (value instanceof Calendar) {
                sb.append(TimeUtils.format((Date)((Calendar)value).getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
            } else if (value != null) {
                sb.append(value.toString());
            } else {
                sb.append("NULL");
            }
            sb.append(" ");
        }
    }

    public int getMtreeId() {
        return this.mtreeId;
    }

    public void setMtreeId(int mtreeId) {
        this.mtreeId = mtreeId;
    }
}

