/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import java.util.Calendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.task.RSCMCalculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class RSCMRecalculator
extends RunTaskRecalculator<RSCMCalculator> {
    private String cids;

    public RSCMRecalculator(int moduleId, Calendar dt, String email, String contractIds) {
        super(moduleId, dt, email);
        this.cids = contractIds;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            RSCMCalculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041e\u0431\u0441\u0447\u0435\u0442 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailTaskRecalculator mailData = new MailTaskRecalculator();
                mailData.setModuleId(this.mid);
                mailData.setRecipients(this.email);
                mailData.setSubject("\u041e\u0431\u0441\u0447\u0435\u0442 RSCM \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d");
                mailData.addTextPart("text", report.toString());
                new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected RSCMCalculator createTask() {
        RSCMCalculator calculator = new RSCMCalculator();
        calculator.setCids(this.cids);
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid);
        return calculator;
    }
}

