/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostIntercomRuntime;

public class TableForpostIntercomAccounts
extends BGTableInfoBase {
    public TableForpostIntercomAccounts() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (String)"name").setWidth(-1), BGUTableColumn.buildColumnBoolean((String)"\u0410\u043a\u0442\u0438\u0432\u0435\u043d", (String)"active", (int)100), BGUTableColumn.buildColumnTextRight((String)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", (String)"userCount").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e \u043a\u0430\u043c\u0435\u0440", (String)"cameraCount").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u043e\u0432", (String)"deviceCount").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e \u0434\u043e\u043c\u043e\u0432", (String)"houseCount").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u043e\u0432", (String)"entranceCount").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e SIP-\u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432", (String)"sipCount").setWidth(150), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        ForpostIntercomRuntime forpostIntercomRuntime = ForpostIntercomRuntime.getInstance(moduleId);
        List accounts = ((ForpostIntercomService)this.getContext().getService(ForpostIntercomService.class, moduleId)).forpostIntercomAccountList();
        for (ForpostAccount forpostAccount : accounts) {
            int accountId = forpostAccount.getId();
            BGUTableRowData rowData = new BGUTableRowData().addValue(this.getId(accountId)).addValue("active", forpostAccount.getIsActive() == 1).addValue("userCount", this.getCountValue(forpostIntercomRuntime.getAccountUserCount(accountId, false))).addValue("cameraCount", this.getCountValue(forpostIntercomRuntime.getAccountCameraCount(accountId, false))).addValue("deviceCount", this.getCountValue(forpostIntercomRuntime.getAccountDeviceCount(accountId, false))).addValue("houseCount", this.getCountValue(forpostIntercomRuntime.getAccountHouseCount(accountId, false))).addValue("entranceCount", this.getCountValue(forpostIntercomRuntime.getAccountEntranceCount(accountId, false))).addValue("name", forpostAccount.getName());
            rowDatas.add(rowData);
        }
        return rowDatas;
    }

    private String getCountValue(int count) {
        if (count < -1) {
            return "\u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043c. \u043b\u043e\u0433";
        }
        if (count == -1) {
            return "?";
        }
        return String.valueOf(count);
    }
}

