/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import bitel.billing.server.radius.Antispam;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.apps.voice.access.om.AccessDeviceManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadLocalEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishDeviceEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishEvent;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusListener;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusProcessor;
import ru.bitel.bgbilling.modules.voice.server.runtime.RequestLogEventProcessor;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountTypeRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountTypeRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperatorRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceRadius;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceRuntimeTariffContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanOperation;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContextFactory;

public class VoiceApplication
extends BGLogger
implements CommandListener,
ThreadContextFactory<ServerContext>,
Lifecycle,
EventListener<Event> {
    protected final Setup setup;
    protected final int moduleId;
    protected final boolean runtime;
    private final VoiceDeviceRuntimeMap deviceRuntimeMap;
    private VoiceOperatorRuntimeMap operatorRuntimeMap;
    private ConvergenceBalanceManager convergenceBalanceManager;
    private VoiceOperAccountTypeRuntimeMap operAccountTypeRuntimeMap;
    protected VoiceAccountTypeRuntimeMap accountTypeRuntimeMap;
    protected VoiceAccountRuntimeMap voiceAccountRuntimeMap;
    protected VoiceOperAccountRuntimeMap voiceOperAccountRuntimeMap;
    protected ContractRuntimeMap contractRuntimeMap;
    protected VoiceRuntimeTariffContext runtimeTariffContext = null;
    protected final PoolEventPublisher<ContractBalanceChangedEvent> balanceEP = EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0, 500, 1000L);

    @ConstructorProperties(value={"setup"})
    public VoiceApplication(Setup setup) throws Exception {
        this(setup, true);
    }

    public VoiceApplication(Setup setup, boolean runtime) throws Exception {
        this.setup = setup;
        this.runtime = runtime;
        this.moduleId = SetupParam.getModuleId((ParameterMap)setup);
        if (this.moduleId <= 0) {
            throw new BGException("Not defined 'moduleId' in XML!");
        }
        this.deviceRuntimeMap = VoiceDeviceRuntimeMap.getInstance(setup, this.moduleId);
        EventProcessor.getInstance().addListener((EventListener)this, VoiceDevicesReloadEvent.class, this.moduleId, null);
        if (runtime) {
            this.convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
            EventProcessor.getInstance().addListener((EventListener)this, VoiceSessionFinishEvent.class, this.moduleId, null);
            EventProcessor.getInstance().addListener((EventListener)this, VoiceSessionFinishDeviceEvent.class, this.moduleId, null);
            new RequestLogEventProcessor((DefaultServerSetup)setup, this);
        }
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true);){
            this.deviceRuntimeMap.load(connectionSet.getConnection());
        }
        if (runtime) {
            new ScriptEventProcessor(setup).start();
            new CommonKernelEventProcessor(setup);
        }
    }

    @MBeanOperation
    public void start() throws Exception {
        Antispam.initAntispam((ParameterMap)this.setup);
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            this.accountTypeRuntimeMap = new VoiceAccountTypeRuntimeMap(true, connectionSet.getConnection(), this.moduleId);
            this.operAccountTypeRuntimeMap = new VoiceOperAccountTypeRuntimeMap(true, connectionSet.getConnection(), this.moduleId);
            this.voiceAccountRuntimeMap = VoiceAccountRuntimeMap.getInstance(connectionSet, this);
            this.voiceOperAccountRuntimeMap = VoiceOperAccountRuntimeMap.getInstance(connectionSet, this);
            this.contractRuntimeMap = new ContractRuntimeMap(new Date(), true, true);
            this.operatorRuntimeMap = VoiceOperatorRuntimeMap.getInstance(connectionSet.getConnection(), this.moduleId);
            this.runtimeTariffContext = new VoiceRuntimeTariffContext(new Date(), this.moduleId, connectionSet.getConnection());
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
        new AccessDeviceManager(this);
    }

    @MBeanOperation
    public void stop() throws Exception {
    }

    public ServerContext newThreadContext() {
        return null;
    }

    @MBeanOperation
    public String getCommandsHelp() {
        return "";
    }

    @MBeanOperation
    public String executeCommand(String cmd, String param) {
        if (cmd.equals("conpool")) {
            return this.setup.getPoolStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String host = "";
            int port = 1815;
            int byteBufferCapacity = 524288;
            int socketRcvBuf = 0;
            int moduleId = 217;
            RadiusListener.Mode mode = RadiusListener.Mode.authentication;
            Setup setup = new Setup("data", "data");
            setup.set("moduleId", String.valueOf(moduleId));
            VoiceRadius application = new VoiceRadius(setup);
            Antispam.initAntispam((ParameterMap)setup);
            VoiceRadiusProcessor processor = new VoiceRadiusProcessor(setup, application);
            int threadCount = 10;
            int maxQueueSize = 10;
            VoiceRadiusListener listner = new VoiceRadiusListener(host, port, byteBufferCapacity, socketRcvBuf, processor, mode, setup, null, threadCount, maxQueueSize);
            listner.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public VoiceAccountTypeRuntimeMap getAccountTypeRuntimeMap() {
        return this.accountTypeRuntimeMap;
    }

    public ContractRuntimeMap getContractRuntimeMap() {
        return this.contractRuntimeMap;
    }

    public VoiceAccountRuntimeMap getVoiceAccountRuntimeMap() {
        return this.voiceAccountRuntimeMap;
    }

    public ConvergenceBalanceManager getConvergenceBalanceManager() {
        return this.convergenceBalanceManager;
    }

    public VoiceRuntimeTariffContext getRuntimeTariffContext() {
        return this.runtimeTariffContext;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public void notify(Event e, EventListenerContext ctx) throws Exception {
        if (e instanceof VoiceDevicesReloadEvent) {
            this.reloadDevices();
        }
    }

    private void reloadDevices() throws Exception {
        ServerContext context = (ServerContext)ServerContext.get();
        this.deviceRuntimeMap.load(context.getConnection());
        EventProcessor.getInstance().request((QueueEvent)new VoiceDevicesReloadLocalEvent(this.moduleId, 0));
    }

    public VoiceDeviceRuntimeMap getDeviceRuntimeMap() {
        return this.deviceRuntimeMap;
    }

    public VoiceOperAccountRuntimeMap getVoiceOperAccountRuntimeMap() {
        return this.voiceOperAccountRuntimeMap;
    }

    public Set<Integer> getDeviceIds() {
        return this.deviceRuntimeMap.values().stream().map(d -> d.getDevice().getId()).collect(Collectors.toSet());
    }

    public VoiceOperatorRuntimeMap getOperatorRuntimeMap() {
        return this.operatorRuntimeMap;
    }

    public VoiceOperAccountTypeRuntimeMap getOperAccountTypeRuntimeMap() {
        return this.operAccountTypeRuntimeMap;
    }

    public PoolEventPublisher<ContractBalanceChangedEvent> getBalanceEP() {
        return this.balanceEP;
    }
}

