/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.client.contract.DefaultOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class DefaultOrdersPanel
extends BGUPanel {
    private List<DefaultOrder> orderList;
    private BGUComboBox<IdTitle> product = new BGUComboBox();
    private DefaultOrderTableModel defaultOrderTableModel = new DefaultOrderTableModel();

    public DefaultOrdersPanel(ClientContext context) {
        super(context);
        this.orderList = new ArrayList<DefaultOrder>();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, "order", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437", e -> new OrderEditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u0430", new DefaultOrder(((IdTitle)this.product.getSelectedItem()).getId()).setTerm(0)).open()).setIcon((Icon)ClientUtils.getIcon((String)"item_add"));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, "order", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437", e -> Optional.ofNullable((DefaultOrder)this.defaultOrderTableModel.getSelectedRow()).ifPresent(a -> new OrderEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u0430", (DefaultOrder)a).open())).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, "order", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437", e -> {
            DefaultOrder defaultOrder = (DefaultOrder)this.defaultOrderTableModel.getSelectedRow();
            if (defaultOrder != null) {
                this.deleteProductComponent(defaultOrder.getId());
                this.updateTableData();
            }
        }).setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
    }

    protected void jbInit() {
        BGDialogToolBar dialogToolBar = new BGDialogToolBar();
        BGUTable table = new BGUTable((TableModel)((Object)this.defaultOrderTableModel));
        table.setSelectionMode(0);
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)dialogToolBar, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        tablePanel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(BGSwingUtilites.wrapBorder(this.product, (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b"), "North");
        this.add(BGSwingUtilites.wrapBorder((JPanel)tablePanel, (String)"\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432"), "Center");
        BGSwingUtilites.buildToolBar((BGDialogToolBar)dialogToolBar, (JComponent)((Object)this), (String[])new String[]{"order.new", "order.edit", "order.delete"});
        dialogToolBar.setFloatable(false);
        dialogToolBar.compact();
        this.product.addActionListener(e -> this.updateTableData());
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.performAction("order.edit"));
    }

    public BGUComboBox<IdTitle> getProducts() {
        return this.product;
    }

    private void updateTableData() {
        int productId = ((IdTitle)this.product.getSelectedItem()).getId();
        this.defaultOrderTableModel.setData(this.orderList.stream().filter(a -> a.getProductId() == productId).toList());
    }

    private void deleteProductComponent(int id) {
        int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0);
        if (dialogResult == 0) {
            for (DefaultOrder comp : this.orderList) {
                if (comp.getId() != id) continue;
                this.orderList.remove(comp);
                break;
            }
        }
    }

    public List<DefaultOrder> getProductOrders(int productId) {
        return this.orderList.stream().filter(a -> a.getProductId() == productId).toList();
    }

    public void setProductOrders(List<DefaultOrder> productOrders) {
        this.orderList = productOrders;
        this.updateTableData();
    }

    class DefaultOrderTableModel
    extends BGTableModel<DefaultOrder> {
        public DefaultOrderTableModel() {
            super(DefaultOrderTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f", 120, 150, 150, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 150, 150, 150, "count", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumnId();
        }

        public Object getValue(DefaultOrder val, int column) throws Exception {
            String iden = this.getIdentifier(column);
            if ("type".equals(iden)) {
                return val.getTypeStr();
            }
            if ("count".equals(iden)) {
                return val.getCountStr();
            }
            return super.getValue((Object)val, column);
        }
    }

    class OrderEditorDialog
    extends BGEditorDialog<DefaultOrder> {
        private BGUComboBox<IdTitle> type;
        private BGUComboBox<IdTitle> component;
        private BGTextField term;
        private BGTextField count;
        private JCheckBox unlimited;
        private BGCalendarButton dateTo;

        public OrderEditorDialog(String title, DefaultOrder data) {
            super(title, (Object)data);
            this.type = new BGUComboBox();
            this.component = new BGUComboBox();
            this.term = new BGTextField();
            this.count = new BGTextField();
            this.unlimited = new JCheckBox("\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e");
            this.dateTo = new BGCalendarButton();
        }

        public void doDialogPanel() {
            this.addFieldV("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442:", (JComponent)this.component);
            this.addFieldV("\u0422\u0438\u043f:", (JComponent)this.type);
            this.addFieldV("\u0421\u0440\u043e\u043a:", this.getTermPanel());
            this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:", this.getCountPanel());
            this.type.setData(Arrays.asList(LicenseOrderType.values()).stream().filter(a -> a != LicenseOrderType.UNKNOWN).map(a -> new IdTitle(a.getCode(), a.getText())).toList());
            this.updateComponents(((DefaultOrder)this.data).getProductId());
            this.component.setSelectedItem((Object)new Id().setId(((DefaultOrder)this.data).getComponentId()));
            if (((DefaultOrder)this.data).getTerm() == 0) {
                this.type.setSelectedIndex(LicenseOrderType.BUY.getCode());
                this.term.setText("");
                this.term.setEditable(false);
                this.dateTo.setLocalDate(null);
                this.dateTo.setEnabled(false);
            } else {
                this.type.setSelectedIndex(LicenseOrderType.TEST.getCode());
                this.term.setText(String.valueOf(((DefaultOrder)this.data).getTerm()));
            }
            if (((DefaultOrder)this.data).getCount() > 0) {
                this.count.setText(String.valueOf(((DefaultOrder)this.data).getCount()));
            } else {
                this.setUnlimited(true);
            }
            this.component.addActionListener(e -> this.componentChanged(((IdTitle)this.component.getSelectedItem()).getId()));
            this.type.addActionListener(e -> this.typeChanged());
        }

        public boolean doApply() throws Exception {
            int count = this.getCount();
            int term = this.getTerm();
            IdTitle componentId = (IdTitle)this.component.getSelectedItem();
            if (count == -1 || term == -1 || componentId == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445.");
                return false;
            }
            ((DefaultOrder)this.data).setComponentId(componentId.getId());
            ((DefaultOrder)this.data).setTitle(componentId.getTitle());
            ((DefaultOrder)this.data).setCount(count);
            ((DefaultOrder)this.data).setTerm(term);
            if (DefaultOrdersPanel.this.orderList.stream().filter(a -> a.getId() == ((DefaultOrder)this.data).getId()).findFirst().isEmpty()) {
                DefaultOrdersPanel.this.orderList.add((DefaultOrder)this.data);
            }
            DefaultOrdersPanel.this.updateTableData();
            return super.doApply();
        }

        private JPanel getCountPanel() {
            this.unlimited.addActionListener(e -> {
                JCheckBox source = (JCheckBox)e.getSource();
                this.setUnlimited(source.isSelected());
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.count, "Center");
            panel.add((Component)this.unlimited, "East");
            return panel;
        }

        private JPanel getTermPanel() {
            this.term.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                    OrderEditorDialog.this.dateTo.setText("");
                }
            });
            this.dateTo.addPropertyChangeListener(e -> {
                String propertyName = e.getPropertyName();
                if ("text".equals(propertyName) && !"".equals(e.getNewValue())) {
                    Calendar cal = ((BGCalendarButton)e.getSource()).getCalendar();
                    this.term.setText(String.valueOf(this.getDifferenceInDays(new Date(), cal.getTime())));
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.term, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0434\u043d\u0435\u0439"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.dateTo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
            return panel;
        }

        private void typeChanged() {
            int id = ((IdTitle)this.type.getSelectedItem()).getId();
            if (id == 0) {
                this.term.setText("");
                this.term.setEditable(true);
                this.dateTo.setEnabled(true);
            } else {
                this.term.setText("-");
                this.term.setEditable(false);
                this.dateTo.setEnabled(false);
            }
        }

        public void updateComponents(int productId) {
            try {
                this.component.setData(((LicenseService)((ClientContext)DefaultOrdersPanel.this.getContext()).getWebService(LicenseService.class)).productLicenseComponents(productId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public int getCount() {
            return this.unlimited.isSelected() ? 0 : Utils.parseInt((String)this.count.getText(), (int)-1);
        }

        public int getTerm() {
            return ((IdTitle)this.type.getSelectedItem()).getId() == LicenseOrderType.BUY.getCode() ? 0 : Utils.parseInt((String)this.term.getText(), (int)-1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void componentChanged(int id) {
            if (id <= 0) return;
            try {
                LicenseComponent productItem = ((LicenseService)((ClientContext)DefaultOrdersPanel.this.getContext()).getWebService(LicenseService.class, ((ClientContext)DefaultOrdersPanel.this.getContext()).getModuleId())).productComponentGet(id);
                if (productItem == null) return;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        private int getDifferenceInDays(Date startDate, Date endDate) {
            long start = startDate.getTime();
            long end = endDate.getTime();
            float diff = (float)(end - start) / 8.64E7f;
            int diffDays = (int)diff + 1;
            if (diff > 0.0f) {
                ++diffDays;
            }
            return diffDays;
        }

        private void setUnlimited(boolean value) {
            if (value) {
                this.unlimited.setSelected(true);
                this.count.setText("-");
                this.count.setEnabled(false);
            } else {
                this.unlimited.setSelected(false);
                this.count.setText("");
                this.count.setEnabled(true);
            }
        }
    }
}

