/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

public class RunTelContractTariffDao
extends AbstractIdDao<RunTelContractTariff> {
    public RunTelContractTariffDao(Connection con, int moduleId) {
        super(con, "runtel_tariff_contract", moduleId);
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(LocalDateTime date) throws SQLException {
        Timestamp timestamp = Timestamp.valueOf(date);
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{timestamp, timestamp});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(Period period) throws SQLException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)period.getDateFrom());
        if (period.getDateTo() == null) {
            return this.list("( `date_to` IS NULL OR `date_to` >= ? )", "id", new Object[]{sqlDateFrom});
        }
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)period.getDateTo());
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{sqlDateTo, sqlDateFrom});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(int contractId, PeriodWithTime period) throws SQLException {
        if (period == null) {
            period = new PeriodWithTime();
        }
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)period.getDateFrom());
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)period.getDateTo());
        if (period.getDateFrom() == null && period.getDateTo() == null) {
            return this.list("contract_id=?", "date_from", new Object[]{contractId});
        }
        if (period.getDateTo() == null) {
            return this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= ? )", "date_from", new Object[]{contractId, sqlDateFrom});
        }
        if (period.getDateFrom() == null) {
            return this.list("contract_id=? AND ( `date_from` IS NULL OR `date_from` <= ? )", "date_from", new Object[]{contractId, sqlDateTo});
        }
        return this.list("contract_id=? AND ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "date_from", new Object[]{contractId, sqlDateTo, sqlDateFrom});
    }

    public LocalDateTime getOnDate(int contractId) throws SQLException {
        LocalDateTime dateTime = null;
        List contractTariffs = this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= CURDATE() )", "date_from", new Object[]{contractId});
        if (!contractTariffs.isEmpty()) {
            dateTime = ((RunTelContractTariff)contractTariffs.get(0)).getPeriod().getLocalDateTimeFrom();
        } else {
            contractTariffs = this.list("contract_id=?", "date_from", new Object[]{contractId});
            if (!contractTariffs.isEmpty()) {
                dateTime = ((RunTelContractTariff)contractTariffs.get(contractTariffs.size() - 1)).getPeriod().getLocalDateTimeFrom();
            }
        }
        return dateTime;
    }

    public RunTelContractTariff get(int contractId, LocalDate date) throws SQLException {
        java.sql.Date sqlDate = java.sql.Date.valueOf(date);
        List list = this.list("contract_id=? AND  ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{contractId, sqlDate, sqlDate});
        return list.isEmpty() ? null : (RunTelContractTariff)list.get(0);
    }

    protected int deleteImpl(int id) throws SQLException {
        return super.delete("id=? AND date_from > CURDATE()", new Object[]{id});
    }

    protected RunTelContractTariff getFromRS(ResultSet rs) throws SQLException {
        RunTelContractTariff runTelContractTariff = new RunTelContractTariff();
        runTelContractTariff.setId(rs.getInt("id"));
        runTelContractTariff.setContractId(rs.getInt("contract_id"));
        runTelContractTariff.setTariffId(rs.getInt("tariff_id"));
        runTelContractTariff.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        runTelContractTariff.setConfig(rs.getString("config"));
        return runTelContractTariff;
    }

    protected void updateImpl(RunTelContractTariff runTelContractTariff) throws SQLException {
        boolean update = runTelContractTariff.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET contract_id=?, tariff_id=?, date_from=?, date_to=?, config=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, runTelContractTariff.getContractId());
            ps.setInt(index++, runTelContractTariff.getTariffId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)runTelContractTariff.getPeriod().getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)runTelContractTariff.getPeriod().getDateTo()));
            ps.setString(index++, runTelContractTariff.getConfig());
            this.executeUpdate((Id)runTelContractTariff, index, ps);
        }
    }

    public void updateDateTo(int contractTariffId, LocalDateTime dateTo) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET date_to=?  WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)dateTo));
            ps.setInt(index++, contractTariffId);
            ps.executeUpdate();
        }
    }

    public Map<Integer, RunTelContractTariff> getLastRunTelContractTariffs() throws SQLException {
        RunTelContractTariff tariff;
        ResultSet rs;
        int index;
        LocalDate now = LocalDate.now();
        HashMap<Integer, RunTelContractTariff> tariffMap = new HashMap<Integer, RunTelContractTariff>();
        String query = "SELECT * FROM " + this.tableName + " INNER JOIN (SELECT contract_id, max(date_to) as date_to FROM " + this.tableName + " WHERE date_to is not null AND date_from < ? GROUP BY contract_id ) latest USING ( contract_id, date_to )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setTimestamp(index, TimeUtils.convertLocalDateToTimestamp((LocalDate)now));
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    tariff = this.getFromRS(rs);
                    tariffMap.put(tariff.getContractId(), tariff);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT * FROM " + this.tableName + " WHERE date_to is null AND date_from < ?";
        ps = this.con.prepareStatement(query);
        try {
            index = 1;
            ps.setTimestamp(index, TimeUtils.convertLocalDateToTimestamp((LocalDate)now));
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    tariff = this.getFromRS(rs);
                    tariffMap.put(tariff.getContractId(), tariff);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return tariffMap;
    }
}

