/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostCameraDao
extends AbstractDao<ForpostCamera> {
    private final String TABLE_FORPOST_ACCOUNT;
    private final String TABLE_FORPOST_ACCOUNT_CONTRACT;

    public ForpostCameraDao(Connection con, int moduleId) {
        super(con, "smarthouse_forpost_camera", moduleId);
        this.TABLE_FORPOST_ACCOUNT = "smarthouse_forpost_account_" + moduleId;
        this.TABLE_FORPOST_ACCOUNT_CONTRACT = "smarthouse_forpost_account_contract_" + moduleId;
    }

    public List<ForpostCamera> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<Integer> getIds() throws BGException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String sql = "SELECT id FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return ids;
    }

    public List<Integer> getAccountIds() throws BGException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String sql = "SELECT DISTINCT account_id FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return ids;
    }

    protected ForpostCamera getFromRS(ResultSet rs) throws SQLException, BGException {
        return ForpostCamera.builder().setId(rs.getInt("id")).setName(rs.getString("name")).setAccountId(rs.getInt("account_id")).setAccountObjectId(rs.getInt("account_object_id")).setMasterId(rs.getInt("master_id")).setLogin(rs.getString("login")).setIpOrDomain(rs.getString("ip_or_domain")).setPort(rs.getInt("port")).setIsActive(rs.getInt("is_active")).setData(rs.getString("data")).build();
    }

    protected void updateImpl(ForpostCamera forpostCamera) throws BGException {
        if (forpostCamera != null) {
            String sqlField = "name=?, account_id=?, account_object_id=?, master_id=?, login=?, ip_or_domain=?, port=?, is_active=?, data=?";
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);){
                int parameterIndex = 1;
                ps.setInt(parameterIndex++, forpostCamera.getId());
                ps.setString(parameterIndex++, forpostCamera.getName());
                ps.setInt(parameterIndex++, forpostCamera.getAccountId());
                ps.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                ps.setInt(parameterIndex++, forpostCamera.getMasterId());
                ps.setString(parameterIndex++, forpostCamera.getLogin());
                ps.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                ps.setInt(parameterIndex++, forpostCamera.getPort());
                ps.setInt(parameterIndex++, forpostCamera.getIsActive());
                ps.setString(parameterIndex++, forpostCamera.getData());
                ps.setString(parameterIndex++, forpostCamera.getName());
                ps.setInt(parameterIndex++, forpostCamera.getAccountId());
                ps.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                ps.setInt(parameterIndex++, forpostCamera.getMasterId());
                ps.setString(parameterIndex++, forpostCamera.getLogin());
                ps.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                ps.setInt(parameterIndex++, forpostCamera.getPort());
                ps.setInt(parameterIndex++, forpostCamera.getIsActive());
                ps.setString(parameterIndex++, forpostCamera.getData());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostCamera(int id) throws BGException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostCameras(SearchResult<ForpostTMCAO<ForpostCamera>> searchResult, KeyValue filter) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder();
        query.append("SELECT SQL_CALC_FOUND_ROWS cam.*, a.name AS accountName, c.id AS contractId, c.title AS contractTitle FROM " + this.tableName + " AS cam ");
        query.append("LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT + " AS a ON a.id=cam.account_id ");
        query.append("LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT_CONTRACT + " AS ac ON ac.account_id=cam.account_id ");
        query.append("LEFT JOIN contract AS c ON c.id=ac.contract_id ");
        if (filter != null && Utils.notBlankString((String)filter.getValue())) {
            switch (filter.getKey()) {
                case "id": {
                    query.append("WHERE cam.id=? ");
                    break;
                }
                case "name": {
                    query.append("WHERE cam.name like ? ");
                    break;
                }
                case "host": {
                    query.append("WHERE cam.ip_or_domain like ? ");
                    break;
                }
            }
        }
        query.append(this.sqlLimit(page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            if (filter != null && Utils.notBlankString((String)filter.getValue())) {
                switch (filter.getKey()) {
                    case "id": {
                        ps.setInt(1, Utils.parseInt((String)filter.getValue().trim()));
                        break;
                    }
                    case "name": {
                        ps.setString(1, "%" + filter.getValue().trim() + "%");
                        break;
                    }
                    case "host": {
                        ps.setString(1, "%" + filter.getValue().trim() + "%");
                        break;
                    }
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ForpostTMCAO tableModelRow = new ForpostTMCAO();
                    tableModelRow.setContractId(rs.getInt("contractId"));
                    tableModelRow.setContractTitle(rs.getString("contractTitle"));
                    tableModelRow.setAccountName(rs.getString("accountName"));
                    tableModelRow.setObject((Object)this.getFromRS(rs));
                    list.add(tableModelRow);
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void searchForpostAccountCameras(SearchResult<ForpostCamera> searchResult, int accountId) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String query = "SELECT * FROM " + this.tableName + (accountId > 0 ? " WHERE account_id=? " : "") + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (accountId > 0) {
                ps.setInt(1, accountId);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void doSync(ForpostCamera[] cameras) throws BGException {
        if (cameras == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "name=?, account_id=?, account_object_id=?, master_id=?, login=?, ip_or_domain=?, port=?, is_active=?, data=?, sync_datetime=?";
        String inserQuery = "INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField;
        String deleteQuery = "DELETE FROM " + this.tableName + " WHERE sync_datetime<>? AND account_id=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(inserQuery);
             PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);){
            int accountId = 0;
            for (ForpostCamera forpostCamera : cameras) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostCamera.getId());
                psInsert.setString(parameterIndex++, forpostCamera.getName());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountId());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                psInsert.setInt(parameterIndex++, forpostCamera.getMasterId());
                psInsert.setString(parameterIndex++, Optional.ofNullable(forpostCamera.getLogin()).orElse(""));
                psInsert.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                psInsert.setInt(parameterIndex++, forpostCamera.getPort());
                psInsert.setInt(parameterIndex++, forpostCamera.getIsActive());
                psInsert.setString(parameterIndex++, forpostCamera.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostCamera.getName());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountId());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                psInsert.setInt(parameterIndex++, forpostCamera.getMasterId());
                psInsert.setString(parameterIndex++, Optional.ofNullable(forpostCamera.getLogin()).orElse(""));
                psInsert.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                psInsert.setInt(parameterIndex++, forpostCamera.getPort());
                psInsert.setInt(parameterIndex++, forpostCamera.getIsActive());
                psInsert.setString(parameterIndex++, forpostCamera.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
                accountId = forpostCamera.getAccountId();
            }
            psDelete.setLong(1, now);
            psDelete.setInt(2, accountId);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostCamera getForpostCamera(int forpostCameraId) throws BGException {
        try {
            return (ForpostCamera)this.getById(forpostCameraId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, Integer> getForpostCameraModelStat() throws BGException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try (Statement st = this.con.createStatement();){
            HashMap<Integer, Integer> hashMap;
            block15: {
                ResultSet rs = st.executeQuery("SELECT data AS cameraModelId, count(*) FROM " + this.tableName + " GROUP BY cameraModelId");
                try {
                    while (rs.next()) {
                        int cameraModelId = this.parseCameraModelId(rs.getString(1));
                        if (cameraModelId <= 0) continue;
                        result.put(cameraModelId, rs.getInt(2));
                    }
                    hashMap = result;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private int parseCameraModelId(String data) {
        if (Utils.isBlankString((String)data)) {
            return -1;
        }
        int cameraModelId = -1;
        String[] arr = data.split("\n");
        for (int i = 0; i < arr.length; ++i) {
            int id;
            String line = arr[i];
            if (!line.startsWith("CameraModelID=") || (id = Utils.parseInt((String)line.substring("CameraModelID=".length()), (int)-1)) <= 0) continue;
            cameraModelId = id;
        }
        return cameraModelId;
    }
}

