/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.common.model.Id;

public class VoiceCostMapDao
extends AbstractIdDao<VoiceCostMap> {
    private static final String COST_MAP_TABLE_NAME = "voice_cost_map";

    public VoiceCostMapDao(Connection con, int moduleId) {
        super(con, COST_MAP_TABLE_NAME, moduleId);
    }

    protected VoiceCostMap getFromRS(ResultSet rs) throws SQLException {
        return VoiceCostMap.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setOperatorId(rs.getInt("operatorId")).build();
    }

    protected void updateImpl(VoiceCostMap voiceCostMap) throws SQLException {
        String querySet = "title=?, comment=?, operatorId=?";
        try (PreparedStatement ps = this.prepareStatement((Id)voiceCostMap, querySet);){
            int index = 1;
            ps.setString(index++, voiceCostMap.getTitle());
            ps.setString(index++, voiceCostMap.getComment());
            if (voiceCostMap.getOperatorId() > 0) {
                ps.setInt(index++, voiceCostMap.getOperatorId());
            } else {
                ps.setNull(index++, 4);
            }
            this.executeUpdate((Id)voiceCostMap, index, ps);
        }
    }

    public List<VoiceCostMap> list(int operatorId) throws SQLException {
        return super.list("operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL "), "id", new Object[0]);
    }
}

