/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff;

import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class PersonalTariffManager {
    private static final String TABLE_NAME = "contract_tree_link";
    private Connection con;

    public PersonalTariffManager(Connection con) {
        this.con = con;
    }

    public List<PersonalTariff> getPersonalTariffList(int contractId) throws Exception {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        String query = "SELECT * FROM contract_tree_link WHERE cid=? ORDER BY pos, date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRs(rs));
                }
            }
        }
        return result;
    }

    public List<PersonalTariff> getPersonalTariffList(int contractId, Date time) throws Exception {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        String query = "SELECT * FROM contract_tree_link WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY pos, date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)time));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)time));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRs(rs));
                }
            }
        }
        return result;
    }

    public List<PersonalTariff> getPersonalTariffList(int contractId, Date date1, Date date2) throws Exception {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        String query = "SELECT * FROM contract_tree_link WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY pos, date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date1));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRs(rs));
                }
            }
        }
        return result;
    }

    public void updatePersonalTariff(PersonalTariff tariff) throws Exception {
        String query;
        boolean update = tariff.getId() > 0;
        String string = query = update ? "UPDATE contract_tree_link SET date1=?, date2=?, title=?, pos=?, title_web=?, config=? WHERE id=?" : "INSERT INTO contract_tree_link SET date1=?, date2=?, title=?, pos=?, title_web=?, config=?,cid=?, tree_id=?";
        if (!update) {
            tariff.setTreeId(new TariffTreeBuilder(this.con).createTree());
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)tariff.getDate1()));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)tariff.getDate2()));
            ps.setString(index++, tariff.getTitle());
            ps.setInt(index++, tariff.getPos());
            ps.setString(index++, tariff.isUseTitleInWeb() ? null : tariff.getTitleWeb());
            ps.setString(index++, tariff.getConfig());
            if (update) {
                ps.setInt(index++, tariff.getId());
            } else {
                ps.setInt(index++, tariff.getContractId());
                ps.setInt(index++, tariff.getTreeId());
            }
            ps.executeUpdate();
            if (!update) {
                tariff.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public void deletePersonalTariff(int id) throws Exception {
        String query = "DELETE FROM contract_tree_link WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public PersonalTariff getPersonalTariff(int id) throws Exception {
        PersonalTariff result = null;
        String query = "SELECT * FROM contract_tree_link WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRs(rs);
                }
            }
        }
        return result;
    }

    private PersonalTariff getFromRs(ResultSet rs) throws SQLException {
        PersonalTariff result = new PersonalTariff();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        result.setTreeId(rs.getInt("tree_id"));
        result.setPos(rs.getInt("pos"));
        String titleWeb = rs.getString("title_web");
        result.setUseTitleInWeb(titleWeb == null);
        result.setTitleWeb(titleWeb == null ? result.getTitle() : titleWeb);
        result.setConfig(rs.getString("config"));
        return result;
    }

    public Set<Integer> getParentTreeTariffIds(int contractId, Date date) throws Exception {
        HashSet<Integer> result = new HashSet<Integer>();
        String query = "SELECT tariff_plan.id FROM contract_tree_link LEFT JOIN module_tariff_tree ON module_tariff_tree.tree_id=contract_tree_link.tree_id LEFT JOIN tariff_plan ON tariff_plan.tree_id=module_tariff_tree.parent_tree WHERE contract_tree_link.cid=? AND tariff_plan.id IS NOT NULL AND (? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )))";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
            ps.setInt(1, contractId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }
}

