/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.server.table;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.bgbilling.modules.aots.server.bean.AOTSContractServiceDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class TableContractService
extends BGTableInfoBase {
    public TableContractService() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnDate((String)"\u0414\u0430\u0442\u0430", (String)"date"), BGUTableColumn.buildColumnTextLeft((String)"\u0423\u0441\u043b\u0443\u0433\u0430", (String)"serviceTitle").setWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (String)"comment").setWidth(-1), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c (\u0435\u0434.)", (String)"cost").setMaxWidth(120), BGUTableColumn.buildColumnTextRight((String)"\u041a\u043e\u043b-\u0432\u043e", (String)"amount").setMaxWidth(100), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0443\u043c\u043c\u0430 \u041d\u0414\u0421", (String)"ndsSum").setMaxWidth(130), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0443\u043c\u043c\u0430 (c \u041d\u0414\u0421)", (String)"sum").setMaxWidth(120)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        DecimalFormat decimalFormat = Utils.getDecimalFormatSumma();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        SearchResult searchResult = new SearchResult(tableParams.getPeriod(), tableParams.getPage());
        new AOTSContractServiceDao(serverContext.getConnection(), moduleId).searchAOTSContractService((SearchResult<AOTSContractService>)searchResult, tableParams.getContractId());
        this.page = searchResult.getPage();
        this.getAttributes().clear();
        this.addAttribute("totalSum", decimalFormat.format(searchResult.getSum()));
        List services = ModuleCache.getInstance().getModuleServicesList(moduleId);
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue("id", a.getId()).addValue("contractId", String.valueOf(a.getContractId())).addValue("serviceTitle", services.stream().filter(s -> s.getId() == a.getServiceId()).findFirst().map(s -> s.getTitle()).orElse("??? [ID#" + a.getServiceId() + "]")).addValue("comment", a.getComment()).addValue("date", a.getServiceTime().format(dateTimeFormatter)).addValue("cost", decimalFormat.format(a.getCost())).addValue("ndsSum", this.getNdsSum((AOTSContractService)a, decimalFormat)).addValue("sum", decimalFormat.format(a.getServiceSum())).addValue("amount", decimalFormat.format(a.getAmount()))).toList();
    }

    private String getNdsSum(AOTSContractService aotsContractService, DecimalFormat decimalFormat) {
        if (aotsContractService.getNdsRate() == null) {
            return "\u0431\u0435\u0437 \u041d\u0414\u0421";
        }
        return decimalFormat.format(aotsContractService.getCost().multiply(aotsContractService.getAmount()).multiply(aotsContractService.getNdsRate()).divide(new BigDecimal(100))) + "[" + aotsContractService.getNdsRate().setScale(0).toString() + "%]";
    }
}

