/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseOption;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountTypeDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseOptionDao;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService")
public class SmartHouseServiceImpl
extends AbstractService
implements SmartHouseService {
    private SmartHouseOptionDao smartHouseOptionDao;
    private SmartHouseAccountDao smartHouseAccountDao;
    private SmartHouseAccountTypeDao smartHouseAccountTypeDao;

    @PostConstruct
    private void init() {
        this.smartHouseOptionDao = new SmartHouseOptionDao(this.getConnection(), this.moduleId);
        this.smartHouseAccountDao = new SmartHouseAccountDao(this.getConnection(), this.moduleId);
        this.smartHouseAccountTypeDao = new SmartHouseAccountTypeDao(this.getConnection(), this.moduleId);
    }

    public List<SmartHouseAccountType> smarthouseAccountTypes() throws Exception {
        return this.smartHouseAccountTypeDao.list();
    }

    public SmartHouseAccountType smarthouseAccountTypeGet(int id) throws Exception {
        return id == 0 ? new SmartHouseAccountType() : (SmartHouseAccountType)this.smartHouseAccountTypeDao.get(id);
    }

    public int smarthouseAccountTypeUpdate(SmartHouseAccountType accountType) throws Exception {
        this.smartHouseAccountTypeDao.update(accountType);
        return accountType.getId();
    }

    public SmartHouseOption smarthouseOptionGet(int id) throws Exception {
        if (id == 0) {
            return new SmartHouseOption();
        }
        return (SmartHouseOption)this.smartHouseOptionDao.get(id);
    }

    public int smarthouseOptionUpdate(SmartHouseOption option) throws Exception {
        this.smartHouseOptionDao.update(option);
        return option.getId();
    }

    public List<IdTitle> smarthouseServices() throws Exception {
        return ModuleCache.getInstance().getModuleServicesList(this.moduleId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public List<IdTitle> npayModules() throws Exception {
        return ModuleCache.getInstance().getModulesList("npay").stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public List<IdTitle> npayServices(int moduleId) throws Exception {
        return ModuleCache.getInstance().getModuleServicesList(moduleId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public SearchResult<SmartHouseAccount> smarthouseAccountSearch(int contractId, int contractObjectId) throws Exception {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(this.smartHouseAccountDao.list(contractId, contractObjectId));
        return searchResult;
    }

    public SmartHouseAccount smarthouseAccountGet(int id) throws Exception {
        return (SmartHouseAccount)this.smartHouseAccountDao.get(id);
    }

    public int smarthouseAccountUpdate(SmartHouseAccount smartHouseAccount) throws Exception {
        this.smartHouseAccountDao.update(smartHouseAccount);
        return smartHouseAccount.getId();
    }

    public boolean smarthouseAccountDelete(int id) throws Exception {
        return this.smartHouseAccountDao.delete(id) > 0;
    }
}

