/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;

class GeoNode<I> {
    protected VoiceGeographicCode code;
    private Map<Integer, GeoNode<I>> childs = new HashMap<Integer, GeoNode<I>>(10, 1.0f);
    protected I item;

    GeoNode() {
    }

    public void addItem(I item, VoiceGeographicCode code) {
        GeoNode<I> node = this.addCode(code, code.getCode());
        if (node != null) {
            node.item = item;
        }
    }

    public I getItem() {
        return this.item;
    }

    public void addCode(VoiceGeographicCode code) {
        this.addCode(code, code.getCode());
    }

    protected GeoNode<I> addCode(VoiceGeographicCode code, String codeStr) {
        int digit = Integer.valueOf(codeStr.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child == null) {
            child = new GeoNode<I>();
            this.childs.put(digit, child);
        }
        if (codeStr.length() > 1) {
            String suffix = codeStr.substring(1, codeStr.length());
            return child.addCode(code, suffix);
        }
        child.code = code;
        return child;
    }

    public VoiceGeographicCode findCode(String number) {
        return this.findCode(number, null);
    }

    public GeoNode<I> findNode(String number) {
        return this.findNode(number, null);
    }

    protected VoiceGeographicCode findCode(String number, VoiceGeographicCode code) {
        VoiceGeographicCode resultCode = code;
        if (this.code != null) {
            resultCode = this.code;
        }
        if (number.length() == 0) {
            return resultCode;
        }
        int digit = Integer.valueOf(number.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child != null && number.length() > 0) {
            String suffix = number.substring(1, number.length());
            return child.findCode(suffix, resultCode);
        }
        return resultCode;
    }

    protected GeoNode<I> findNode(String number, GeoNode<I> node) {
        GeoNode resultNode = node;
        if (this.code != null) {
            resultNode = this;
        }
        if (number.length() == 0) {
            return resultNode;
        }
        int digit = Integer.valueOf(number.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child != null && number.length() > 0) {
            String suffix = number.substring(1, number.length());
            return child.findNode(suffix, resultNode);
        }
        return resultNode;
    }
}

