/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.util.List;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.client.table.BGTableModel;

public class RequestRecordLogTable
extends BGUTable {
    public RequestRecordLogTable(ClientContext clientContext) {
        super(new RequestRecordLogTableModel(clientContext));
        this.setSelectionMode(0);
    }

    public RequestRecordLog getSelectedRequest() {
        return (RequestRecordLog)((RequestRecordLogTableModel)this.getModel()).getSelectedRow();
    }

    public void setData(List<RequestRecordLog> data) {
        ((RequestRecordLogTableModel)this.getModel()).setData(data);
    }

    private static final class RequestRecordLogTableModel
    extends BGTableModel<RequestRecordLog> {
        private Directory<UserInfo> userDirectory;
        private final ClientContext clientContext;

        public RequestRecordLogTableModel(ClientContext clientContext) {
            super(RequestRecordLogTableModel.class.getName());
            this.clientContext = clientContext;
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 250, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", 180, 190, -1, "userId", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e \u0437\u0430\u043f\u0438\u0441\u0438", 180, 190, 200, "startRecordingTime", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438", 180, 190, 200, "endRecordingTime", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439", 180, 190, 200, "allActionsCount", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValueAt(RequestRecordLog val, int column) throws Exception {
            if (column == 2) {
                UserInfo user = this.getUserDirectory().get(val.getUserId());
                return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
            }
            return super.getValueAt(val, column);
        }

        private Directory<UserInfo> getUserDirectory() {
            if (this.userDirectory == null) {
                try {
                    this.userDirectory = this.clientContext.getDirectory(UserInfo.class, 0);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            return this.userDirectory;
        }
    }
}

