/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.config.common.service.DialogConfigService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUComboBox;

public class ForpostEditorDialog<T> {
    protected T bean;
    protected JPanel parentPanel;
    protected JSONObject data = null;
    protected List<Component> components = null;
    protected ClientContext clientContext;
    protected JPanel panel = new JPanel(new GridBagLayout());
    protected JPopupMenu valueSetPopup = null;

    public ForpostEditorDialog(T bean, String dataName, ClientContext clientContext, JPanel parentPanel) {
        this.bean = bean;
        this.parentPanel = parentPanel;
        this.clientContext = clientContext;
        try {
            this.data = new JSONObject(((DialogConfigService)new ClientContext("kernel", 0, 0, null).getPort(DialogConfigService.class)).dialogConfigGet(clientContext.getModuleId(), dataName, false));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        if (this.data == null || !this.data.has("fields")) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 /conf/editor/smarthouse");
        }
    }

    public T getBean() {
        return this.bean;
    }

    public JDialog getDialog() {
        this.doDialogPanel();
        BGOptionPane optionPane = new BGOptionPane((Object)this.panel, String.valueOf(this.data.optQuery("/dialog/title")));
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                if (this.doApply()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
            }
        });
        return dialog;
    }

    public void doDialogPanel() {
        JSONArray fields = this.data.optJSONArray("fields");
        if (fields != null) {
            int gridy = 0;
            this.components = new ArrayList<Component>();
            for (int index = 0; index < fields.length(); ++index) {
                JSONObject field = fields.getJSONObject(index);
                this.panel.add((Component)new JLabel(field.optString("title", "fieldTitle#" + index) + ":"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
                JComponent component = null;
                int fill = 2;
                int columns = field.optInt("columns");
                if (columns > 0) {
                    fill = 0;
                }
                String beanName = field.optString("beanName");
                String putName = field.optString("putName");
                String type = field.optString("type", "text");
                String defaultValue = field.optString("defaultValue", "");
                JButton valueSetButton = null;
                switch (type) {
                    case "text": 
                    case "int": {
                        JTextField textField = new JTextField(columns > 0 ? columns : 10);
                        textField.setText(this.getBeanValue(beanName, putName, type, defaultValue));
                        String valueSet = field.optString("valueSet", null);
                        if (valueSet != null) {
                            valueSetButton = this.getValuesButton(textField, valueSet);
                        }
                        component = textField;
                        break;
                    }
                    case "boolean": {
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(Utils.parseBoolean((String)this.getBeanValue(beanName, putName, type, defaultValue), (boolean)false));
                        component = checkBox;
                        break;
                    }
                    case "combobox": {
                        BGUComboBox comboBox = new BGUComboBox();
                        String serviceClassName = field.optString("service");
                        String methodName = field.optString("method");
                        if (!serviceClassName.isEmpty() && !methodName.isEmpty()) {
                            try {
                                Object object;
                                Object service = this.clientContext.getPort(Class.forName(serviceClassName));
                                Method[] methods = service.getClass().getMethods();
                                Method method = Arrays.asList(methods).stream().filter(a -> a.getName().equals(methodName)).findFirst().orElse(null);
                                int argsCount = method.getParameterCount();
                                Object[] args = null;
                                if (argsCount > 0) {
                                    JSONArray methodArgs = field.optJSONArray("methodArgs");
                                    args = new Object[argsCount];
                                    for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
                                        String methodArgName = methodArgs.optString(argIndex);
                                        args[argIndex] = methodArgName.isEmpty() ? null : this.bean.getClass().getMethod(methodArgName, new Class[0]).invoke(this.bean, new Object[0]);
                                    }
                                }
                                if ((object = method.invoke(service, args)) instanceof List) {
                                    List list = (List)object;
                                    String value = this.getBeanValue(beanName, putName, type, defaultValue);
                                    KeyValue selectedItem = null;
                                    ArrayList<KeyValue> items = new ArrayList<KeyValue>();
                                    String methodId = field.optString("methodId", "getId");
                                    String methodTitle = field.optString("methodTitle", "getName");
                                    for (Object listItem : list) {
                                        Method idMethod = listItem.getClass().getMethod(methodId, new Class[0]);
                                        Method nameMethod = listItem.getClass().getMethod(methodTitle, new Class[0]);
                                        KeyValue keyValue = new KeyValue(String.valueOf(idMethod.invoke(listItem, new Object[0])), String.valueOf(nameMethod.invoke(listItem, new Object[0])));
                                        items.add(keyValue);
                                        if (!keyValue.getKey().equals(value)) continue;
                                        selectedItem = keyValue;
                                    }
                                    comboBox.setData(items);
                                    comboBox.setSelectedItem(selectedItem);
                                }
                            }
                            catch (Exception e) {
                                ClientUtils.showErrorMessageDialog((Throwable)e);
                            }
                        }
                        component = comboBox;
                        break;
                    }
                }
                if (valueSetButton == null) {
                    this.panel.add((Component)component, new GridBagConstraints(-1, gridy, 1, 1, 0.0, 0.0, 17, fill, new Insets(5, 5, 0, 5), 0, 0));
                } else {
                    JPanel componentPanel = new JPanel(new GridBagLayout());
                    componentPanel.add((Component)component, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, fill, new Insets(0, 0, 0, 0), 0, 0));
                    componentPanel.add((Component)valueSetButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 5), 0, 0));
                    this.panel.add((Component)componentPanel, new GridBagConstraints(-1, gridy, 1, 1, 0.0, 0.0, 17, fill, new Insets(5, 5, 0, 5), 0, 0));
                }
                ++gridy;
                this.components.add(component);
            }
        }
    }

    public boolean doApply() throws Exception {
        JSONArray fields = this.data.optJSONArray("fields");
        if (fields != null) {
            block15: for (int index = 0; index < fields.length(); ++index) {
                String type;
                Component component = this.components.get(index);
                JSONObject field = fields.getJSONObject(index);
                String beanName = field.optString("beanName");
                String putName = field.optString("putName");
                switch (type = field.optString("type", "text")) {
                    case "text": 
                    case "int": {
                        Method method;
                        JTextField textField = (JTextField)component;
                        if (putName != null && putName.length() > 0) {
                            method = this.bean.getClass().getMethod("put", String.class, Object.class);
                            method.invoke(this.bean, putName, textField.getText());
                            continue block15;
                        }
                        if (beanName == null || beanName.trim().length() <= 0) continue block15;
                        try {
                            method = this.bean.getClass().getMethod("set" + beanName, Integer.TYPE);
                            method.invoke(this.bean, Utils.parseInt((String)textField.getText()));
                        }
                        catch (Exception e1) {
                            try {
                                Method method2 = this.bean.getClass().getMethod("set" + beanName, String.class);
                                method2.invoke(this.bean, textField.getText());
                            }
                            catch (Exception exception) {}
                        }
                        continue block15;
                    }
                    case "boolean": {
                        Method method;
                        boolean value = ((JCheckBox)component).isSelected();
                        if (Utils.notBlankString((String)putName)) {
                            method = this.bean.getClass().getMethod("put", String.class, Object.class);
                            method.invoke(this.bean, putName, value ? 1 : 0);
                            continue block15;
                        }
                        if (beanName == null || beanName.trim().length() <= 0) continue block15;
                        method = this.bean.getClass().getMethod("set" + beanName, Integer.TYPE);
                        method.invoke(this.bean, value ? 1 : 0);
                        continue block15;
                    }
                    case "combobox": {
                        Method method;
                        KeyValue keyValue = (KeyValue)((BGUComboBox)component).getSelectedItem();
                        if (keyValue == null) continue block15;
                        if (Utils.notBlankString((String)putName)) {
                            method = this.bean.getClass().getMethod("put", String.class, Object.class);
                            method.invoke(this.bean, putName, Utils.parseInt((String)keyValue.getKey()));
                            continue block15;
                        }
                        if (beanName == null || beanName.trim().length() <= 0) continue block15;
                        method = this.bean.getClass().getMethod("set" + beanName, Integer.TYPE);
                        method.invoke(this.bean, Utils.parseInt((String)keyValue.getKey()));
                        continue block15;
                    }
                }
            }
        }
        String serviceClassName = String.valueOf(this.data.optQuery("/dialog/service"));
        Object service = this.clientContext.getPort(Class.forName(serviceClassName));
        Object methodName = Optional.ofNullable(this.data.optQuery("/dialog/method")).orElse(this.data.optQuery("/dialog/addMethod"));
        Method method = service.getClass().getMethod(String.valueOf(methodName), Integer.TYPE, this.bean.getClass());
        method.invoke(service, this.clientContext.getContractId(), this.bean);
        String performAction = (String)this.data.optQuery("/dialog/performAction");
        if (performAction != null) {
            ((BGUPanel)this.parentPanel).performAction(performAction);
        }
        return true;
    }

    private JButton getValuesButton(JTextField textField, String valueSet) {
        JButton button = new JButton(ClientUtils.getIcon((String)"arrow_down"));
        button.setMargin(new Insets(0, 2, 0, 2));
        button.addActionListener(e -> {
            DefaultListModel<KeyValue> defaultListModel = new DefaultListModel<KeyValue>();
            JList list = new JList(defaultListModel);
            list.setSelectionMode(0);
            for (String listItem : valueSet.split(";")) {
                String[] itemData = listItem.split(":");
                if (itemData.length != 2) continue;
                defaultListModel.addElement(new KeyValue(itemData[0], itemData[1]));
            }
            list.addListSelectionListener(l -> {
                textField.setText(((KeyValue)list.getSelectedValue()).getKey());
                this.valueSetPopup.setVisible(false);
            });
            final JScrollPane scrollPane = new JScrollPane(list);
            this.valueSetPopup = new JPopupMenu(){
                {
                    this.add(scrollPane);
                }
            };
            this.valueSetPopup.show(textField, textField.getWidth(), button.getHeight());
        });
        return button;
    }

    private String getBeanValue(String beanName, String putName, String type, String defaultValue) {
        block30: {
            block29: {
                if (putName == null || putName.length() <= 0) break block29;
                block25: for (Method method : this.bean.getClass().getMethods()) {
                    switch (type) {
                        case "int": 
                        case "text": 
                        case "boolean": 
                        case "combobox": {
                            if (!method.getName().equals("getString") || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class)) continue block25;
                            try {
                                Object object = method.invoke(this.bean, putName);
                                return object != null ? String.valueOf(object) : defaultValue;
                            }
                            catch (Exception e) {
                                ClientUtils.showErrorMessageDialog((Throwable)e);
                                continue block25;
                            }
                        }
                    }
                }
                break block30;
            }
            if (beanName == null || beanName.trim().length() <= 0) break block30;
            block26: for (Method method : this.bean.getClass().getMethods()) {
                switch (type) {
                    case "int": 
                    case "text": 
                    case "combobox": {
                        if (!method.getName().equals("get" + beanName) || method.getParameterCount() != 0) continue block26;
                        try {
                            Object object;
                            if (method.getReturnType().equals(Integer.TYPE)) {
                                object = method.invoke(this.bean, new Object[0]);
                                return object != null && (Integer)object != 0 ? String.valueOf(object) : defaultValue;
                            }
                            object = method.invoke(this.bean, new Object[0]);
                            return object != null ? String.valueOf(object) : defaultValue;
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                            continue block26;
                        }
                    }
                    case "boolean": {
                        if (!method.getName().equals("is" + beanName) && !method.getName().equals("get" + beanName) || method.getParameterCount() != 0) continue block26;
                        try {
                            if (method.getReturnType().equals(Boolean.TYPE)) {
                                return String.valueOf(method.invoke(this.bean, new Object[0]));
                            }
                            if (!method.getReturnType().equals(Integer.TYPE)) continue block26;
                            return String.valueOf((Integer)method.invoke(this.bean, new Object[0]) != 0);
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                        }
                        continue block26;
                    }
                }
            }
        }
        return defaultValue;
    }
}

