/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.tariff.TariffModuleTree;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionPeriodDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionTypeDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionUtils;
import ru.bitel.bgbilling.modules.subscription.server.event.SubscriptionActivateEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.subscription.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, final BGModule module) throws Exception {
        super.start(con, module);
        JobScheduler.getInstance((String)"subscription", (int)module.getId());
        EventProcessor.getInstance().addListener((EventListener)new EventListener<PaymentEvent>(){

            public void notify(PaymentEvent event, EventListenerContext ctx) throws Exception {
                Module.this.contractSubscriptionActivate(module, event, ctx);
            }
        }, PaymentEvent.class);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractCreateEvent) {
            ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
            if (!contractCreateEvent.isCheck()) {
                SubscriptionService subscriptionService = (SubscriptionService)serverContext.getService(SubscriptionService.class, moduleId);
                XMLUtils.selectElements((Node)contractCreateEvent.getPattern().getData(), (String)("data/modules/subscription[@mid=" + moduleId + "]/addSubscription/item")).forEach(e -> {
                    Subscription subscription = Subscription.builder().setContractId(contractCreateEvent.getContractId()).setPeriod(new PeriodWithTime(new Date(), null)).setTypeId(Utils.parseInt((String)e.getAttribute("id"), (int)0)).setAvtoCommit(Boolean.valueOf(e.getAttribute("avto")).booleanValue()).setComment("\u0418\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430").build();
                    try {
                        subscriptionService.subscriptionUpdate(subscription);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                });
            }
        } else if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
            SubscriptionService subscriptionService = (SubscriptionService)serverContext.getService(SubscriptionService.class, moduleId);
            for (Subscription subscription : subscriptionService.subscriptionList(contractDeleteEvent.getContractId(), false)) {
                subscriptionService.subscriptionDelete(subscription.getId());
            }
        } else if (!(event instanceof ContractCloseEvent) && event instanceof ContractWrapEvent) {
            this.contractWrap(serverContext, moduleId, (ContractWrapEvent)event);
        }
    }

    private void contractWrap(ServerContext serverContext, int moduleId, ContractWrapEvent event) throws Exception {
        if (event.isCheck()) {
            SubscriptionDao subscriptionDao = new SubscriptionDao(serverContext.getConnection(), moduleId, event.getUserId());
            SubscriptionPeriodDao subscriptionPeriodDao = new SubscriptionPeriodDao(serverContext.getConnection(), moduleId, event.getUserId());
            LocalDateTime dateClose = TimeUtils.convertDateToLocalDateTime((Date)event.getDateClose());
            dateClose = dateClose.plusDays(1L).minusSeconds(1L);
            for (Subscription subscription : subscriptionDao.list(event.getContractId())) {
                RegistrationPeriod registrationPeriod;
                if (!TimeUtils.dateInPeriod((LocalDateTime)dateClose, (PeriodWithTime)subscription.getPeriod()) || !TimeUtils.dateInPeriod((LocalDateTime)dateClose, (PeriodWithTime)(registrationPeriod = (RegistrationPeriod)subscriptionPeriodDao.get(subscription.getRegistrationPeriodId())).getPeriod())) continue;
                event.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 - " + subscription.getSubscriptionType().getGuiTitle());
                return;
            }
        } else {
            SubscriptionDao subscriptionDao = new SubscriptionDao(serverContext.getConnection(), moduleId, event.getUserId());
            LocalDateTime dateClose = TimeUtils.convertDateToLocalDateTime((Date)event.getDateClose());
            dateClose = dateClose.plusDays(1L).minusSeconds(1L);
            for (Subscription subscription : subscriptionDao.list(event.getContractId())) {
                if (!TimeUtils.dateInPeriod((LocalDateTime)dateClose, (PeriodWithTime)subscription.getPeriod())) continue;
                subscription.getPeriod().setLocalDateTimeTo(dateClose);
                subscriptionDao.update(subscription);
            }
        }
    }

    private void contractSubscriptionActivate(BGModule module, PaymentEvent event, EventListenerContext context) throws Exception {
        Date now = new Date();
        int moduleId = module.getId();
        int contractId = event.getContractId();
        Connection con = context.getConnection();
        SubscriptionDao subscriptionDao = new SubscriptionDao(con, moduleId, 0);
        List<Subscription> listAll = subscriptionDao.list(contractId);
        if (listAll != null && !listAll.isEmpty()) {
            ArrayList<Integer> registrationPeriodIds = new ArrayList<Integer>();
            for (Subscription subscription : listAll) {
                PeriodWithTime period = subscription.getPeriod();
                if (!subscription.isAvtoCommit() || period == null || !TimeUtils.dateInRangeWithTime((Date)now, (Date)period.getDateFrom(), (Date)period.getDateTo())) continue;
                registrationPeriodIds.add(subscription.getRegistrationPeriodId());
            }
            ArrayList<Subscription> list = new ArrayList<Subscription>();
            SubscriptionPeriodDao subscriptionPeriodDao = new SubscriptionPeriodDao(con, moduleId, 0);
            Map<Integer, RegistrationPeriod> map = subscriptionPeriodDao.map(registrationPeriodIds);
            for (Subscription subscription : listAll) {
                RegistrationPeriod registrationPeriod = map.get(subscription.getRegistrationPeriodId());
                if (registrationPeriod == null || !registrationPeriod.getPeriod().getDateTo().before(now)) continue;
                list.add(subscription);
            }
            SubscriptionUtils subscriptionUtils = new SubscriptionUtils(con);
            List<TariffModuleTree> tariffModuleTrees = subscriptionUtils.getSubscriptionTariffModuleTree(contractId, now, moduleId);
            if (tariffModuleTrees == null || tariffModuleTrees.size() == 0) {
                this.getLogger().error("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0430 \u0434\u0430\u0442\u0443 - " + TimeUtils.formatDate((Date)now) + " [contractId = " + contractId + "]");
            } else {
                ArrayList<SubscriptionCost> subscriptionCostList = new ArrayList<SubscriptionCost>();
                SubscriptionTypeDao subscriptionTypeDao = new SubscriptionTypeDao(con, moduleId);
                HashMap<Integer, SubscriptionType> subscriptionTypeMap = new HashMap<Integer, SubscriptionType>();
                subscriptionTypeDao.close();
                for (Subscription subscription : list) {
                    int subscriptionTypeId = subscription.getTypeId();
                    SubscriptionType subscriptionType = (SubscriptionType)subscriptionTypeMap.get(subscriptionTypeId);
                    if (subscriptionType == null) {
                        subscriptionType = (SubscriptionType)subscriptionTypeDao.get(subscriptionTypeId);
                        subscriptionTypeMap.put(subscriptionTypeId, subscriptionType);
                    }
                    subscription.setSubscriptionType(subscriptionType);
                    BigDecimal cost = subscriptionUtils.getSubscriptionCost(tariffModuleTrees, now, subscriptionType.getServiceId(), contractId);
                    if (cost == null) {
                        this.getLogger().error("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0432 \u0442\u0430\u0440\u0438\u0444\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 [contractId = " + contractId + "; serviceId = " + subscriptionType.getServiceId() + "; dateTime = " + TimeUtils.formatDate((Date)now) + "]");
                        continue;
                    }
                    subscriptionCostList.add(new SubscriptionCost(this, subscription, cost));
                }
                Collections.sort(subscriptionCostList);
                Collections.reverse(subscriptionCostList);
                BalanceUtils bu = new BalanceUtils(con);
                BigDecimal balanceSumma = bu.getBalance(now, contractId);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                boolean avtoCommitMode = moduleSetup.getBoolean("subscription.avto.commit.off.on.balance", false);
                for (SubscriptionCost subscriptionCost : subscriptionCostList) {
                    BigDecimal cost = subscriptionCost.cost;
                    Subscription subscription = subscriptionCost.subscription;
                    if (balanceSumma.compareTo(cost) == -1) {
                        if (!this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u043d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 [subscriptionId = " + subscription.getId() + "; balanceSumma = " + balanceSumma.toPlainString() + "; subscriptionCost = " + cost.toPlainString() + "]");
                        continue;
                    }
                    if (avtoCommitMode && subscription.isAvtoCommit()) {
                        subscription.setAvtoCommit(false);
                        try {
                            subscriptionDao.update(subscription);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new BGException((Throwable)ex);
                        }
                    }
                    SubscriptionType subscriptionType = subscription.getSubscriptionType();
                    PeriodWithTime newRegistrationPeriod = subscriptionType.getNewRegistrationPeriod(now);
                    subscriptionUtils.subscriptionActivateApply(contractId, subscription.getId(), subscriptionType.getServiceId(), now, cost, newRegistrationPeriod, moduleId, 0, subscriptionDao, bu);
                    subscriptionUtils.addSubscriptionJob(subscription, moduleId, newRegistrationPeriod.getDateTo(), subscriptionDao);
                    EventProcessor.getInstance().publish((Event)new SubscriptionActivateEvent(moduleId, subscription.getContractId(), 0, subscription.getId()));
                }
                bu.close();
            }
        }
    }

    class SubscriptionCost
    implements Comparable<SubscriptionCost> {
        Subscription subscription = null;
        BigDecimal cost = null;

        SubscriptionCost(Module this$0, Subscription subscription, BigDecimal cost) {
            this.subscription = subscription;
            this.cost = cost;
        }

        @Override
        public int compareTo(SubscriptionCost subscriptionCost) {
            return this.cost.compareTo(subscriptionCost.cost);
        }
    }
}

