/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.access.om;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.apps.voice.access.om.OrderManagerDeviceWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.voice.common.om.OrderManager;
import ru.bitel.common.RangeUtils;

public class OrderManagerSet
extends ReentrantLock {
    private static final Logger logger = LogManager.getLogger();
    private final OrderManagerHolder[] orderManagers;
    private volatile boolean alive = true;

    public OrderManagerSet(OrderManagerHolder[] orderManagers) {
        this.orderManagers = orderManagers;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private boolean checkResult(Object result) throws BGException {
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        }
        return true;
    }

    private boolean checkResult(OrderManagerDeviceWorker device, AccountOrderEvent event, Object result) throws BGException {
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Future) {
                if (event.futures == null) {
                    event.futures = new ArrayList(4);
                }
                event.futures.add((Future)result);
                return true;
            }
            return true;
        }
        return true;
    }

    public void destroy() {
        this.alive = false;
        for (int i = 0; i < this.orderManagers.length; ++i) {
            try {
                this.orderManagers[i].orderManager.destroy();
                continue;
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public Object connect() throws BGException {
        logger.info("Connecting to device");
        long millis = System.currentTimeMillis();
        for (int i = 0; i < this.orderManagers.length; ++i) {
            try {
                OrderManagerHolder holder = this.orderManagers[i];
                if (!holder.omEnabled) {
                    logger.info("Skip device with disabled ServiceActivator");
                    holder.enabled = false;
                    continue;
                }
                if (!RangeUtils.inRange((long)millis, (long)millis, (long)holder.timeFromMillis, (long)holder.timeToMillis)) {
                    logger.info("Skip device with closed period");
                    holder.enabled = false;
                    continue;
                }
                holder.enabled = true;
                if (this.checkResult(holder.orderManager.connect())) continue;
                return false;
            }
            catch (Throwable e) {
                throw new BGException(e);
            }
        }
        return true;
    }

    public void disconnect(ServerContext ctx) throws BGException {
        logger.info("Disconnecting from device");
        for (int i = 0; i < this.orderManagers.length; ++i) {
            try {
                OrderManagerHolder holder = this.orderManagers[i];
                if (!holder.enabled) continue;
                this.orderManagers[i].orderManager.disconnect();
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean accountCreate(OrderManagerDeviceWorker device, AccountOrderEvent event) throws Exception {
        logger.info("Invoking accountCreate");
        for (int i = 0; i < this.orderManagers.length; ++i) {
            OrderManagerHolder holder = this.orderManagers[i];
            if (!holder.enabled || event.deviceId != 0 && event.deviceId != holder.deviceId || this.checkResult(device, event, holder.orderManager.accountCreate(event))) continue;
            return false;
        }
        return true;
    }

    public boolean accountModify(OrderManagerDeviceWorker device, AccountOrderEvent event) throws Exception {
        logger.info("Invoking accountModify");
        for (int i = 0; i < this.orderManagers.length; ++i) {
            OrderManagerHolder holder = this.orderManagers[i];
            if (!holder.enabled || event.deviceId != 0 && event.deviceId != holder.deviceId || this.checkResult(device, event, holder.orderManager.accountModify(event))) continue;
            return false;
        }
        return true;
    }

    public boolean accountRemove(OrderManagerDeviceWorker device, AccountOrderEvent event) throws Exception {
        logger.info("Invoking accountRemove");
        for (int i = 0; i < this.orderManagers.length; ++i) {
            OrderManagerHolder holder = this.orderManagers[i];
            if (!holder.enabled || event.deviceId != 0 && event.deviceId != holder.deviceId || this.checkResult(device, event, holder.orderManager.accountRemove(event))) continue;
            return false;
        }
        return true;
    }

    public boolean accountStateModify(OrderManagerDeviceWorker device, AccountOrderEvent event) throws Exception {
        logger.info("Invoking accountStateModify");
        for (int i = 0; i < this.orderManagers.length; ++i) {
            OrderManagerHolder holder = this.orderManagers[i];
            if (!holder.enabled || event.deviceId != 0 && event.deviceId != holder.deviceId || this.checkResult(device, event, holder.orderManager.accountStateModify(event))) continue;
            return false;
        }
        return true;
    }

    public static class OrderManagerHolder {
        public final int deviceId;
        public final OrderManager orderManager;
        public final long timeFromMillis;
        public final long timeToMillis;
        public boolean omEnabled;
        public boolean enabled;

        public OrderManagerHolder(int deviceId, OrderManager orderManager, long timeFromMillis, long timeToMillis, boolean omEnabled) {
            this.deviceId = deviceId;
            this.orderManager = orderManager;
            this.timeFromMillis = timeFromMillis;
            this.timeToMillis = timeToMillis;
            this.omEnabled = omEnabled;
        }
    }
}

