/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;

public class CountryDao
extends AbstractAddressDao<Country>
implements Directory<Country> {
    public CountryDao(Connection con) {
        super(con, "address_country");
    }

    @Override
    protected Country newBean() {
        return new Country();
    }

    protected Country getFromRS(ResultSet rs) throws SQLException, BGException {
        return (Country)super.getBaseFromRS(rs);
    }

    protected void updateImpl(Country country) throws BGException, SQLException {
        Objects.requireNonNull(country);
        Country old = country.getId() > 0 ? (Country)this.get(country.getId()) : null;
        boolean update = old != null;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?" + (update ? " WHERE " : ", ") + "id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, country.getTitle());
            ps.setInt(index++, country.getId());
            ps.executeUpdate();
            if (!update) {
                country.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public List<Country> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<Country> list(String title) throws BGException {
        return super.list("(? OR title LIKE ?)", "title", new Object[]{Utils.isBlankString((String)title), title + "%"});
    }

    @Override
    public Country get(String title) throws BGException {
        return (Country)super.get("title=?", title);
    }

    public void searchCountryList(SearchResult<Country> searchResult, String countryMask) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true" + (String)(countryMask != null && !countryMask.isEmpty() ? " AND " + this.tableName + ".title LIKE ?" : "") + " ORDER BY " + this.tableName + ".title" + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (countryMask != null && !countryMask.isEmpty()) {
                    ps.setString(index++, countryMask);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

