/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.multipart;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;

public class LimitedServletInputStream
extends ServletInputStream {
    private ServletInputStream servletInputStream;
    private int totalExpected;
    private int totalRead = 0;

    public LimitedServletInputStream(ServletInputStream servletInputStream, int totalExpected) {
        this.servletInputStream = servletInputStream;
        this.totalExpected = totalExpected;
    }

    public int read() throws IOException {
        int result = -1;
        if (this.totalRead < this.totalExpected) {
            result = this.servletInputStream.read();
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        int left = this.totalExpected - this.totalRead;
        if (left > 0 && (result = this.servletInputStream.read(b, off, Math.min(left, len))) > 0) {
            this.totalRead += result;
        }
        return result;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int result = -1;
        int left = this.totalExpected - this.totalRead;
        if (left > 0 && (result = this.servletInputStream.readLine(b, off, Math.min(left, len))) > 0) {
            this.totalRead += result;
        }
        return result;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isReady() {
        return false;
    }

    public void setReadListener(ReadListener listener) {
    }
}

