/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.emu;

import java.math.BigDecimal;
import java.util.Map;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.FrkException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;

public class Driver
extends BGLogger
implements ICashCheckDriver {
    @Override
    public void init(Map<String, String> config) {
        Driver.log("init", new Object[0]);
    }

    @Override
    public void touchDriver() {
        this.getLogger().debug("emulator is always ready (;");
    }

    @Override
    public synchronized void buzzer(String operatorPass) {
        Driver.log("buzzer", operatorPass);
    }

    @Override
    public synchronized void printtext(String ... parameters) {
        Driver.log("printtext", new Object[]{parameters});
        System.out.println("#(pass,[lines,])");
    }

    @Override
    public synchronized String name(String operatorPass) {
        Driver.log("name", operatorPass);
        return "driver-emulator";
    }

    @Override
    public synchronized String status(String operatorPass) {
        Driver.log("status", operatorPass);
        return "\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435: OK";
    }

    @Override
    public synchronized void xreport(String adminPass) {
        Driver.log("xreport", adminPass);
    }

    @Override
    public synchronized void zreport(String adminPass) {
        Driver.log("zreport", adminPass);
    }

    @Override
    public synchronized void divreport(String adminPass) {
        Driver.log("divreport", adminPass);
    }

    @Override
    public synchronized String check(String ... parameters) throws PrinterErrorException, DriverException {
        BigDecimal par1;
        Driver.log("check", new Object[]{parameters});
        System.out.println("#(pass,clientsumma,[summ|'STRING',text,division])");
        BigDecimal clientsumma = par1 = FrkUtils.parseBigDecimal(parameters[1]);
        Check commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, null);
        BigDecimal summa = commandCheckParameters.getPaymentsum();
        if (clientsumma.compareTo(summa) < 0) {
            throw new PrinterErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + summa.toPlainString() + ")");
        }
        String change = clientsumma.subtract(summa).toPlainString();
        CheckFiscalData cfd = new CheckFiscalData();
        cfd.comment = "\u044d\u043c\u0443\u043b\u044f\u0442\u043e\u0440";
        return CheckPrintResult.sync(change, cfd).toJson();
    }

    @Override
    public synchronized String checkreturn(String ... parameters) {
        Driver.log("checkreturn", new Object[]{parameters});
        System.out.println("#(pass,clientsumma,[summ|'STRING',text,division])");
        return "?";
    }

    @Override
    public String closecheck_fix(String pass, String summa) {
        Driver.log("closecheck_fix", pass, summa);
        System.out.println("#(pass,summa)");
        return "123456789.0";
    }

    @Override
    public void continueprint(String pass) {
        Driver.log("continueprint", pass);
    }

    @Override
    public String purecommand(String operatorPass, String command) {
        Driver.log("purecommand", operatorPass, command);
        return "emulator ;)";
    }

    @Override
    public void repeatcheck(String operatorPass) {
        Driver.log("repeatcheck", operatorPass);
    }

    @Override
    public synchronized void cancelcheck(String operatorPass) throws FrkException {
        Driver.log("cancelcheck", operatorPass);
    }

    private static synchronized void log(String function, Object ... parameters) {
        System.out.print("driver emulator: " + function + "(");
        if (parameters != null) {
            boolean isfirst = true;
            for (Object param : parameters) {
                if (param instanceof String) {
                    if (isfirst) {
                        isfirst = false;
                    } else {
                        System.out.print(",");
                    }
                    System.out.print("'" + (String)param + "'");
                    continue;
                }
                if (!(param instanceof String[])) continue;
                boolean isfirst0 = true;
                for (String param0 : (String[])param) {
                    if (isfirst0) {
                        isfirst0 = false;
                    } else {
                        System.out.print(",");
                    }
                    System.out.print("'" + param0 + "'");
                }
            }
        }
        System.out.println(")");
    }

    @Override
    public void shutdown() {
        Driver.log("#shutdown", new Object[0]);
    }

    @Override
    public String getStatus() {
        return "good (:";
    }

    @Override
    public void openday(String operatorPass) {
        Driver.log("openday", operatorPass);
    }
}

