/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.common.ParameterMap;

public class JDBCEmailServiceDao
extends AbstarctDaoConstant {
    private Domain domain;
    private static final String TABLE_DOMAINS = "domains";

    public JDBCEmailServiceDao(Connection con, Domain domain) {
        super(con);
        this.domain = domain;
    }

    public void createImpl(Account account) throws BGException {
        String query = "INSERT INTO users (login, name, password, domain, quota, status) VALUES (?,?,?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, account.getAccount());
            ps.setString(2, account.getAccount());
            ps.setString(3, account.getPassword());
            ps.setString(4, this.domain.getName());
            ps.setInt(5, (int)account.getQuota());
            ps.setString(6, String.valueOf(account.getStatus() == 0 ? 1 : 0));
            ps.executeUpdate();
            this.updateForwards(account);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw new BGException((Throwable)e);
        }
    }

    public void modifyImpl(Account account) throws Exception {
        String query = "UPDATE users SET name=?, password=?, quota=?, status=? WHERE login=? AND domain=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, account.getAccount());
            ps.setString(2, account.getPassword());
            ps.setInt(3, (int)account.getQuota());
            ps.setString(4, String.valueOf(account.getStatus() == 0 ? 1 : 0));
            ps.setString(5, account.getAccount());
            ps.setString(6, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            this.updateForwards(account);
        }
    }

    public void cancelImpl(Account account) throws SQLException {
        String query = "DELETE FROM users WHERE login=? AND domain=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
        }
        query = "DELETE FROM aliases WHERE local_part=? AND domain=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "DELETE FROM userforward WHERE local_part=? AND domain=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void removeDomainImpl(Domain domain) throws SQLException {
        String query = "DELETE FROM domains WHERE domain=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, domain.getName());
            ps.executeUpdate();
        }
    }

    public void updateDomainImpl(Domain domain, ParameterMap moduleSetup) throws BGException {
        try {
            ParameterMap params = domain.getParameterMap().inherit(moduleSetup).sub("sa.jdbc.");
            PreparedStatement ps = this.con.prepareStatement("UPDATE domains SET type=?, uid=?, gid=? WHERE domain=?");
            ps.setString(1, params.get("domain.type", "LOCAL"));
            ps.setInt(2, params.getInt("domain.uid", 0));
            ps.setInt(3, params.getInt("domain.gid", 0));
            ps.setString(4, domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO domains (domain, type, uid, gid) VALUES (?,?,?,?)");
                ps.setString(1, domain.getName());
                ps.setString(2, params.get("domain.type", "LOCAL"));
                ps.setInt(3, params.getInt("domain.uid", 0));
                ps.setInt(4, params.getInt("domain.gid", 0));
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateForwards(Account account) throws SQLException {
        PreparedStatement ps;
        StringBuilder sb;
        ArrayList<Forward> forwards = new ArrayList<Forward>();
        ArrayList<Forward> aliases = new ArrayList<Forward>();
        for (Forward forward : account.getForwardList()) {
            if (forward.getEmail().endsWith("@" + this.domain.getName())) {
                aliases.add(forward);
                continue;
            }
            forwards.add(forward);
        }
        if (aliases.size() > 0) {
            sb = new StringBuilder();
            for (Forward a : aliases) {
                sb.append(a.getEmail()).append("\n");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            ps = this.con.prepareStatement("UPDATE aliases SET recipients=? WHERE local_part=? AND domain=?");
            ps.setString(1, sb.toString());
            ps.setString(2, account.getAccount());
            ps.setString(3, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO aliases (local_part, domain, recipients) VALUES (?,?,?)");
                ps.setString(1, account.getAccount());
                ps.setString(2, this.domain.getName());
                ps.setString(3, sb.toString());
                ps.executeUpdate();
            }
            ps.close();
        } else {
            ps = this.con.prepareStatement("DELETE FROM aliases WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
        }
        if (forwards.size() > 0) {
            sb = new StringBuilder();
            for (Forward f : forwards) {
                sb.append(f.getEmail()).append("\n");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            ps = this.con.prepareStatement("UPDATE userforward SET recipients=? WHERE local_part=? AND domain=?");
            ps.setString(1, sb.toString());
            ps.setString(2, account.getAccount());
            ps.setString(3, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO userforward (local_part, domain, recipients) VALUES (?,?,?)");
                ps.setString(1, account.getAccount());
                ps.setString(2, this.domain.getName());
                ps.setString(3, sb.toString());
                ps.executeUpdate();
            }
            ps.close();
        } else {
            ps = this.con.prepareStatement("DELETE FROM userforward WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
        }
    }
}

