/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.Radius;
import bitel.billing.server.radius.RadiusSetup;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.Utils;

public class RadiusManager {
    private Radius radius;
    private RadiusSetup setup;

    public RadiusManager(RadiusSetup setup, Radius radius) {
        this.radius = radius;
        this.setup = setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCommand(String[] args) {
        Socket socket = null;
        try {
            StringBuffer command = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                command.append(args[i] + " ");
            }
            DefaultServerSetup sd = new DefaultServerSetup("radius");
            int adm_port = sd.getInt("admin.port", 1899);
            socket = new Socket(InetAddress.getByName("127.0.0.1"), adm_port);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String trimCommand = command.toString().trim();
            out.println(trimCommand);
            String line = null;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getLocalizedMessage());
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|help|status|ps|kill|flush_script_cache|sysvar|javavar|conpool]");
        sb.append("\nParametrs:");
        sb.append("\n\t help|?                      - show this help");
        sb.append("\n\t start                       - starting RADIUS server");
        sb.append("\n\t stop                        - stopping RADIUS server");
        sb.append("\n\t status                      - current RADIUS status");
        sb.append("\n\t sysvar                      - show system variables");
        sb.append("\n\t javavar                     - show java properties");
        sb.append("\n\t conpool                     - show connection pool trace, need option db.trace=1 in radius.properties");
        sb.append("\n\nExample: radius.sh start");
        sb.append("\n\nExample: radius.sh kill -nas supernas.bayan.com -login 11");
        System.out.println(sb.toString());
    }

    public static void parseParams(String[] args) {
        if (args[0].equals("help") || args[0].equals("?")) {
            RadiusManager.showHelp();
        } else {
            RadiusManager.sendCommand(args);
        }
    }

    public String executeCommand(String command, String params) {
        String result = "UNKNOWN COMMAND!";
        if (command.equals("stop")) {
            result = "OK Stopping...";
        } else if (command.equals("gc")) {
            result = "OK GarbageCollector forsed..";
            System.gc();
        } else if (command.equals("enable_radius_log")) {
            result = "OK RADIUS log enable...";
            RadiusUtils.logEnable = true;
        } else if (command.equals("disable_radius_log")) {
            result = "OK RADIUS log disable...";
            RadiusUtils.logEnable = false;
        } else if (command.equals("status")) {
            result = this.radius.getProcessor().getStatus();
        } else if (command.equals("conpool")) {
            result = this.setup.getPoolStackTrace();
        } else if (command.equals("sysvar")) {
            result = Utils.getSystemVariables();
        } else if (command.equals("javavar")) {
            result = Utils.getJavaProperties();
        } else {
            String cmdResult = this.radius.getProcessor().executeCommand(command, params);
            if (cmdResult != null) {
                result = cmdResult;
            }
        }
        return result;
    }
}

