/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;

public class IntegerInfo
extends RadiusAttributeInfo<Integer> {
    public IntegerInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 4, attr, children);
    }

    protected IntegerInfo(int vendor, int code, String name, int valueType, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, valueType, attr, children);
    }

    @Override
    public Integer unwrapValue(ByteBuffer data) {
        if (this.tag == 1) {
            byte b2 = data.get(0);
            byte b1 = data.get(1);
            byte b0 = data.get(2);
            return (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
        }
        return data.getInt(0);
    }

    @Override
    public ByteBuffer wrapValue(Integer _value) {
        if (this.tag == 1) {
            ByteBuffer bb = ByteBuffer.allocate(3);
            int value = _value;
            bb.put(2, (byte)(value & 0xFF));
            bb.put(1, (byte)((value >>= 8) & 0xFF));
            bb.put(0, (byte)((value >>= 8) & 0xFF));
            return bb;
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(_value);
        bb.rewind();
        return bb;
    }
}

