<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<script type="text/javascript">

var cardQuery = { action: 'Card', mid: 'm${moduleId}' };

showBlock( 'cardRoot', 'cardActivate', cardQuery );

</script>

<bg:pageTitle/>

<div id="cardRoot"></div>

<%--

	<xsl:template name="title">
		<xsl:choose>
			<xsl:when test="data/@action = 'ReportDealers'">Платежи дилеров</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="/data">
		<xsl:choose>
			<xsl:when test="@action = 'ReportDealers'">
				<xsl:call-template name="ReportDealers"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

<xsl:template name="ReportFilters">
	<table class="filter">
		<tr><td colspan="2">Дилеры</td></tr>
		<tr>
			<td rowspan="4">
				<select size='10' style="width:95%" name='items' multiple='1'>
				  <xsl:for-each select="items/item">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				  </xsl:for-each>
				</select><br/>
				<em class='comment'>Для выделения сразу нескольких<br/>дилеров держите нажатой клавишу 'Ctrl'</em>
			</td>
			<td style="padding-top:10px;">
				<table><tr>
				<td>Месяц:</td>
				<td><select class="gradbtn " name='month'>
						<xsl:call-template name="month_list"/>
				</select></td>
				<td>Год:</td>
				<td><select class="gradbtn " name='year' style="margin-right:0px">
						<xsl:call-template name="year_list"/>
				</select></td>
				</tr></table>
			</td>
		</tr>
		<tr>
			<td style="padding-top: 10px;">
				<table width="100%"><tr>
					<td nowrap="nowrap">Числа месяца:</td>
					<td width="50%" style="text-align:center">c</td>
					<td><input type="text" name="day_from" size="4" ><xsl:attribute name="value"><xsl:value-of select="date/@day_from"/></xsl:attribute></input></td>
					<td width="50%" style="text-align:center">по</td>
					<td><input type="text" name="day_to" size="4" ><xsl:attribute name="value"><xsl:value-of select="date/@day_to"/></xsl:attribute></input></td>
				</tr></table>
			</td>
		</tr>
		<tr> 
         <td valign="bottom" style="padding-right:20px;">
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Вывести'"/>
			</xsl:call-template>
         </td>
		</tr>
		</table>
</xsl:template>

<xsl:template name="ReportDealers">
	<form method='post' action='{$WEBEXECUTER}' name="report" id="reportForm" >
	<input type="hidden" name="pageIndex" value="{/data/dealers/@pageIndex}"/>
	<input type="hidden" name="pageSize" value="{/data/dealers/@pageSize}"/>
	<xsl:call-template name="action"/>
	<xsl:call-template name="action"/>
	<xsl:call-template name="ReportFilters"/>
	</form>

	<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
		
	<xsl:if test="dealers">
		<div>
		Отчет в виде:
		<a title="CSV" href="{$WEBEXECUTER}?module=card&amp;mid={/data/@mid}&amp;action=ReportDealers{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=csv">CSV</a>,
		<a title="HTML" href="{$WEBEXECUTER}?module=card&amp;mid={/data/@mid}&amp;action=ReportDealers{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=html">HTML</a>,
		<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=card&amp;mid={/data/@mid}&amp;action=ReportDealers{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=card&amp;mid={/data/@mid}&amp;action=ReportDealers{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
		</div>
	</xsl:if>
				
	<div class="report">

			<xsl:if test="dealers">
				<table border='0' cellspacing='1'>
				<thead>
					<tr>
						<td>Дата/время платежа</td>
						<td>Номер транзакции</td>
						<td>Номер договора</td>
						<td>Тип платежа</td>
						<td>Сумма платежа, руб.</td>
					</tr>
				 </thead>
				 <tbody>
				 <xsl:for-each select="dealers/dealer">
				 	 <tr>
				 	 	<td style="text-align : left ! important; font-weight: bold ! important;" colspan="5">Дилер:&#160;<xsl:value-of select="@title"/></td>
				 	 </tr>
				 	 <xsl:for-each select="payment">
						 <tr>
							 <td><xsl:value-of select="@datetime"/></td>
							 <td><xsl:value-of select="@trans"/></td>
							 <td><xsl:value-of select="@contract"/></td>
							 <td><xsl:value-of select="@pt"/></td>
							 <td><xsl:value-of select="@summa"/></td>
						 </tr>
					 </xsl:for-each>
					 
					 <tr>
						<td style="text-align : left ! important; font-weight: bold ! important;" colspan="3">Итого по дилеру&#160;<xsl:value-of select="@title"/>:</td>
						<td style="font-weight: bold ! important;"><xsl:value-of select="@totalnumber"/>&#160;шт.</td>
						<td style="font-weight: bold ! important;"><xsl:value-of select="@totalsumm"/>&#160;руб.</td>
					 </tr>
				</xsl:for-each>
				</tbody>
				<tfoot>		
				  <tr>
					<td colspan="3">Итого по всем дилерам:&#160;</td>
					<td><xsl:value-of select="dealers/@totalnumber"/>&#160;шт.</td>
					<td><xsl:value-of select="dealers/@totalsumm"/>&#160;руб.</td>
				  </tr>   
				 </tfoot>       
				</table>
			</xsl:if>

	</div>

</xsl:template>

</xsl:stylesheet>

--%>