/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;

public class DocumentJournalDao
extends AbstractDao<DocumentJournal>
implements Directory<DocumentJournal> {
    public DocumentJournalDao(Connection con) {
        super(con, "documents_journal", 0);
    }

    protected void updateImpl(DocumentJournal b) throws BGException, SQLException {
        String query = b.getId() <= 0 ? "INSERT INTO " + this.tableName + "(title) VALUES (?)" : "UPDATE " + this.tableName + " SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public DocumentJournal get(int id) throws BGException {
        DocumentJournal result = null;
        try {
            result = (DocumentJournal)this.getById(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public List<DocumentJournal> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }

    public int delete(int id) throws Exception {
        return this.deleteImpl(id);
    }

    public DocumentJournal get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected DocumentJournal getFromRS(ResultSet rs) throws SQLException, BGException {
        return new DocumentJournal(rs.getInt("id"), rs.getString("title"));
    }
}

