/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneServiceCost;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class NPrefixTariffTreeNode
extends DefaultTariffTreeNode<AbstractPhoneTariffRequest<AbstractPhoneServiceCost>, TariffContext> {
    private final RangeParser rangeParser;
    private final int dest;
    private final int zone;

    public NPrefixTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        RangeParser rangeParser = null;
        try {
            rangeParser = new RangeParser(parameterMap.get("prefix", ""));
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        this.rangeParser = rangeParser;
        this.dest = parameterMap.getInt("dest", 0);
        this.zone = parameterMap.getInt("zone", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffContext context) {
        if (req.phoneTo != null && this.rangeParser != null && !req.isAccepted()) {
            String phoneRest = req.phoneToRest;
            if (phoneRest == null) {
                phoneRest = req.phoneTo;
            }
            RangeParser.CheckResult result = this.rangeParser.checkPrefixWithResult(phoneRest);
            if (result.result) {
                req.phoneToRest = phoneRest = phoneRest.substring(result.length);
                if (this.dest > 0) {
                    req.dest = this.dest;
                }
                if (this.zone > 0) {
                    req.zone = this.zone;
                }
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int postExecuteImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffContext ctx, int executeResult) {
        if (executeResult == 1) {
            req.setAccepted(true);
        }
        return executeResult;
    }
}

