/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TariffOptionActivateModeDao {
    private Connection con;

    public TariffOptionActivateModeDao(Connection con) {
        this.con = con;
    }

    public TariffOptionActivateMode get(int modeId) throws BGException {
        TariffOptionActivateMode result = null;
        String query = "SELECT * FROM tariff_option_activate_mode AS mode WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, modeId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs, false);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<TariffOptionActivateMode> getOptionActivateModeList(int optionId, Date date) throws BGException {
        ArrayList<TariffOptionActivateMode> result = new ArrayList<TariffOptionActivateMode>();
        Object query = "SELECT mode.*, type.title FROM tariff_option_activate_mode AS mode LEFT JOIN contract_charge_types AS type ON mode.charge_type_id=type.id WHERE mode.option_id=? ";
        if (date != null) {
            query = (String)query + "AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
        }
        query = (String)query + "ORDER BY id";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, optionId);
            if (date != null) {
                java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
                ps.setDate(2, sqlDate);
                ps.setDate(3, sqlDate);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateTariffOptionActivateModeList(int optionId, List<TariffOptionActivateMode> modeList) throws BGException {
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO tariff_option_activate_mode SET option_id=?, title=?, charge_type_id=?, charge_summa=?, period_mode=?, period_col=?, period_activate=?, deactivation_mode=?, reactivation_mode=?, delete_mode=?, delete_charge_mode=?, date1=?, date2=?", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE tariff_option_activate_mode SET title=?, charge_type_id=?, charge_summa=?, period_mode=?, period_col=?, period_activate=?, deactivation_mode=?, reactivation_mode=?, delete_mode=?, delete_charge_mode=?, date1=?, date2=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            for (TariffOptionActivateMode mode : modeList) {
                this.update(optionId, mode, insertPS, updatePS);
                ids.add(mode.getId());
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM tariff_option_activate_mode WHERE option_id=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, optionId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int optionId, TariffOptionActivateMode mode, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        int index;
        if (mode.getId() > 0) {
            index = 1;
            updatePS.setString(index++, mode.getTitle());
            updatePS.setInt(index++, mode.getChargeTypeId());
            updatePS.setBigDecimal(index++, mode.getChargeSumma());
            updatePS.setInt(index++, mode.getPeriodMode());
            updatePS.setInt(index++, mode.getPeriodCol());
            updatePS.setString(index++, mode.getActivatePeriod());
            updatePS.setInt(index++, mode.getDeactivationMode());
            updatePS.setInt(index++, mode.getReactivationMode());
            updatePS.setInt(index++, mode.getDeleteMode());
            updatePS.setInt(index++, mode.getDeleteChargeMode());
            updatePS.setDate(index++, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            updatePS.setDate(index++, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            updatePS.setInt(index++, mode.getId());
            if (updatePS.executeUpdate() == 0) {
                mode.setId(-1);
            }
        }
        if (mode.getId() <= 0) {
            index = 1;
            insertPS.setInt(index++, optionId);
            insertPS.setString(index++, mode.getTitle());
            insertPS.setInt(index++, mode.getChargeTypeId());
            insertPS.setBigDecimal(index++, mode.getChargeSumma());
            insertPS.setInt(index++, mode.getPeriodMode());
            insertPS.setInt(index++, mode.getPeriodCol());
            insertPS.setString(index++, mode.getActivatePeriod());
            insertPS.setInt(index++, mode.getDeactivationMode());
            insertPS.setInt(index++, mode.getReactivationMode());
            insertPS.setInt(index++, mode.getDeleteMode());
            insertPS.setInt(index++, mode.getDeleteChargeMode());
            insertPS.setDate(index++, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            insertPS.setDate(index++, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            insertPS.executeUpdate();
            mode.setId(ServerUtils.lastInsertId(insertPS));
        }
    }

    protected TariffOptionActivateMode getFromRS(ResultSet rs, boolean typeTitleLoad) throws SQLException {
        TariffOptionActivateMode result = new TariffOptionActivateMode();
        result.setId(rs.getInt("mode.id"));
        result.setOptionId(rs.getInt("mode.option_id"));
        result.setTitle(rs.getString("mode.title"));
        result.setChargeTypeId(rs.getInt("mode.charge_type_id"));
        result.setChargeSumma(rs.getBigDecimal("mode.charge_summa"));
        result.setPeriodMode(rs.getInt("mode.period_mode"));
        result.setPeriodCol(rs.getInt("mode.period_col"));
        result.setActivatePeriod(rs.getString("mode.period_activate"));
        result.setDeactivationMode(rs.getInt("mode.deactivation_mode"));
        result.setReactivationMode(rs.getInt("mode.reactivation_mode"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setDeleteMode(rs.getInt("mode.delete_mode"));
        result.setDeleteChargeMode(rs.getInt("mode.delete_charge_mode"));
        if (typeTitleLoad) {
            result.setChargeTypeTitle(rs.getString("type.title"));
        }
        return result;
    }
}

