/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.bean.Unit;
import ru.bitel.bgbilling.modules.subscription.common.bean.ValueUnit;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGControlPanelTextArea;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class SubscriptionTypePanel
extends BGUPanel {
    private SubscriptionService subscriptionService;
    private SubscriptionTypeTableModel model = new SubscriptionTypeTableModel();

    public SubscriptionTypePanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    private SubscriptionService getSubscriptionService() {
        if (this.subscriptionService == null) {
            this.subscriptionService = (SubscriptionService)((ClientContext)this.getContext()).getWebService(SubscriptionService.class);
        }
        return this.subscriptionService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getSubscriptionService().subscriptionTypeList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new SubscriptionTypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", new SubscriptionType()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.model.optSelectedRow().ifPresentOrElse(current -> new SubscriptionTypeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", (SubscriptionType)current).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0435\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            SubscriptionType current = (SubscriptionType)this.model.getSelectedRow();
            if (current != null && BGSwingUtilites.confirmDelete((String)"SubscriptionType", (Object)current)) {
                this.getSubscriptionService().subscriptionTypeDelete(current.getId());
                this.performAction("refresh");
            }
        });
    }

    class SubscriptionTypeTableModel
    extends BGTableModel<SubscriptionType> {
        public SubscriptionTypeTableModel() {
            super(SubscriptionTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ID \u0443\u0441\u043b\u0443\u0433\u0438 ", -1, 80, 80, "serviceId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 180, 200, "period", true, (TableCellRenderer)new PeriodTableCellRenderer());
            this.addColumn("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", -1, 100, 100, "duration", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430", -1, 100, 100, "delay", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435", -1, 100, 100, "round", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435", -1, 110, 110, "avtoCommit", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class SubscriptionTypeEditor
    extends BGEditorDialog<SubscriptionType> {
        private BGTextField title;
        private BGUComboBox<Service> subscriptionServiceList;
        private BGControlPanelPeriod controlPanelPeriod;
        private ValueUnitPanel durationPanel;
        private ValueUnitPanel delayPanel;
        private ValueUnitPanel roundPanel;
        private BGControlPanelTextArea comment;
        private JCheckBox avtoCommit;
        private BGConfigEditorPane config;
        private JTabbedPane tabPane;

        public SubscriptionTypeEditor(String title, SubscriptionType data) {
            super(title, (Object)data);
            this.title = new BGTextField();
            this.subscriptionServiceList = new BGUComboBox();
            this.controlPanelPeriod = new BGControlPanelPeriod();
            this.durationPanel = new ValueUnitPanel("\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c:");
            this.delayPanel = new ValueUnitPanel("\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430:");
            this.roundPanel = new ValueUnitPanel("\u041e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435:");
            this.comment = new BGControlPanelTextArea(3);
            this.avtoCommit = new JCheckBox("\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
            this.config = new BGConfigEditorPane();
            this.tabPane = new JTabbedPane();
        }

        public void doDialogPanel() {
            this.comment.setBorder(null);
            this.tabPane.add((Component)this.getPanel(), "\u041e\u0431\u0449\u0430\u044f");
            this.tabPane.add((Component)this.comment, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
            this.tabPane.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)this.config), (boolean)true), "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            this.panel.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.tabPane.setSelectedIndex(0);
            try {
                this.title.setText(((SubscriptionType)this.data).getTitle());
                this.comment.setText(((SubscriptionType)this.data).getComment());
                this.config.setText(((SubscriptionType)this.data).getConfig());
                this.subscriptionServiceList.setData(((ModuleService)((ClientContext)SubscriptionTypePanel.this.getContext()).getPort(ModuleService.class, 0)).serviceList(((ClientContext)SubscriptionTypePanel.this.getContext()).getModuleId()));
                this.subscriptionServiceList.setSelectedItem((Object)((SubscriptionType)this.data).getServiceId());
                this.controlPanelPeriod.setPeriod(((SubscriptionType)this.data).getPeriod());
                this.durationPanel.setData(((SubscriptionType)this.data).getDuration());
                this.delayPanel.setData(((SubscriptionType)this.data).getDelay());
                this.roundPanel.setData(((SubscriptionType)this.data).getRound());
                this.avtoCommit.setSelected(((SubscriptionType)this.data).isAvtoCommit());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        private JPanel getPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.33, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 0.33, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, 2, 1, 1, 0.33, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.subscriptionServiceList, new GridBagConstraints(0, 3, 1, 1, 0.33, 0.0, 17, 2, new Insets(2, 5, 5, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriod, new GridBagConstraints(0, 4, 1, 1, 0.33, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.durationPanel, new GridBagConstraints(0, 5, 1, 1, 0.33, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.delayPanel, new GridBagConstraints(0, 6, 1, 1, 0.33, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.roundPanel, new GridBagConstraints(0, 7, 1, 1, 0.33, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.avtoCommit, new GridBagConstraints(0, 8, 1, 1, 0.33, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            int height = panel.getPreferredSize().height;
            panel.setMinimumSize(new Dimension(500, height));
            panel.setPreferredSize(new Dimension(500, height));
            return panel;
        }

        public boolean doApply() throws Exception {
            if (this.roundPanel.getData().getValue() < 1L) {
                ClientUtils.showErrorMessageDialog((String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \"\u041e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435\" \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \"1\"");
                return false;
            }
            ((SubscriptionType)this.data).setTitle(this.title.getText());
            ((SubscriptionType)this.data).setComment(this.comment.getText());
            ((SubscriptionType)this.data).setServiceId(((Service)this.subscriptionServiceList.getSelectedItem()).getId());
            ((SubscriptionType)this.data).setPeriod(this.controlPanelPeriod.getPeriod());
            ((SubscriptionType)this.data).setDuration(this.durationPanel.getData());
            ((SubscriptionType)this.data).setDelay(this.delayPanel.getData());
            ((SubscriptionType)this.data).setRound(this.roundPanel.getData());
            ((SubscriptionType)this.data).setConfig(this.config.getText());
            ((SubscriptionType)this.data).setAvtoCommit(this.avtoCommit.isSelected());
            int id = SubscriptionTypePanel.this.getSubscriptionService().subscriptionTypeUpdate((SubscriptionType)this.data);
            SubscriptionTypePanel.this.performAction("refresh");
            SubscriptionTypePanel.this.model.setSelectedRow(id);
            return true;
        }
    }

    class ValueUnitPanel
    extends JPanel {
        private ValueTextField valueTextField;
        private BGUComboBox<Unit> unitComboBox;

        ValueUnitPanel(String title) {
            super(new GridBagLayout());
            this.valueTextField = new ValueTextField();
            this.unitComboBox = new BGUComboBox();
            this.unitComboBox.setData(Arrays.asList(Unit.values()));
            JLabel label = new JLabel(title);
            int height = label.getPreferredSize().height;
            label.setMinimumSize(new Dimension(170, height));
            label.setPreferredSize(new Dimension(170, height));
            this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)((Object)this.valueTextField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.unitComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        public void setData(ValueUnit valueUnit) {
            if (valueUnit != null) {
                this.valueTextField.setText(String.valueOf(valueUnit.getValue()));
                this.unitComboBox.setSelectedItem((Object)valueUnit.getUnit());
            }
        }

        public ValueUnit getData() {
            return new ValueUnit(Utils.parseLong((String)this.valueTextField.getText()), (Unit)this.unitComboBox.getSelectedItem());
        }
    }

    class ValueTextField
    extends BGTextField {
        ValueTextField() {
            this.setHorizontalAlignment(4);
        }
    }
}

