/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ReportFieldsTabelPanel
extends JPanel {
    private BGUTable fieldsTable;
    private BGTableModel<KeyValue> tableModel;
    private final BGDialogToolBar toolBar = new BGDialogToolBar();
    private final List<KeyValue> fields = new LinkedList<KeyValue>();
    private final ActionListener toolBarActionListener = e -> {
        if ("newItem".equals(e.getActionCommand())) {
            if (this.fieldsTable.getRowCount() > 0) {
                TableColumn tableColumn = this.fieldsTable.getColumnModel().getColumn(1);
                ReportFieldsTableCellEditor editor = (ReportFieldsTableCellEditor)tableColumn.getCellEditor();
                String value = editor.textField.getText();
                KeyValue lastElement = this.fields.get(this.fields.size() - 1);
                if (Utils.notBlankString((String)lastElement.getKey()) && (Utils.notBlankString((String)lastElement.getValue()) || Utils.notBlankString((String)value))) {
                    TableCellEditor cellEditor = this.fieldsTable.getCellEditor();
                    if (cellEditor != null) {
                        cellEditor.stopCellEditing();
                    }
                    this.fields.add(new KeyValue());
                    this.tableModel.setData(this.fields);
                    this.fieldsTable.getSelectionModel().setSelectionInterval(this.fieldsTable.getRowCount() - 1, this.fieldsTable.getRowCount() - 1);
                    cellEditor = tableColumn.getCellEditor();
                    if (cellEditor != null) {
                        this.fieldsTable.editCellAt(this.fieldsTable.getRowCount() - 1, 0);
                    }
                }
            } else {
                this.fields.add(new KeyValue());
                this.tableModel.setData(this.fields);
            }
        }
        if ("deleteItem".equals(e.getActionCommand()) && this.tableModel.getSelectedRow() != null) {
            this.fields.remove(this.tableModel.getSelectedRow());
            this.tableModel.setData(this.fields);
            if (this.fieldsTable.getRowCount() > 0) {
                this.fieldsTable.getSelectionModel().setSelectionInterval(this.fieldsTable.getRowCount() - 1, this.fieldsTable.getRowCount() - 1);
            }
        }
    };

    public ReportFieldsTabelPanel() {
        this("\u041a\u043e\u043b\u043e\u043d\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430");
    }

    public ReportFieldsTabelPanel(String borderTitle) {
        BGSwingUtilites.wrapBorder((JPanel)this, (String)borderTitle);
        this.initTable();
        this.toolBar.setDefaultButtons(this.toolBarActionListener);
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.toolBar.setToolBar(new String[]{"newItem", "deleteItem"});
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane((Component)this.fieldsTable), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Map<String, String> getFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.fields.forEach(field -> result.put(field.getKey(), field.getValue()));
        return result;
    }

    public void addField(String key, String value) {
        this.fields.add(new KeyValue(key, value));
    }

    public void setData(Map<String, String> data) {
        this.fields.clear();
        data.forEach((k, v) -> this.addField((String)k, (String)v));
        if (this.tableModel == null) {
            throw new NullPointerException("TableModel is null");
        }
        this.tableModel.setData(this.fields);
    }

    public void clear() {
        this.fields.clear();
        this.tableModel.setData(this.fields);
    }

    private void initTable() {
        this.tableModel = new BGTableModel<KeyValue>("fields", KeyValue.class){

            protected void initColumns() {
                this.addColumn("ID", String.class, -1, 200, -1, "key", false, true, null);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 200, -1, "value", false, true, null);
            }
        };
        this.fieldsTable = new BGUTable(this.tableModel);
        this.fieldsTable.getColumnModel().getColumn(0).setCellEditor(new ReportFieldsTableCellEditor(this));
        this.fieldsTable.getColumnModel().getColumn(1).setCellEditor(new ReportFieldsTableCellEditor(this));
    }

    public BGDialogToolBar getToolBar() {
        return this.toolBar;
    }

    private final class ReportFieldsTableCellEditor
    implements TableCellEditor {
        JTextField textField = new JTextField();
        DefaultCellEditor defaultCellEditor;

        public ReportFieldsTableCellEditor(ReportFieldsTabelPanel reportFieldsTabelPanel) {
            this.textField.setBorder(new LineBorder(Color.darkGray));
            this.textField.setFont(new Font("Dialog", 0, 14));
            this.defaultCellEditor = new DefaultCellEditor(this.textField);
            JPanel editor = new JPanel(new GridBagLayout());
            editor.add(this.textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.defaultCellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.defaultCellEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.defaultCellEditor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.defaultCellEditor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.defaultCellEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.defaultCellEditor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.defaultCellEditor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.defaultCellEditor.removeCellEditorListener(l);
        }
    }
}

